# Learning Task 6: Using Development Skills

**Skill**: Project-specific (frontend-component, backend-endpoint, etc.)
**Time**: 5-7 minutes
**Difficulty**: Intermediate

## Why This Matters

Development skills generate boilerplate code following your project's patterns. Instead of writing everything from scratch, you describe what you need and Navigator creates consistent, tested code.

## The Task

Based on your project type, complete ONE of these:

---

### Option A: Frontend Projects (React/Vue/Angular)

**DO THIS NOW:**
```
Type: "Create component OnboardingDemo"
```

**WHAT SHOULD HAPPEN:**
1. Component file created with TypeScript
2. Test file generated
3. Styles scaffolded (CSS modules, styled-components, or Tailwind)

You should see files like:
```
src/components/OnboardingDemo/
├── OnboardingDemo.tsx
├── OnboardingDemo.test.tsx
├── OnboardingDemo.styles.ts (or .module.css)
└── index.ts
```

---

### Option B: Backend Projects (Express/FastAPI/Go)

**DO THIS NOW:**
```
Type: "Add endpoint /api/onboarding-demo"
```

**WHAT SHOULD HAPPEN:**
1. Route handler created
2. Validation schema generated
3. Test file scaffolded

You should see files like:
```
src/routes/onboarding-demo.ts (or .py)
src/routes/onboarding-demo.test.ts
```

---

### Option C: Fullstack Projects

Choose either Option A or B based on what you're working on.

---

### Option D: Other Project Types

If your project doesn't match above:
```
Type: "Show me available Navigator skills"
```

Review what skills are available for your stack.

## Validation

This task is complete when:
- [ ] Component OR endpoint created
- [ ] Files generated match project patterns
- [ ] You understand how the skill works

**Note**: File locations depend on your project structure.

## Pro Tip

Development skills learn from your project:
- Detect TypeScript vs JavaScript
- Match existing file structure
- Use project's testing library
- Follow your naming conventions

The generated code is a starting point - customize as needed.

**Workflow integration:**
```
nav-start → Load task doc → Use dev skills → nav-task archive → nav-marker → nav-compact
```

## What You Learned

1. Dev skills generate consistent boilerplate
2. They detect your project patterns
3. Files are customizable starting points

---

**When done, say "done" to continue.**

You've completed all learning tasks! Navigator will now generate your personalized workflow guide.
