# vim-ai Documentation Sources

This document provides URLs to fetch the latest vim-ai plugin documentation. Always fetch fresh documentation using WebFetch rather than relying on cached or copied content.

## Official Documentation

### Primary GitHub Repository
- **URL**: `https://github.com/madox2/vim-ai`
- **Contains**: Complete README with installation, configuration, usage examples
- **Use for**: Installation instructions, basic configuration, troubleshooting

### README.md
- **URL**: `https://raw.githubusercontent.com/madox2/vim-ai/master/README.md`
- **Contains**: Full documentation in markdown format
- **Use for**: Quick reference, configuration examples, command syntax

## Configuration Examples

### Default Roles File
- **URL**: `https://raw.githubusercontent.com/madox2/vim-ai/master/roles-default.ini`
- **Contains**: Built-in default roles provided by the plugin
- **Use for**: Understanding role syntax, finding default roles

### Example Roles File
- **URL**: `https://raw.githubusercontent.com/madox2/vim-ai/master/roles-example.ini`
- **Contains**: Additional example roles for inspiration
- **Use for**: Creating custom roles, advanced role configurations

## Help Documentation

### Vim Help Files
- **Location**: `~/.vim/pack/plugins/start/vim-ai/doc/vim-ai.txt` (after installation)
- **Access in Vim**: `:help vim-ai`
- **Contains**: Complete plugin documentation viewable in Vim
- **Use for**: Detailed configuration options, command reference

## Source Code References

### Python Implementation
- **Directory**: `https://github.com/madox2/vim-ai/tree/master/py`
- **Contains**: Python source code for AI interactions
- **Use for**: Understanding how the plugin works, debugging issues

### Plugin Configuration
- **File**: `https://github.com/madox2/vim-ai/blob/master/plugin/vim-ai.vim`
- **Contains**: Plugin initialization and default settings
- **Use for**: Understanding default configurations, available options

## How to Fetch Documentation

### Using WebFetch
```
WebFetch the URL with a specific prompt about what information you need
```

### Example Queries
- "How to configure custom AI models" → Fetch main README
- "How to create custom roles" → Fetch roles-example.ini
- "What are all available configuration options" → Fetch README and help docs
- "How to change the API endpoint" → Fetch README configuration section

## Key Configuration Sections to Reference

When helping users, fetch the relevant section from the README:

1. **Installation**: How to install the plugin
2. **Configuration**: Available `g:vim_ai_*` options
3. **Commands**: `:AI`, `:AIEdit`, `:AIChat`, etc.
4. **Key Mappings**: How to set up keyboard shortcuts
5. **Custom Roles**: How to define reusable prompts
6. **API Configuration**: Setting up API keys and endpoints
7. **Model Configuration**: Changing AI models and parameters

## Important Notes

- Always fetch documentation fresh rather than using cached versions
- The main README is the authoritative source for current features
- Check the GitHub issues page for known problems: `https://github.com/madox2/vim-ai/issues`
- For version-specific features, check the releases page: `https://github.com/madox2/vim-ai/releases`

## Alternative AI Providers

The plugin supports OpenAI-compatible endpoints. Check the README for:
- Azure OpenAI configuration
- Local AI models (like Ollama, LM Studio)
- Other OpenAI-compatible APIs

Fetch the relevant sections from the README when users ask about these alternatives.
