# vim-ai Configuration File Paths

This document lists all file paths for vim-ai configuration. Always verify these paths exist before attempting modifications.

## Primary Configuration Files

### Vim Configuration
- **Vim**: `~/.vimrc`
- **Neovim**: `~/.config/nvim/init.vim` or `~/.config/nvim/init.lua`

**Purpose**: Contains vim-ai plugin settings, model configurations, API endpoint settings, keyboard mappings, and UI preferences.

### API Key Storage
- **Default location**: `~/.config/openai.token`
- **Custom location**: Defined by `g:vim_ai_token_file_path` in vimrc

**Purpose**: Stores OpenAI API key (or other provider keys). Should have 600 permissions for security.

### Custom Roles Configuration
- **Default location**: `~/.vim/vim-ai-roles.ini` (Vim) or `~/.config/nvim/vim-ai-roles.ini` (Neovim)
- **Custom location**: Defined by `g:vim_ai_roles_config_file` in vimrc

**Purpose**: Contains custom roles (reusable prompts) for specific tasks like code review, documentation, testing, etc.

## Plugin Installation Paths

### Vim (using native packages)
- **Installation path**: `~/.vim/pack/plugins/start/vim-ai/`
- **Plugin files**: Contains the vim-ai plugin source code

### Neovim (using native packages)
- **Installation path**: `~/.local/share/nvim/site/pack/plugins/start/vim-ai/`
- **Alternative**: `~/.config/nvim/pack/plugins/start/vim-ai/`

### Package Manager Paths
- **vim-plug**: Defined by `plug#begin()` call in vimrc (commonly `~/.vim/plugged/vim-ai/`)
- **Packer.nvim**: `~/.local/share/nvim/site/pack/packer/start/vim-ai/`
- **Lazy.nvim**: `~/.local/share/nvim/lazy/vim-ai/`

## Configuration File Formats

### .vimrc / init.vim Settings
Format: Vimscript with `let g:vim_ai_*` variables

### init.lua Settings
Format: Lua configuration with `vim.g.vim_ai_*` variables

### Roles Configuration (.ini)
Format: INI file with `[role-name]` sections and `prompt=` keys

## How to Determine Current Setup

1. **Check which editor**: Ask user if they use Vim or Neovim
2. **Check config file location**:
   - Vim: `test -f ~/.vimrc && echo "exists"`
   - Neovim: `test -f ~/.config/nvim/init.vim && echo "exists"` or check for `init.lua`
3. **Check plugin installation**: Look in the paths above based on installation method
4. **Check custom paths**: Read vimrc to find `g:vim_ai_token_file_path` and `g:vim_ai_roles_config_file`

## User-Specific Paths

The current user's paths based on installation:
- Vim config: `~/.vimrc`
- Plugin path: `~/.vim/pack/plugins/start/vim-ai/`
- API key: `~/.config/openai.token`
- Custom roles: `~/.vim/vim-ai-roles.ini`
- Homebrew vim: `/opt/homebrew/bin/vim`

Always verify these paths exist before making changes.
