# git-auto-add

## Overview
Automatically stage modified files with git after editing

**Event Type:** `PostToolUse`
**Complexity:** beginner
**Language:** all

## How It Works
Triggers immediately after Write/Edit tools complete

1. Claude Code detects the configured event
2. Hook matcher checks if conditions are met
3. Hook command executes with safety wrappers
4. Result is processed (silent failure on errors)

## Use Cases
- Auto-stage all edited files
- Auto-stage specific file types
- Simplify git workflow

## Prerequisites
- Git

## Installation

### Manual Installation

1. Open your Claude Code settings file:
   - **Project-level:** `.claude/settings.json`
   - **User-level:** `~/.claude/settings.json`

2. Add this hook configuration to the `hooks` array:

```json
{
  "hooks": {
    "PostToolUse": [
      {
        "matcher": {
          "tool_names": ["Write", "Edit"]
        },
        "hooks": [
          {
            "type": "command",
            "command": "# Check if this is a git repository\nif ! git rev-parse --git-dir &> /dev/null; then\n    exit 0\nfi\n\n# Check if file path is available\nif [ -z \"$CLAUDE_TOOL_FILE_PATH\" ]; then\n    exit 0\nfi\n\n# Stage the file\ngit add \"$CLAUDE_TOOL_FILE_PATH\" 2>/dev/null || exit 0",
            "timeout": 60
          }
        ]
      }
    ]
  }
}
```

3. Save the file and restart Claude Code.

## Configuration

### Customize Behavior
You can modify the hook by editing `hook.json`:

**Available Customizations:**

**FILE_FILTER:** Optional filter for which files to auto-add
- Options: all, code_only, exclude_tests

## Safety Notes
Read git status before staging. Uses silent failure mode.

**Safety Features:**
- ✅ Tool detection prevents errors if dependencies missing
- ✅ Silent failure mode (`|| exit 0`) never interrupts workflow
- ✅ Appropriate timeout settings
- ✅ No destructive operations

## Troubleshooting

### Hook Not Triggering
1. Check that the event type matches your use case
2. Verify file patterns in matcher (if applicable)
3. Check Claude Code logs: `~/.claude/logs/`

### Command Errors
1. Verify required tools are installed
2. Test command manually in terminal
3. Check timeout settings

## Advanced

### Combining with Other Hooks
You can combine this hook with others by adding them to the same event type array.

### Custom Modifications
- Customize command parameters
- Add conditional logic
- Combine with other tools

---
**Generated by hook-factory** | 2025-10-30
**Template:** post_tool_use_git_add
**Version:** 1.0
