# Campaign Metrics Benchmarks

Industry benchmark reference for marketing campaign performance metrics. Use these benchmarks to contextualize your campaign results, identify underperformance, and set realistic targets.

---

## How to Use This Reference

1. Find your industry vertical and channel combination
2. Compare your actual metrics to the benchmark ranges
3. Use the assessment scale: Below Low = underperforming, Low-Target = below target, Target-High = good, Above High = excellent
4. Adjust targets based on your historical performance (your own data is always the best benchmark)

---

## Click-Through Rate (CTR) Benchmarks

CTR = (Clicks / Impressions) * 100

### By Channel (Cross-Industry Average)

| Channel | Low | Target | High | Notes |
|---------|-----|--------|------|-------|
| Email | 1.0% | 2.5% | 5.0% | Highly dependent on list quality and segmentation |
| Paid Search (Google) | 1.5% | 3.5% | 7.0% | Brand keywords typically 5-10%, generic 1-3% |
| Paid Social (Facebook) | 0.5% | 1.2% | 3.0% | Video ads trend higher, static lower |
| Paid Social (LinkedIn) | 0.3% | 0.8% | 2.0% | B2B focused, lower volume but higher intent |
| Display Ads | 0.05% | 0.10% | 0.50% | Retargeting typically 0.5-1.0% |
| Organic Search | 1.5% | 3.0% | 8.0% | Position 1 averages 28-31% CTR |
| Organic Social | 0.5% | 1.5% | 4.0% | Platform algorithm changes affect significantly |
| Referral | 1.0% | 3.0% | 6.0% | Quality of referring site matters greatly |
| Direct | 2.0% | 4.0% | 8.0% | Highest intent channel |

### By Industry (Paid Search)

| Industry | Average CTR | Low | High |
|----------|------------|-----|------|
| B2B | 2.4% | 1.5% | 4.0% |
| E-commerce | 2.7% | 1.8% | 5.0% |
| Education | 3.3% | 2.0% | 6.0% |
| Finance & Insurance | 2.9% | 1.5% | 5.5% |
| Healthcare | 3.3% | 2.0% | 5.0% |
| Legal | 2.9% | 1.5% | 5.0% |
| Real Estate | 3.7% | 2.5% | 6.0% |
| Retail | 2.5% | 1.5% | 5.0% |
| SaaS | 2.1% | 1.2% | 3.5% |
| Technology | 2.1% | 1.0% | 4.0% |
| Travel & Hospitality | 4.7% | 3.0% | 8.0% |

---

## Cost Per Click (CPC) Benchmarks

CPC = Spend / Clicks

### By Channel (USD)

| Channel | Low | Target | High | Notes |
|---------|-----|--------|------|-------|
| Google Search | $0.50 | $2.50 | $8.00 | Legal/finance can exceed $50 per click |
| Google Display | $0.10 | $0.50 | $2.00 | Programmatic can be lower |
| Facebook | $0.30 | $1.00 | $3.00 | B2C typically lower than B2B |
| LinkedIn | $2.00 | $5.50 | $12.00 | Highest CPC among social platforms |
| Instagram | $0.40 | $1.20 | $3.50 | Stories ads trending lower |
| Twitter/X | $0.20 | $0.80 | $2.50 | High variability by topic |
| TikTok | $0.10 | $0.50 | $2.00 | Rapidly evolving, currently lower |

### By Industry (Google Ads)

| Industry | Average CPC | Range |
|----------|------------|-------|
| Automotive | $2.46 | $1.00-$6.00 |
| B2B | $3.33 | $1.50-$8.00 |
| E-commerce | $1.16 | $0.50-$3.00 |
| Education | $2.40 | $1.00-$5.00 |
| Finance & Insurance | $3.44 | $1.00-$50.00 |
| Healthcare | $2.62 | $1.00-$6.00 |
| Legal | $6.75 | $2.00-$100.00 |
| Real Estate | $2.37 | $1.00-$5.00 |
| SaaS/Technology | $3.80 | $1.50-$10.00 |
| Travel | $1.53 | $0.50-$4.00 |

---

## Cost Per Mille / Thousand Impressions (CPM) Benchmarks

CPM = (Spend / Impressions) * 1000

### By Channel (USD)

| Channel | Low | Target | High | Notes |
|---------|-----|--------|------|-------|
| Facebook | $3.00 | $8.00 | $15.00 | Q4 holiday season can exceed $20 |
| Instagram | $4.00 | $10.00 | $18.00 | Reels ads trending lower |
| LinkedIn | $8.00 | $25.00 | $50.00 | Premium B2B audience |
| Google Display | $1.00 | $3.50 | $8.00 | Programmatic ranges widely |
| TikTok | $2.00 | $6.00 | $12.00 | Growing platform, rates increasing |
| YouTube | $4.00 | $10.00 | $20.00 | Pre-roll vs discovery ads vary |
| Programmatic Display | $0.50 | $2.00 | $6.00 | Dependent on targeting precision |

---

## Cost Per Acquisition (CPA) Benchmarks

CPA = Spend / Customers Acquired

### By Channel (USD)

| Channel | Low | Target | High | Notes |
|---------|-----|--------|------|-------|
| Email | $5 | $15 | $40 | Existing list; acquisition cost amortized |
| Paid Search | $20 | $50 | $150 | Highly dependent on industry and competition |
| Paid Social | $15 | $40 | $100 | Retargeting typically lower |
| Display | $30 | $75 | $200 | Awareness-focused; higher CPA expected |
| Organic Search | $5 | $20 | $60 | Excludes SEO investment costs |
| Organic Social | $10 | $30 | $80 | Content production costs excluded |
| Referral | $10 | $25 | $70 | Referral incentive costs included |

### By Industry (Across Channels)

| Industry | Average CPA | Acceptable Range |
|----------|------------|------------------|
| B2B SaaS | $150-$400 | $75-$700 |
| E-commerce | $25-$80 | $10-$150 |
| Education | $40-$120 | $20-$250 |
| Finance | $75-$200 | $30-$500 |
| Healthcare | $50-$150 | $25-$300 |
| Legal | $100-$300 | $50-$700 |
| Real Estate | $60-$180 | $30-$350 |
| Retail | $15-$50 | $8-$100 |
| Travel | $20-$70 | $10-$150 |

---

## Cost Per Lead (CPL) Benchmarks

CPL = Spend / Leads Generated

### By Channel (USD)

| Channel | Low | Target | High |
|---------|-----|--------|------|
| Email | $3 | $10 | $25 |
| Paid Search | $15 | $35 | $90 |
| Paid Social (Facebook) | $8 | $20 | $50 |
| Paid Social (LinkedIn) | $25 | $75 | $150 |
| Display | $20 | $50 | $120 |
| Content Marketing | $10 | $30 | $80 |
| Webinars | $30 | $70 | $150 |

### By Industry

| Industry | Average CPL | Range |
|----------|------------|-------|
| B2B SaaS | $50-$150 | $25-$300 |
| E-commerce | $10-$30 | $5-$60 |
| Education | $25-$70 | $15-$150 |
| Financial Services | $40-$120 | $20-$250 |
| Healthcare | $30-$90 | $15-$180 |
| Manufacturing | $50-$120 | $25-$200 |
| Technology | $40-$100 | $20-$200 |

---

## Return on Ad Spend (ROAS) Benchmarks

ROAS = Revenue / Ad Spend

### By Channel

| Channel | Low | Target | High | Notes |
|---------|-----|--------|------|-------|
| Email | 30x | 42x | 60x | Highest ROAS channel when list is healthy |
| Paid Search (Brand) | 8x | 15x | 30x | Brand terms have high ROAS |
| Paid Search (Generic) | 2x | 4x | 8x | Competitive; ROAS varies widely |
| Paid Social | 1.5x | 3x | 6x | Retargeting typically 4-10x |
| Display | 0.5x | 1.5x | 3x | Often used for awareness; lower direct ROAS |
| Organic Search | 5x | 10x | 20x | Excludes SEO investment amortization |
| Organic Social | 3x | 6x | 12x | Excludes content production costs |

### By Industry

| Industry | Minimum Viable ROAS | Target ROAS |
|----------|--------------------:|------------:|
| E-commerce (low margin) | 4x | 8x+ |
| E-commerce (high margin) | 2x | 4x+ |
| SaaS | 3x | 6x+ |
| B2B Services | 5x | 10x+ |
| Retail | 3x | 5x+ |
| DTC Brands | 2.5x | 5x+ |

### ROAS Calculation Notes

- **Breakeven ROAS** = 1 / Profit Margin (e.g., 25% margin = 4x breakeven)
- **Target ROAS** should be at least 2x the breakeven ROAS for sustainable growth
- Always include all costs (media, creative, tools, labor) for true ROAS

---

## Conversion Rate Benchmarks

### Landing Page Conversion Rate

| Industry | Low | Average | High |
|----------|-----|---------|------|
| B2B SaaS | 2.0% | 4.5% | 9.0% |
| E-commerce | 1.5% | 3.0% | 6.0% |
| Education | 2.5% | 5.5% | 10.0% |
| Finance | 2.0% | 5.0% | 11.0% |
| Healthcare | 2.0% | 4.0% | 8.0% |
| Legal | 3.0% | 7.0% | 13.0% |
| Real Estate | 2.0% | 4.5% | 8.0% |
| Travel | 2.0% | 4.0% | 9.0% |

### Email Conversion Rates

| Metric | Low | Average | High |
|--------|-----|---------|------|
| Open Rate | 15% | 22% | 35% |
| Click Rate | 1.0% | 2.5% | 5.0% |
| Click-to-Open Rate | 8% | 12% | 20% |
| Unsubscribe Rate | 0.1% | 0.2% | 0.5% |

---

## Seasonal Adjustments

Campaign benchmarks fluctuate by season. Apply these adjustment factors to normalize your comparisons:

| Quarter | CPC Adjustment | CPM Adjustment | CVR Adjustment |
|---------|---------------|----------------|----------------|
| Q1 (Jan-Mar) | -10% to -15% | -15% to -20% | Baseline |
| Q2 (Apr-Jun) | Baseline | Baseline | Baseline |
| Q3 (Jul-Sep) | +5% to +10% | +5% to +10% | -5% |
| Q4 (Oct-Dec) | +15% to +30% | +20% to +40% | +10% to +20% |

**Key seasonal events:**
- Black Friday/Cyber Monday: CPMs can increase 50-100%
- January: Lowest competition, good for testing
- Back-to-School (Aug-Sep): Education and retail spike
- Tax Season (Jan-Apr): Finance vertical spike

---

## Using Benchmarks Effectively

### Do

- Compare against your own historical data first, then industry benchmarks
- Account for seasonality when comparing time periods
- Consider your funnel position (awareness vs conversion campaigns have different benchmarks)
- Update benchmarks annually as industry norms shift

### Do Not

- Treat benchmarks as absolute targets (your business context matters more)
- Compare across industries without adjustment
- Ignore sample size (small campaigns have high variance)
- Use benchmarks to justify cutting channels without understanding their full-funnel role
