# Customer Success Playbooks

Comprehensive intervention, onboarding, renewal, expansion, and escalation playbooks for SaaS customer success management.

---

## Risk Tier Intervention Playbooks

### Critical Risk (Score 80-100)

**Situation:** Customer is at imminent risk of churn. Multiple severe warning signals detected. Requires immediate executive-level intervention.

**Timeline:** Act within 48 hours.

**Steps:**

1. **Executive Escalation (Day 0)**
   - Alert VP of Customer Success and account executive immediately
   - Brief internal leadership on situation, warning signals, and ARR at risk
   - Identify any pending support issues and fast-track resolution

2. **Customer Contact (Day 1-2)**
   - Schedule executive-to-executive call (VP CS to customer VP/C-level)
   - Frame the conversation around understanding their challenges, not defending your product
   - Listen more than talk -- capture the real objections

3. **Save Plan Creation (Day 2-3)**
   - Create a detailed save plan with specific value milestones tied to their business outcomes
   - Include timeline, owners, and measurable success criteria
   - Get internal alignment on any concessions (pricing, features, roadmap commitments)

4. **Rescue Team Assignment (Day 3-5)**
   - Assign a dedicated rescue team: CSM + Solutions Engineer + Support Lead
   - Daily internal stand-up (15 min max) on account status
   - Solutions Engineer to conduct technical health check

5. **Execution and Monitoring (Week 2-4)**
   - Execute save plan with weekly customer check-ins
   - Track progress against milestones
   - Prepare competitive displacement defence if competitor involvement detected

6. **Resolution Assessment (Week 4)**
   - Evaluate whether the situation is stabilising
   - If improving: transition to High-risk monitoring cadence
   - If not improving: escalate to CEO/GM for final intervention

**Success Criteria:** Risk score drops below 60 within 30 days. Customer confirms continued partnership intent.

---

### High Risk (Score 60-79)

**Situation:** Customer showing clear signs of dissatisfaction or disengagement. Still salvageable with focused CSM intervention.

**Timeline:** Act within 1 week.

**Steps:**

1. **Root Cause Analysis (Day 1-3)**
   - Review all health score dimensions to identify the primary drivers
   - Pull support ticket history for patterns
   - Check product usage trends for the past 90 days

2. **CSM Outreach (Day 3-5)**
   - Schedule a dedicated call with the customer (not a routine check-in)
   - Open with empathy: "I've noticed some changes and want to make sure we're supporting you properly"
   - Identify the top 3 customer concerns

3. **30-Day Recovery Plan (Day 5-7)**
   - Build a 30-day recovery plan with measurable checkpoints every week
   - Include specific actions for each concern identified
   - Share the plan with the customer for mutual commitment

4. **Re-Engage Executive Sponsor (Week 2)**
   - Request a meeting with the executive sponsor
   - Align on business outcomes and how your product supports them
   - Confirm continued sponsorship and address any political changes

5. **Support Fast-Track (Ongoing)**
   - Escalate any pending support tickets internally
   - Assign a support point of contact for this account
   - Provide weekly status updates on open issues

6. **Progress Review (Week 3-4)**
   - Review all metrics for improvement
   - Adjust plan if specific interventions are not working
   - If score drops to Critical: escalate to executive playbook

**Success Criteria:** Risk score drops below 40 within 30 days. No new warning signals emerge.

---

### Medium Risk (Score 40-59)

**Situation:** Early warning signs detected. Customer may not be aware of emerging issues. Proactive outreach prevents escalation.

**Timeline:** Act within 2 weeks.

**Steps:**

1. **Data Review (Day 1-5)**
   - Analyse which dimension(s) are pulling the score down
   - Review recent support interactions for sentiment clues
   - Check for any known product issues affecting this customer

2. **Proactive Check-In (Week 1-2)**
   - Schedule a "value check-in" call (position it as routine, not reactive)
   - Share relevant success stories from similar customers
   - Propose a training session or product walkthrough for underutilised features

3. **Value Reinforcement (Week 2-3)**
   - Send a customised ROI summary showing value delivered
   - Highlight feature releases relevant to their use case
   - Connect them with your customer community or user group

4. **Monitoring (Week 3-4)**
   - Increase monitoring frequency to bi-weekly
   - Watch for improvement or continued decline
   - If declining: move to High-risk playbook

**Success Criteria:** Score stabilises above 50 or improves. No escalation to High risk.

---

### Low Risk (Score 0-39)

**Situation:** Customer is healthy. Standard success cadence applies. Focus on value reinforcement and expansion readiness.

**Timeline:** Standard touch cadence.

**Steps:**

1. **Maintain Cadence**
   - Enterprise: Monthly strategic reviews, quarterly QBRs
   - Mid-Market: Bi-monthly check-ins, semi-annual reviews
   - SMB: Quarterly automated health updates, annual review

2. **Proactive Communication**
   - Share product updates and release notes
   - Invite to webinars, conferences, and community events
   - Share relevant industry insights and benchmarks

3. **Expansion Readiness**
   - Monitor for expansion signals (usage approaching limits, new use cases)
   - Prepare expansion proposals when timing is right
   - Position premium features and modules relevant to their needs

4. **Renewal Preparation**
   - Begin renewal preparation 90 days before contract end
   - Build renewal proposal with value delivered summary
   - Identify any terms or pricing adjustments needed

**Success Criteria:** Customer remains in Green classification. Expansion conversations initiated when appropriate.

---

## Onboarding Playbook

### Phase 1: Welcome and Setup (Day 1-14)

| Day | Activity | Owner | Deliverable |
|-----|----------|-------|-------------|
| 1 | Welcome email and introduction | CSM | Welcome package sent |
| 1-2 | Kickoff call | CSM + SE | Success plan drafted |
| 3-5 | Technical setup and configuration | SE | Environment configured |
| 5-7 | Admin training session | CSM | Admins trained |
| 7-10 | Data migration (if applicable) | SE | Data validated |
| 10-14 | Initial user training | CSM | Core team trained |

### Phase 2: Activation (Day 15-30)

| Day | Activity | Owner | Deliverable |
|-----|----------|-------|-------------|
| 15 | Activation check -- are users logging in? | CSM | Usage report |
| 15-20 | Follow-up training for laggards | CSM | All users active |
| 20-25 | First business outcome milestone | CSM | Milestone achieved |
| 25-30 | 30-day review call | CSM | Review documented |

**Critical Milestone:** Time to First Value must be under 30 days.

### Phase 3: Adoption (Day 31-60)

| Day | Activity | Owner | Deliverable |
|-----|----------|-------|-------------|
| 30-40 | Feature adoption expansion | CSM | New features in use |
| 40-50 | Integration setup (if applicable) | SE | Integrations live |
| 50-60 | Usage benchmarking vs. peers | CSM | Benchmark report |

### Phase 4: Optimisation (Day 61-90)

| Day | Activity | Owner | Deliverable |
|-----|----------|-------|-------------|
| 60-70 | Advanced use case workshop | CSM + SE | New use cases identified |
| 70-80 | ROI measurement | CSM | ROI documented |
| 80-90 | 90-day executive review | CSM | Transition to steady-state |

**Gate:** Handoff from onboarding to ongoing CSM management. Health score must be Yellow or better.

---

## Renewal Playbook

### 120 Days Before Renewal

- Review contract terms and pricing
- Assess current health score and trajectory
- Identify any outstanding issues or concerns
- Begin internal alignment on renewal strategy

### 90 Days Before Renewal

- Schedule renewal conversation with customer
- Prepare value delivered summary (ROI, usage stats, milestones achieved)
- Draft renewal proposal with recommended terms
- If at-risk: escalate and begin risk mitigation

### 60 Days Before Renewal

- Present renewal proposal to customer
- Negotiate terms if needed
- Address any concerns raised during the process
- Escalate blockers to leadership

### 30 Days Before Renewal

- Finalise contract terms
- Obtain signatures
- Plan for any post-renewal actions (expansion, migration)
- Update CRM with renewal details

### Post-Renewal

- Confirm renewed contract in systems
- Send thank-you and updated success plan
- Schedule next QBR
- Identify expansion opportunities

---

## Expansion Playbook

### Identifying Expansion Signals

| Signal | Expansion Type | Priority |
|--------|---------------|----------|
| Seat utilisation > 90% | Seat expansion | High |
| Requests for features in higher tier | Tier upsell | High |
| New department inquiries | Department expansion | Medium |
| High adoption of existing modules | Module cross-sell | Medium |
| Customer referencing competitors for missing features | Cross-sell | High |

### Expansion Conversation Framework

1. **Discovery:** "I noticed your team has been getting great value from [feature]. Have you considered how [new module] could help with [related business outcome]?"
2. **Value Framing:** "Companies similar to yours who adopted [module] saw [specific metric improvement]."
3. **Proposal:** "Based on your current usage, here's what the expansion would look like..."
4. **Stakeholder Alignment:** Involve the economic buyer early. The champion can advocate, but the budget holder decides.
5. **Close:** Coordinate with sales/account executive for commercial negotiation.

---

## Escalation Procedures

### Internal Escalation Matrix

| Trigger | Escalation Level | Response Time |
|---------|-----------------|---------------|
| Health score drops to Red | VP Customer Success | 24 hours |
| Executive sponsor leaves | Director CS + AE | 48 hours |
| Critical bug affecting customer | VP Engineering + VP CS | 4 hours |
| Customer mentions competitor evaluation | VP CS + VP Sales | 24 hours |
| Renewal at risk (60 days or less) | CRO/VP Sales | 24 hours |
| Customer threatens legal action | Legal + VP CS | Immediate |

### Escalation Communication Template

**Subject:** [ESCALATION] {Customer Name} -- {Brief Description}

**Body:**
- Customer: {name}, {segment}, ${ARR}
- Health Score: {score} ({classification})
- Renewal Date: {date}
- Issue Summary: {2-3 sentences}
- Warning Signals: {list}
- Recommended Action: {specific next step}
- Urgency: {critical/high/medium}

---

**Last Updated:** February 2026
