# DCF Valuation Analysis

## Report Header

| Field | Value |
|-------|-------|
| **Company** | [Company Name] |
| **Ticker** | [Ticker Symbol] |
| **Analysis Date** | [Date] |
| **Prepared By** | [Analyst Name] |
| **Current Share Price** | $[X] |
| **Shares Outstanding** | [X]M |

## Executive Summary

[2-3 sentence overview of the valuation conclusion, including the implied value range per share compared to the current market price, and whether the stock appears undervalued, fairly valued, or overvalued.]

### Valuation Summary

| Method | Enterprise Value | Equity Value | Value Per Share | vs Current Price |
|--------|-----------------|-------------|----------------|-----------------|
| DCF (Perpetuity Growth) | $[X]M | $[X]M | $[X] | [X]% |
| DCF (Exit Multiple) | $[X]M | $[X]M | $[X] | [X]% |
| Comparable Companies | $[X]M | $[X]M | $[X] | [X]% |
| **Blended Estimate** | **$[X]M** | **$[X]M** | **$[X]** | **[X]%** |

## Investment Thesis

[Summary of the investment case, including key strengths, risks, and catalysts.]

## Historical Financial Summary

| ($M) | FY-4 | FY-3 | FY-2 | FY-1 | LTM |
|------|------|------|------|------|-----|
| Revenue | [X] | [X] | [X] | [X] | [X] |
| Revenue Growth | [X]% | [X]% | [X]% | [X]% | [X]% |
| Gross Profit | [X] | [X] | [X] | [X] | [X] |
| Gross Margin | [X]% | [X]% | [X]% | [X]% | [X]% |
| EBITDA | [X] | [X] | [X] | [X] | [X] |
| EBITDA Margin | [X]% | [X]% | [X]% | [X]% | [X]% |
| Net Income | [X] | [X] | [X] | [X] | [X] |
| Free Cash Flow | [X] | [X] | [X] | [X] | [X] |

## WACC Calculation

### Cost of Equity (CAPM)

| Component | Value | Source |
|-----------|-------|--------|
| Risk-Free Rate | [X]% | [10-Year Treasury] |
| Equity Risk Premium | [X]% | [Damodaran / internal] |
| Beta (Levered) | [X] | [Bloomberg / regression] |
| Size Premium | [X]% | [Duff & Phelps] |
| Company-Specific Risk | [X]% | [Analyst judgment] |
| **Cost of Equity** | **[X]%** | |

### Cost of Debt

| Component | Value |
|-----------|-------|
| Pre-Tax Cost of Debt | [X]% |
| Tax Rate | [X]% |
| After-Tax Cost of Debt | [X]% |

### Capital Structure

| Component | Market Value ($M) | Weight |
|-----------|------------------|--------|
| Equity | [X] | [X]% |
| Debt | [X] | [X]% |
| **Total Capital** | **[X]** | **100%** |

### WACC Result: [X]%

## Revenue Projections

| ($M) | Year 1 | Year 2 | Year 3 | Year 4 | Year 5 |
|------|--------|--------|--------|--------|--------|
| Revenue | [X] | [X] | [X] | [X] | [X] |
| Growth Rate | [X]% | [X]% | [X]% | [X]% | [X]% |

**Key Revenue Assumptions:**
- [Assumption 1 with supporting rationale]
- [Assumption 2 with supporting rationale]
- [Assumption 3 with supporting rationale]

## Free Cash Flow Projections

| ($M) | Year 1 | Year 2 | Year 3 | Year 4 | Year 5 |
|------|--------|--------|--------|--------|--------|
| Revenue | [X] | [X] | [X] | [X] | [X] |
| EBIT | [X] | [X] | [X] | [X] | [X] |
| Taxes on EBIT | ([X]) | ([X]) | ([X]) | ([X]) | ([X]) |
| NOPAT | [X] | [X] | [X] | [X] | [X] |
| D&A | [X] | [X] | [X] | [X] | [X] |
| CapEx | ([X]) | ([X]) | ([X]) | ([X]) | ([X]) |
| Change in NWC | ([X]) | ([X]) | ([X]) | ([X]) | ([X]) |
| **Unlevered FCF** | **[X]** | **[X]** | **[X]** | **[X]** | **[X]** |
| FCF Margin | [X]% | [X]% | [X]% | [X]% | [X]% |

## Terminal Value

### Perpetuity Growth Method

| Component | Value |
|-----------|-------|
| Terminal FCF | $[X]M |
| Terminal Growth Rate | [X]% |
| WACC | [X]% |
| **Terminal Value** | **$[X]M** |
| TV as % of EV | [X]% |

### Exit Multiple Method

| Component | Value |
|-----------|-------|
| Terminal EBITDA | $[X]M |
| Exit EV/EBITDA Multiple | [X]x |
| **Terminal Value** | **$[X]M** |
| TV as % of EV | [X]% |

## Enterprise Value Bridge

| Component | Perpetuity Growth | Exit Multiple |
|-----------|------------------|---------------|
| PV of Projected FCFs | $[X]M | $[X]M |
| PV of Terminal Value | $[X]M | $[X]M |
| **Enterprise Value** | **$[X]M** | **$[X]M** |
| Less: Net Debt | ($[X]M) | ($[X]M) |
| Less: Minority Interest | ($[X]M) | ($[X]M) |
| **Equity Value** | **$[X]M** | **$[X]M** |
| Diluted Shares (M) | [X] | [X] |
| **Value Per Share** | **$[X]** | **$[X]** |

## Sensitivity Analysis

### WACC vs Terminal Growth Rate (Enterprise Value, $M)

| WACC \ Growth | [g-2]% | [g-1]% | [g]% | [g+1]% | [g+2]% |
|--------------|--------|--------|------|--------|--------|
| [WACC-2]% | [X] | [X] | [X] | [X] | [X] |
| [WACC-1]% | [X] | [X] | [X] | [X] | [X] |
| **[WACC]%** | [X] | [X] | **[X]** | [X] | [X] |
| [WACC+1]% | [X] | [X] | [X] | [X] | [X] |
| [WACC+2]% | [X] | [X] | [X] | [X] | [X] |

### Implied Share Price Range

| Scenario | Share Price | vs Current | Upside/Downside |
|----------|-----------|------------|----------------|
| Bear Case (WACC+2%, g-2%) | $[X] | [X]% | [X]% |
| Base Case | $[X] | [X]% | [X]% |
| Bull Case (WACC-2%, g+2%) | $[X] | [X]% | [X]% |

## Key Risks to Valuation

1. **[Risk 1]** - [Description and potential impact on value]
2. **[Risk 2]** - [Description and potential impact on value]
3. **[Risk 3]** - [Description and potential impact on value]

## Comparable Company Analysis

| Company | EV/Revenue | EV/EBITDA | P/E | Growth | Margin |
|---------|-----------|----------|-----|--------|--------|
| [Comp 1] | [X]x | [X]x | [X]x | [X]% | [X]% |
| [Comp 2] | [X]x | [X]x | [X]x | [X]% | [X]% |
| [Comp 3] | [X]x | [X]x | [X]x | [X]% | [X]% |
| [Comp 4] | [X]x | [X]x | [X]x | [X]% | [X]% |
| **Median** | **[X]x** | **[X]x** | **[X]x** | **[X]%** | **[X]%** |
| **[Target]** | **[X]x** | **[X]x** | **[X]x** | **[X]%** | **[X]%** |

## Conclusion and Recommendation

**Valuation Range:** $[Low] - $[High] per share

**Current Price:** $[X]

**Recommendation:** [Buy / Hold / Sell]

[Final paragraph with investment recommendation rationale, key upside catalysts, and primary risks to monitor.]

---

*Analysis generated using Financial Analyst Skill - DCF Valuation Model*
