# Financial Ratios Guide

Comprehensive reference for financial ratio analysis covering formulas, interpretation, and industry benchmarks across five categories.

## 1. Profitability Ratios

Measure a company's ability to generate earnings relative to revenue, assets, or equity.

### Return on Equity (ROE)

**Formula:** Net Income / Total Shareholders' Equity

**Interpretation:**
- Measures how effectively management uses equity to generate profits
- Higher ROE indicates more efficient use of equity capital
- Compare against cost of equity - ROE should exceed it

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Below Average | < 8% |
| Acceptable | 8% - 15% |
| Good | 15% - 25% |
| Excellent | > 25% |

**Caveats:** High leverage can inflate ROE. Use DuPont decomposition (ROE = Margin x Turnover x Leverage) for deeper analysis.

### Return on Assets (ROA)

**Formula:** Net Income / Total Assets

**Interpretation:**
- Measures how efficiently assets generate profit
- Asset-light businesses naturally have higher ROA
- Compare within industry only

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Below Average | < 3% |
| Acceptable | 3% - 6% |
| Good | 6% - 12% |
| Excellent | > 12% |

### Gross Margin

**Formula:** (Revenue - COGS) / Revenue

**Interpretation:**
- Measures production efficiency and pricing power
- Declining gross margin may signal competitive pressure or cost inflation
- Critical for evaluating business model sustainability

**Benchmarks by Industry:**
| Industry | Typical Range |
|----------|--------------|
| Software/SaaS | 70% - 85% |
| Financial Services | 50% - 70% |
| Retail | 25% - 45% |
| Manufacturing | 20% - 40% |
| Grocery | 25% - 30% |

### Operating Margin

**Formula:** Operating Income / Revenue

**Interpretation:**
- Measures operational efficiency after all operating expenses
- Excludes interest and taxes for better operational comparison
- Indicates management effectiveness in controlling costs

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Below Average | < 5% |
| Acceptable | 5% - 15% |
| Good | 15% - 25% |
| Excellent | > 25% |

### Net Margin

**Formula:** Net Income / Revenue

**Interpretation:**
- Bottom-line profitability after all expenses
- Affected by tax strategy, capital structure, and one-time items
- Most comprehensive profitability measure

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Below Average | < 3% |
| Acceptable | 3% - 10% |
| Good | 10% - 20% |
| Excellent | > 20% |

## 2. Liquidity Ratios

Measure a company's ability to meet short-term obligations.

### Current Ratio

**Formula:** Current Assets / Current Liabilities

**Interpretation:**
- Measures short-term solvency
- Too high may indicate inefficient asset use
- Too low signals potential liquidity risk

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Concern | < 1.0 |
| Acceptable | 1.0 - 1.5 |
| Healthy | 1.5 - 3.0 |
| Excessive | > 3.0 |

### Quick Ratio (Acid Test)

**Formula:** (Current Assets - Inventory) / Current Liabilities

**Interpretation:**
- More conservative than current ratio
- Excludes inventory (least liquid current asset)
- Critical for businesses with slow-moving inventory

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Concern | < 0.8 |
| Acceptable | 0.8 - 1.0 |
| Healthy | 1.0 - 2.0 |
| Excessive | > 2.0 |

### Cash Ratio

**Formula:** Cash & Equivalents / Current Liabilities

**Interpretation:**
- Most conservative liquidity measure
- Indicates ability to pay obligations with cash on hand
- Particularly important during credit crunches

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Low | < 0.2 |
| Adequate | 0.2 - 0.5 |
| Strong | 0.5 - 1.0 |
| Excessive | > 1.0 |

## 3. Leverage Ratios

Measure the extent to which a company uses debt financing.

### Debt-to-Equity Ratio

**Formula:** Total Debt / Total Shareholders' Equity

**Interpretation:**
- Measures financial leverage and risk
- Higher ratio = more reliance on debt financing
- Industry norms vary significantly (utilities vs tech)

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Conservative | < 0.3 |
| Moderate | 0.3 - 0.8 |
| Elevated | 0.8 - 2.0 |
| High Risk | > 2.0 |

### Interest Coverage Ratio

**Formula:** Operating Income (EBIT) / Interest Expense

**Interpretation:**
- Measures ability to service debt from operating earnings
- Below 1.5x is a red flag for lenders
- Critical for credit analysis

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Distressed | < 2.0 |
| Adequate | 2.0 - 5.0 |
| Strong | 5.0 - 10.0 |
| Very Strong | > 10.0 |

### Debt Service Coverage Ratio (DSCR)

**Formula:** Operating Cash Flow / Total Debt Service

**Interpretation:**
- Cash-based measure of debt servicing capacity
- Includes principal repayments (unlike interest coverage)
- Required by many loan covenants

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Default Risk | < 1.0 |
| Minimum | 1.0 - 1.5 |
| Comfortable | 1.5 - 2.5 |
| Strong | > 2.5 |

## 4. Efficiency Ratios

Measure how effectively a company uses its assets and manages operations.

### Asset Turnover

**Formula:** Revenue / Total Assets

**Interpretation:**
- Measures revenue generated per dollar of assets
- Higher indicates more efficient asset utilization
- Inversely related to profit margins (DuPont)

**Benchmarks:**
| Industry | Typical Range |
|----------|--------------|
| Retail | 2.0 - 3.0 |
| Manufacturing | 0.8 - 1.5 |
| Utilities | 0.3 - 0.5 |
| Technology | 0.5 - 1.0 |

### Inventory Turnover

**Formula:** COGS / Average Inventory

**Interpretation:**
- Measures how quickly inventory is sold
- Low turnover suggests overstock or obsolescence risk
- High turnover may indicate strong sales or thin inventory

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Slow | < 4x |
| Average | 4x - 8x |
| Efficient | 8x - 12x |
| Very Efficient | > 12x |

### Receivables Turnover

**Formula:** Revenue / Accounts Receivable

**Interpretation:**
- Measures efficiency of credit and collections
- Higher turnover means faster collections
- Monitor trends for credit policy changes

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Slow | < 6x |
| Average | 6x - 10x |
| Efficient | 10x - 15x |
| Very Efficient | > 15x |

### Days Sales Outstanding (DSO)

**Formula:** 365 / Receivables Turnover

**Interpretation:**
- Average days to collect payment after a sale
- Lower DSO = faster cash conversion
- Compare against payment terms

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Excellent | < 30 days |
| Good | 30 - 45 days |
| Acceptable | 45 - 60 days |
| Concern | > 60 days |

## 5. Valuation Ratios

Measure a company's market value relative to financial metrics.

### Price-to-Earnings (P/E) Ratio

**Formula:** Share Price / Earnings Per Share

**Interpretation:**
- Most widely used valuation metric
- High P/E suggests growth expectations or overvaluation
- Use trailing (TTM) and forward P/E for comparison

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Value | < 10x |
| Fair | 10x - 20x |
| Growth | 20x - 35x |
| Premium | > 35x |

### Price-to-Book (P/B) Ratio

**Formula:** Share Price / Book Value Per Share

**Interpretation:**
- Compares market value to accounting value
- Below 1.0 may indicate undervaluation or distress
- Most useful for asset-heavy industries

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Undervalued | < 1.0 |
| Fair | 1.0 - 2.5 |
| Premium | 2.5 - 5.0 |
| Rich | > 5.0 |

### Price-to-Sales (P/S) Ratio

**Formula:** Market Cap / Revenue

**Interpretation:**
- Useful for companies without positive earnings
- Compare within industry only
- Lower = potentially better value

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Value | < 1.0 |
| Fair | 1.0 - 3.0 |
| Growth | 3.0 - 8.0 |
| Premium | > 8.0 |

### EV/EBITDA

**Formula:** Enterprise Value / EBITDA

**Interpretation:**
- Capital-structure-neutral valuation metric
- Preferred for M&A analysis and leveraged buyouts
- More comparable across capital structures than P/E

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Value | < 6x |
| Fair | 6x - 12x |
| Growth | 12x - 20x |
| Premium | > 20x |

### PEG Ratio

**Formula:** P/E Ratio / Earnings Growth Rate (%)

**Interpretation:**
- Growth-adjusted P/E ratio
- PEG of 1.0 suggests fair valuation relative to growth
- Below 1.0 may indicate undervaluation

**Benchmarks:**
| Rating | Range |
|--------|-------|
| Undervalued | < 0.5 |
| Fair | 0.5 - 1.0 |
| Fully Valued | 1.0 - 2.0 |
| Overvalued | > 2.0 |

## Ratio Analysis Best Practices

1. **Compare within industry** - Ratios vary significantly across sectors
2. **Analyze trends** - A single period snapshot is insufficient; look at 3-5 year trends
3. **Use multiple ratios** - No single ratio tells the complete story
4. **Consider context** - Accounting policies, business cycle, and company stage matter
5. **DuPont decomposition** - Break ROE into margin, turnover, and leverage components
6. **Peer comparison** - Compare against direct competitors, not just broad benchmarks
7. **Watch for manipulation** - Revenue recognition changes, off-balance-sheet items, and one-time adjustments can distort ratios
