# International GTM Playbooks

Market-by-market expansion guides for US, UK, DACH, France, and Canada.

---

## Table of Contents

- [Market Prioritization](#market-prioritization)
- [US Market Entry](#us-market-entry)
- [UK Market Entry](#uk-market-entry)
- [DACH Market Entry](#dach-market-entry)
- [France Market Entry](#france-market-entry)
- [Canada Market Entry](#canada-market-entry)
- [Localization Checklist](#localization-checklist)

---

## Market Prioritization

### Expansion Sequence (Series A)

| Phase | Market | Timeline | Budget % | Target ARR |
|-------|--------|----------|----------|------------|
| 1 | US | Months 1-6 | 50% | $1M |
| 2 | UK | Months 4-9 | 20% | $500k |
| 3 | DACH | Months 7-12 | 15% | $300k |
| 4 | France | Months 10-15 | 10% | $200k |
| 5 | Canada | Months 7-12 | 5% | $100k |

### Market Readiness Checklist

Enter market when ALL true:

- [ ] Product ready for market (localization if needed)
- [ ] Legal/compliance requirements met
- [ ] Pricing localized (currency, taxes)
- [ ] Sales capacity available (hire or agency)
- [ ] Marketing budget allocated
- [ ] Support coverage during local hours
- [ ] **Validation:** 3+ inbound leads from market in last 90 days

---

## US Market Entry

### Market Characteristics

| Factor | US Approach |
|--------|-------------|
| Buying cycle | Fast (30-60 days average) |
| Decision process | Individual empowerment, less consensus |
| Pricing sensitivity | Value-focused, willing to pay premium |
| Communication | Direct, results-oriented |
| Relationship | Transaction > relationship (initially) |

### Entry Strategy

**Months 1-2: Foundation**

1. Establish US presence:
   - US phone number (toll-free)
   - US address (virtual office acceptable)
   - USD pricing on website
   - US case studies (even if from beta users)

2. Hire US sales:
   - Option A: US-based SDR/AE (expensive but effective)
   - Option B: US sales agency (lower risk, shared commission)
   - Option C: Remote sales trained on US hours

3. Launch paid campaigns:
   - Google Ads (high-intent keywords)
   - LinkedIn (B2B targeting)
   - Budget: 50% of marketing spend

**Months 3-6: Scale**

1. Optimize channels based on CAC data
2. Build US partner ecosystem:
   - Integration partners (Salesforce, HubSpot)
   - Resellers/VARs (for Enterprise)
   - Industry associations
3. Attend US conferences (SaaStr, industry events)
4. **Validation:** $1M pipeline from US sources

### US Channel Mix

| Channel | Budget % | Expected CPL | Notes |
|---------|----------|--------------|-------|
| Google Ads | 35% | $100-200 | High intent, competitive |
| LinkedIn | 30% | $150-250 | B2B targeting |
| SEO/Content | 20% | $50 (long-term) | Invest early |
| Partnerships | 15% | Variable | Co-marketing |

### US Messaging

- Lead with ROI and business outcomes
- Use $ impact metrics prominently
- Reference US customers (logos matter)
- Emphasize speed and efficiency
- Include G2/Capterra ratings

---

## UK Market Entry

### Market Characteristics

| Factor | UK Approach |
|--------|-------------|
| Buying cycle | Medium (45-90 days) |
| Decision process | Committee involvement |
| Pricing sensitivity | Value-conscious, compare options |
| Communication | Professional, less aggressive than US |
| Relationship | Balance transaction and relationship |

### Entry Strategy

**Months 4-6: Setup**

1. Localization:
   - GBP pricing
   - UK spellings (colour, organisation)
   - UK phone number
   - GDPR compliance (essential)

2. Sales coverage:
   - Hire UK-based rep OR
   - Partner with UK sales agency
   - Ensure coverage during GMT hours

3. Content localization:
   - UK case studies
   - UK-relevant industry references
   - Local competitor positioning

**Months 7-9: Growth**

1. Build UK partnerships:
   - UK tech community (TechNation, etc.)
   - London-based VCs and accelerators
   - UK industry associations

2. Attend UK events:
   - London Tech Week
   - Industry-specific conferences

3. **Validation:** $500k pipeline from UK sources

### UK Channel Mix

| Channel | Budget % | Expected CPL | Notes |
|---------|----------|--------------|-------|
| LinkedIn | 35% | $120-200 | Strong B2B presence |
| Google UK | 30% | $80-150 | Less competitive than US |
| SEO/Content | 20% | $40 | UK-targeted keywords |
| Partnerships | 15% | Variable | Local credibility |

### UK Messaging

- More formal than US (avoid hyperbole)
- Emphasize data security and GDPR
- Reference UK/EU customers
- Understated claims (prove with data)
- Acknowledge local presence/support

---

## DACH Market Entry

### Market Characteristics

| Factor | DACH Approach |
|--------|---------------|
| Buying cycle | Long (90-180 days) |
| Decision process | Consensus-driven, thorough evaluation |
| Pricing sensitivity | Quality over price, long-term view |
| Communication | Formal, detailed, precise |
| Relationship | Trust built over time, essential |

### Entry Strategy

**Months 7-9: Foundation**

1. Full localization:
   - German translation (website, product UI)
   - EUR pricing with German VAT handling
   - German phone number and address
   - GDPR compliance (strict enforcement)
   - Data residency option (EU data centers)

2. German-speaking sales:
   - Hire German-speaking sales rep
   - Native speaker critical (not just fluent)
   - Based in Germany preferred

3. Content in German:
   - Translate key pages and materials
   - Create German case studies
   - German blog content

**Months 10-12: Growth**

1. Build local credibility:
   - German customer testimonials
   - German partner ecosystem
   - Industry certifications (ISO, etc.)

2. Attend German events:
   - CeBIT/Hannover Messe
   - Industry conferences

3. **Validation:** $300k pipeline from DACH sources

### DACH Channel Mix

| Channel | Budget % | Expected CPL | Notes |
|---------|----------|--------------|-------|
| LinkedIn | 40% | $150-250 | Strong professional network |
| Google DE | 25% | $100-180 | German keywords |
| SEO (German) | 20% | $60 | Long-term investment |
| Partnerships | 15% | Variable | Critical for trust |

### DACH Messaging

- Formal tone (Sie, not du)
- Emphasize security, compliance, privacy
- Detailed specifications and documentation
- Reference German/EU customers
- Include certifications (ISO, SOC 2)
- Show long-term commitment to market

---

## France Market Entry

### Market Characteristics

| Factor | France Approach |
|--------|-----------------|
| Buying cycle | Long (90-180 days) |
| Decision process | Hierarchical, formal process |
| Pricing sensitivity | Value-focused, negotiation expected |
| Communication | Formal, relationship-focused |
| Relationship | Critical, business built on trust |

### Entry Strategy

**Months 10-12: Foundation**

1. Full French localization:
   - French translation (professional, not machine)
   - EUR pricing with French VAT
   - French phone number
   - GDPR + French regulations

2. French-speaking team:
   - Native French speaker for sales
   - French support coverage
   - Paris presence (even virtual)

**Months 13-15: Growth**

1. Build local ecosystem:
   - French tech community (La French Tech)
   - French partners and integrators
   - Industry associations

2. Attend French events:
   - VivaTech (Paris)
   - Industry conferences

3. **Validation:** $200k pipeline from France

### France Channel Mix

| Channel | Budget % | Expected CPL | Notes |
|---------|----------|--------------|-------|
| LinkedIn | 35% | $130-220 | Professional network |
| Google FR | 30% | $90-160 | French keywords |
| SEO (French) | 20% | $50 | French content strategy |
| Partnerships | 15% | Variable | Local partners essential |

### France Messaging

- Formal and professional
- French language throughout (no English fallback)
- Reference French/EU customers
- Emphasize local support and presence
- Highlight innovation and modernity
- Respect cultural nuances

---

## Canada Market Entry

### Market Characteristics

| Factor | Canada Approach |
|--------|-----------------|
| Buying cycle | Medium (45-75 days) |
| Decision process | Similar to US, slightly more conservative |
| Pricing sensitivity | Value-conscious, compare to US prices |
| Communication | Professional, friendly, less aggressive |
| Language | English (except Quebec - French required) |

### Entry Strategy

**Months 7-9: Foundation**

1. Minimal localization:
   - CAD pricing
   - Canadian phone number (optional)
   - PIPEDA compliance

2. Sales coverage:
   - Leverage US sales team (similar hours)
   - Consider Toronto-based rep for growth

3. Quebec consideration:
   - French required for Quebec market
   - Can delay or skip initially

**Months 10-12: Growth**

1. Canadian partnerships:
   - Canadian tech community
   - Toronto/Vancouver startup ecosystem
   - Industry associations

2. **Validation:** $100k pipeline from Canada

### Canada Channel Mix

| Channel | Budget % | Expected CPL | Notes |
|---------|----------|--------------|-------|
| Google CA | 35% | $80-150 | Canadian targeting |
| LinkedIn | 30% | $100-180 | B2B focus |
| SEO | 20% | $40 | Canadian content |
| Partnerships | 15% | Variable | Local credibility |

---

## Localization Checklist

### Per-Market Checklist

**Website**

- [ ] Language translation (professional, not machine)
- [ ] Currency localization (display + checkout)
- [ ] Phone number (local format)
- [ ] Address (local presence)
- [ ] Legal pages (privacy, terms in local language)
- [ ] hreflang tags configured correctly

**Product**

- [ ] UI translation (if required for market)
- [ ] Date/time format (DD/MM/YYYY vs MM/DD/YYYY)
- [ ] Number format (1,000 vs 1.000)
- [ ] Currency in product

**Payment**

- [ ] Local currency accepted
- [ ] VAT/tax handling
- [ ] Local payment methods (SEPA, iDEAL, etc.)
- [ ] Invoicing in local format

**Legal**

- [ ] GDPR compliance (EU markets)
- [ ] PIPEDA compliance (Canada)
- [ ] Local data protection laws
- [ ] Terms of service localized
- [ ] Privacy policy localized

**Sales**

- [ ] Local sales coverage (rep or agency)
- [ ] Localized sales materials
- [ ] Local pricing and quoting
- [ ] Local references and case studies

**Support**

- [ ] Coverage during local business hours
- [ ] Language support (phone, chat, email)
- [ ] Localized documentation
- [ ] Local SLA commitments

**Marketing**

- [ ] Localized campaigns
- [ ] Local content (blog, guides)
- [ ] Local social media presence
- [ ] Local event participation

**Validation:** Native speaker review of ALL localized content before launch
