# Messaging Templates

Ready-to-use messaging frameworks for different personas and contexts.

---

## Table of Contents

- [Value Proposition Templates](#value-proposition-templates)
- [Persona-Specific Messaging](#persona-specific-messaging)
- [Competitive Messaging](#competitive-messaging)
- [Channel-Specific Copy](#channel-specific-copy)
- [Objection Handling Scripts](#objection-handling-scripts)

---

## Value Proposition Templates

### One-Liner Formula

Template: `[Product] helps [Target Customer] [Achieve Goal] by [Unique Approach]`

**Examples:**

```
B2B SaaS:
"Acme helps mid-market SaaS teams ship 2x faster by automating
project workflows with AI."

Enterprise:
"Acme helps Fortune 500 companies reduce operational costs by 40%
through intelligent process automation."

SMB:
"Acme helps small businesses save 10 hours per week by automating
their daily tasks."
```

### Elevator Pitch (30 Seconds)

Template:
```
You know how [target customer] struggles with [pain point]?

[Product] is a [category] that [key differentiator].

Unlike [alternatives], we [unique value].

Our customers see [specific outcome] within [timeframe].
```

**Example:**

```
You know how engineering teams struggle with slow code reviews
that delay releases?

Acme is an AI code review platform that catches bugs before
they reach production.

Unlike manual reviews, we analyze every PR in under 2 minutes
with 95% accuracy.

Our customers ship 40% faster within their first month.
```

### Messaging Hierarchy

```
LEVEL 1: HEADLINE (5-7 words)
"Ship faster with AI-powered automation"

LEVEL 2: SUBHEAD (1 sentence)
"Acme automates your workflows so your team can focus on what matters."

LEVEL 3: KEY BENEFITS (3-4 bullets)
• Save 10+ hours per week on manual tasks
• Reduce errors by 80% with AI validation
• Deploy changes 3x faster with automated testing
• Scale operations without adding headcount

LEVEL 4: FEATURES → VALUE
• AI Automation → Eliminates repetitive work → Save $50k/year
• Real-time Sync → No version conflicts → 50% fewer errors
• Integrations → Connect existing tools → 2-hour setup
```

---

## Persona-Specific Messaging

### Economic Buyer (VP/Director/C-Level)

**Primary concerns:** ROI, business outcomes, risk mitigation

**Messaging principles:**
- Lead with business impact ($, %, time)
- Show ROI within 6-12 months
- Reference similar companies
- Address risk (security, implementation)

**Template:**

```
HEADLINE: [Business outcome] in [timeframe]

OPENING:
"[Role at similar company] was spending [hours/dollars] on [problem].
After implementing [Product], they achieved [specific result]."

KEY POINTS:
• [Metric] improvement in [area] (e.g., "40% reduction in manual work")
• ROI: [X]x return within [timeframe]
• Implementation: [timeframe] with [level] of effort
• Risk: [How you mitigate concerns]

CTA: "See how [similar company] achieved [result] →"
```

**Example email:**

```
Subject: How Stripe reduced deployment time by 60%

Hi [Name],

The VP of Engineering at a company similar to yours was spending
40 hours per week on code review bottlenecks.

After implementing Acme, they:
• Reduced review time by 60%
• Caught 3x more bugs before production
• Shipped new features 2 weeks faster

Would a 15-minute call to explore if similar results are possible
for [Company] make sense?
```

### Technical Buyer (Engineer/Architect)

**Primary concerns:** Technical fit, security, integration, vendor lock-in

**Messaging principles:**
- Lead with technical capabilities
- Show architecture and security details
- Demonstrate easy integration
- Provide technical documentation

**Template:**

```
HEADLINE: [Technical capability] for [their stack]

OPENING:
"Built for [their technology environment] with [key technical feature]."

KEY POINTS:
• Architecture: [how it works technically]
• Security: [certifications, compliance, encryption]
• Integration: [specific integrations with their tools]
• Performance: [benchmarks, latency, uptime]

CTA: "Read the technical whitepaper →" or "See the API docs →"
```

**Example:**

```
Subject: SOC 2 Type II compliant with 99.99% uptime

Hi [Name],

I noticed [Company] uses Kubernetes for container orchestration.

Acme integrates natively with K8s with:
• Single-line Helm chart deployment
• mTLS encryption for all traffic
• SOC 2 Type II + GDPR compliant
• 99.99% uptime SLA with $10k credit guarantee

Here's our architecture diagram: [link]

Worth a quick technical review?
```

### End User (Manager/Individual Contributor)

**Primary concerns:** Ease of use, daily workflow, learning curve

**Messaging principles:**
- Lead with time savings
- Show product in action (demo, screenshots)
- Emphasize simplicity
- Include peer testimonials

**Template:**

```
HEADLINE: [Daily benefit] in [time to value]

OPENING:
"Imagine [desired outcome] without [pain point]."

KEY POINTS:
• Get started in [timeframe] (no training required)
• Save [hours] every [timeframe]
• [Feature] makes [task] effortless
• Loved by [peer companies/roles]

CTA: "Try free for 14 days →"
```

**Example:**

```
Subject: Spend less time in meetings, more time building

Hi [Name],

What if your weekly status meetings could run themselves?

Acme automatically:
• Collects updates from your team (no nagging)
• Creates visual progress reports (no spreadsheets)
• Flags blockers before they become problems

Teams like [Company A] and [Company B] love it.

Start your free trial: [link]
```

---

## Competitive Messaging

### "Why Us vs. Competitor A" Framework

```
OPENING (acknowledge competition):
"Both [Product] and [Competitor A] help teams with [general category].
Here's what sets us apart:"

DIFFERENTIATORS (3-4 key points):

1. [Your advantage] vs. [Their limitation]
   "Our AI catches 95% of bugs vs. their rule-based 60% coverage"

2. [Your advantage] vs. [Their limitation]
   "Get started in 2 hours vs. their 2-week implementation"

3. [Your advantage] vs. [Their limitation]
   "$50/user vs. their $150/user at scale"

PROOF POINT:
"[Customer] switched from [Competitor A] to us and saw [result]"

CTA:
"See a side-by-side comparison →"
```

### Competitive Positioning Statements

**When they're the market leader:**

```
"[Competitor] built the category, but it was designed for [old paradigm].
[Product] is purpose-built for [new reality] with [key differentiators]."
```

**When they're cheaper:**

```
"[Competitor] costs less upfront, but teams spend [X hours] working
around limitations. [Product] pays for itself in [timeframe] through
[specific efficiency gains]."
```

**When they have more features:**

```
"[Competitor] tries to do everything. [Product] focuses on doing
[core use case] exceptionally well. Our customers tell us they only
use 20% of [Competitor's] features anyway."
```

---

## Channel-Specific Copy

### Landing Page

**Above the fold:**
```
[HEADLINE - 5-7 words, benefit-focused]
Ship faster with AI-powered automation

[SUBHEAD - 1 sentence expanding on value]
Acme automates your workflows so your team can focus on what matters.

[CTA - Action-oriented]
Start Free Trial     |     Book Demo
```

**Social proof bar:**
```
Trusted by 5,000+ teams including [Logo] [Logo] [Logo] [Logo]
```

### Email Subject Lines

**High performers:**
- "How [Similar Company] achieved [result]"
- "[Name], quick question about [their challenge]"
- "Re: [topic they care about]" (for follow-ups)
- "[Specific number]% improvement in [metric]"

**Avoid:**
- "Quick sync?"
- "Following up..."
- "Just checking in"
- ALL CAPS or excessive punctuation!!!

### LinkedIn Ads

**Format: Single image or carousel**

```
HEADLINE (70 chars max):
"Cut code review time by 60%"

BODY (150 chars recommended):
"AI-powered code reviews that catch bugs before production.
Trusted by engineering teams at Stripe and Shopify.
Try free →"

CTA: Learn More / Try Free / Get Demo
```

### Google Ads

**Search ad format:**

```
Headline 1 (30 chars): AI Code Review Platform
Headline 2 (30 chars): Ship 40% Faster
Headline 3 (30 chars): Free 14-Day Trial

Description (90 chars):
Catch bugs before production. Trusted by 5,000+ teams.
Start your free trial today.
```

---

## Objection Handling Scripts

### Price Objection

**"It's too expensive"**

```
ACKNOWLEDGE: "I understand budget is a concern."

REFRAME: "Let me share how our customers think about it...
[Customer] was spending [X hours/dollars] on [problem] every month.
After implementing [Product], they saved [Y hours/dollars], paying
for the solution in [timeframe]."

QUESTION: "What would it be worth to your team to [achieve outcome]?"

ALTERNATIVE: "We also offer [smaller plan/annual discount] that might
work for your current budget. Would that help?"
```

### Competitor Objection

**"We're looking at [Competitor A] too"**

```
ACKNOWLEDGE: "That's smart to evaluate options. [Competitor A] is
a solid product."

DIFFERENTIATE: "The main differences customers tell us about:
1. [Your advantage] - [Competitor] doesn't offer this
2. [Your advantage] - Their approach is [different/older]
3. [Price/support/speed] - We're typically [X] better here"

PROOF: "[Customer] evaluated both and chose us because [reason]."

QUESTION: "What are the 2-3 things that matter most to you in
this decision?"
```

### Timing Objection

**"Not the right time"**

```
ACKNOWLEDGE: "I completely understand. Timing is everything."

EXPLORE: "Out of curiosity, what would need to change for this
to become a priority?"

FUTURE: "Would it make sense to schedule a brief call in [timeframe]
to revisit? I can share relevant updates without any pressure."

VALUE ADD: "In the meantime, I'll send over [relevant content] that
might be useful for when you're ready."
```

### Authority Objection

**"I need to check with my team/boss"**

```
ACKNOWLEDGE: "Of course, that makes sense."

SUPPORT: "What information would be most helpful for that conversation?
I can put together a one-pager with key points."

OFFER: "Would it help if I joined a brief call with [stakeholder]
to answer any technical/business questions directly?"

TIMELINE: "When do you think you'll have that conversation?
I can follow up with any additional materials beforehand."
```

### Technical Objection

**"Will this integrate with our stack?"**

```
ACKNOWLEDGE: "Great question - integration is critical."

CONFIRM: "What are the main tools you need to connect with?
[Listen and take notes]"

ANSWER: "We have native integrations with [tools]. For [tool],
we use [API/webhook/Zapier]. Here's our integration docs: [link]"

PROOF: "[Similar company] uses a similar stack and got integrated
in [timeframe]."

DEMO: "Want me to show you exactly how the integration works
in a quick demo?"
```
