# Positioning Frameworks

Strategic positioning methodologies for B2B SaaS products.

---

## Table of Contents

- [April Dunford Positioning](#april-dunford-positioning)
- [Geoffrey Moore Positioning](#geoffrey-moore-positioning)
- [Positioning Validation](#positioning-validation)
- [Competitive Positioning Map](#competitive-positioning-map)

---

## April Dunford Positioning

### The 5-Step Process

Execute positioning using April Dunford's "Obviously Awesome" methodology:

1. List competitive alternatives (what customers would use instead)
2. Isolate unique attributes (features only you have)
3. Map attributes to value (why each attribute matters)
4. Define best-fit customers (who cares most about this value)
5. Choose market category (where you compete)
6. **Validation:** Best-fit customers articulate your value unprompted

### Step 1: Competitive Alternatives

Document what customers do without your product:

| Alternative Type | Examples | How They Solve It |
|------------------|----------|-------------------|
| Direct competitor | Competitor A, B | Same category, different approach |
| Adjacent solution | Spreadsheets, email | Manual workaround |
| Build in-house | Custom development | Internal solution |
| Do nothing | Ignore problem | Accept status quo |

**Interview Questions:**
- "Before using us, how did you handle this?"
- "What alternatives did you evaluate?"
- "What would you switch to if we disappeared?"

### Step 2: Unique Attributes

Identify capabilities competitors lack:

```
Attribute Audit:
1. Feature: [Real-time collaboration]
   - Competitor A: No (async only)
   - Competitor B: Partial (limited to 5 users)
   - You: Yes (unlimited users, 50ms sync)
   → Unique: Yes

2. Feature: [AI automation]
   - Competitor A: No
   - Competitor B: No
   - You: Yes (3 AI models)
   → Unique: Yes

3. Feature: [Integrations]
   - Competitor A: 500+
   - Competitor B: 200+
   - You: 100
   → Unique: No (table stakes)
```

### Step 3: Attribute-Value Mapping

Connect features to business outcomes:

| Attribute | Value Enabled | Customer Outcome |
|-----------|--------------|------------------|
| Real-time sync | No version conflicts | 50% fewer errors |
| AI automation | Eliminates manual work | Save 10 hrs/week |
| One-click deploy | Faster releases | Ship 2x faster |

**Value Statement Formula:**
`[Feature] enables [Value] so customers achieve [Outcome]`

### Step 4: Best-Fit Customers

Define who values your unique attributes most:

```
Best-Fit Profile:
- Company size: 200-2000 employees
- Industry: SaaS, Professional Services
- Pain: Distributed teams, collaboration bottlenecks
- Evidence:
  - Fastest sales cycles (45 days vs. 75 avg)
  - Lowest churn (3% vs. 8% avg)
  - Highest NPS (65 vs. 45 avg)
```

### Step 5: Market Category

Choose competitive frame:

| Strategy | When to Use | Risk Level |
|----------|-------------|------------|
| Head-to-head | Strong product, big budget | Medium |
| Niche domination | Unique for segment | Low |
| Category creation | True innovation, deep pockets | High |

**Decision Framework:**
- Can you win head-to-head? → Head-to-head
- Can you dominate a niche? → Niche
- Is the market undefined? → Category creation

---

## Geoffrey Moore Positioning

### Crossing the Chasm Framework

Position for technology adoption lifecycle:

```
Technology Adoption Curve:
Innovators (2.5%) → Early Adopters (13.5%) → Early Majority (34%)
                              ↑
                         THE CHASM
```

### Positioning Statement Template

```
FOR [target customer]
WHO [statement of need or opportunity]
THE [product name] IS A [product category]
THAT [key benefit/reason to buy]
UNLIKE [primary competitive alternative]
OUR PRODUCT [primary differentiation]
```

**Example:**
```
FOR mid-market SaaS companies with distributed engineering teams
WHO struggle with coordination across time zones
THE Acme Platform IS A real-time collaboration workspace
THAT eliminates version conflicts and communication delays
UNLIKE Slack and email which create information silos
OUR PRODUCT provides unified project context with AI-powered summaries
```

### Whole Product Concept

Define complete solution for target segment:

| Layer | Components | Your Coverage |
|-------|------------|---------------|
| Generic | Core product | 100% |
| Expected | Basic integrations, support | 90% |
| Augmented | Training, consulting, custom work | 60% |
| Potential | Future roadmap, ecosystem | 30% |

**Gap Analysis:**
- What's missing for complete solution?
- Which partners can fill gaps?
- What must you build vs. buy vs. partner?

---

## Positioning Validation

### Customer Interview Protocol

Validate positioning with target customers:

1. Schedule 15-20 minute calls with 10+ target customers
2. Ask open-ended questions (no leading)
3. Document exact language used
4. Look for patterns across interviews
5. **Validation:** 7+ of 10 describe value similarly

**Interview Script:**

```
Opening (2 min):
"Thanks for your time. I want to understand how you think about
[product category] and your experience with our product."

Questions (10 min):
1. "How would you describe [Product] to a colleague?"
2. "What problem does [Product] solve for you?"
3. "What alternatives did you consider?"
4. "Why did you choose us over [alternative]?"
5. "What would make you stop using us?"

Closing (3 min):
"Is there anything else you'd like to share?"
```

### Quantitative Validation

Test messaging through A/B experiments:

| Test | Control | Variant | Winner Criteria |
|------|---------|---------|-----------------|
| Landing page headline | Old positioning | New positioning | +20% conversion |
| Ad copy | Feature-focused | Value-focused | +15% CTR |
| Email subject | Generic | Personalized | +25% open rate |

**Sample Size Calculator:**
- Baseline conversion: 3%
- Minimum detectable effect: 20% relative lift
- Statistical power: 80%
- Required sample: ~2,500 per variant

---

## Competitive Positioning Map

### 2x2 Matrix Construction

Create visual positioning map:

```
                    HIGH PRICE
                        │
    Enterprise          │         Premium
    (Salesforce)        │         (You?)
                        │
    ────────────────────┼──────────────────
    LOW                 │              HIGH
    EASE OF USE         │         EASE OF USE
                        │
    Legacy              │         Self-Serve
    (Oracle)            │         (Notion)
                        │
                    LOW PRICE
```

### Axis Selection

Choose dimensions that highlight your advantage:

| Good Axes | Why |
|-----------|-----|
| Ease of use vs. Power | If you're easiest to use |
| Speed vs. Accuracy | If you're fastest |
| Price vs. Features | If you're best value |
| Specialization vs. Breadth | If you own a niche |

| Bad Axes | Why |
|----------|-----|
| Quality vs. Price | Everyone claims quality |
| Innovation vs. Stability | Subjective, hard to prove |
| Customer vs. Product focus | Not differentiating |

### Positioning Map Template

```
Market Category: [Your Category]
Date: [Month Year]

Axes:
- X-axis: [Dimension 1] (Low → High)
- Y-axis: [Dimension 2] (Low → High)

Quadrants:
- Top-left: [Quadrant description]
- Top-right: [Quadrant description] ← Your target
- Bottom-left: [Quadrant description]
- Bottom-right: [Quadrant description]

Competitors:
1. [Competitor A]: Position (X, Y), Why
2. [Competitor B]: Position (X, Y), Why
3. [You]: Position (X, Y), Why you win

Strategic Implications:
- Attack: [How to position against Competitor A]
- Defend: [How to protect against Competitor B]
- Differentiate: [Your unique positioning claim]
```
