# Clinical Evidence Requirements

MDR Annex XIV clinical evaluation and post-market clinical follow-up guidance.

---

## Table of Contents

- [Clinical Evidence Framework](#clinical-evidence-framework)
- [Clinical Evaluation Process](#clinical-evaluation-process)
- [Literature-Based Evidence](#literature-based-evidence)
- [Clinical Investigation Requirements](#clinical-investigation-requirements)
- [Post-Market Clinical Follow-up](#post-market-clinical-follow-up)

---

## Clinical Evidence Framework

### Evidence Hierarchy

| Evidence Type | Strength | When to Use |
|---------------|----------|-------------|
| Randomized Controlled Trial | Highest | Novel Class III, high-risk claims |
| Prospective cohort study | High | New technology, performance claims |
| Retrospective analysis | Medium | Established technology, equivalence |
| Literature review | Medium | Well-characterized, equivalent devices |
| Expert opinion | Low | Supportive only, not primary |

### Evidence Requirements by Class

| Class | Minimum Evidence | Clinical Investigation |
|-------|------------------|------------------------|
| I | Risk-benefit analysis | Not typically required |
| IIa | Literature + post-market data | May be required for novel tech |
| IIb | Systematic literature review | Often required for claims |
| III | Comprehensive clinical data | Required unless equivalent |

### Clinical Evidence Pathway

Determine evidence strategy:

1. Assess device classification and risk level
2. Evaluate claim significance (diagnostic, therapeutic)
3. Determine if equivalence can be demonstrated
4. Identify available literature and clinical data
5. Assess gaps requiring additional investigation
6. Develop PMCF plan for ongoing evidence
7. **Validation:** Evidence strategy approved by Notified Body

---

## Clinical Evaluation Process

### Clinical Evaluation Workflow

Execute clinical evaluation per Annex XIV Part A:

1. Identify relevant safety and performance data
2. Define scope and search strategy
3. Conduct systematic literature search
4. Appraise and analyze clinical data
5. Assess benefit-risk profile
6. Document conclusions in Clinical Evaluation Report (CER)
7. Plan post-market clinical follow-up
8. **Validation:** CER reviewed by qualified clinical evaluator

### Clinical Evaluation Report Structure

```
CLINICAL EVALUATION REPORT (CER)
├── 1. Executive Summary
│   ├── Device description and intended purpose
│   ├── Conclusions on safety and performance
│   └── Benefit-risk conclusion
├── 2. Scope of Clinical Evaluation
│   ├── Device identification
│   ├── Clinical claims to be evaluated
│   └── Equivalence assessment (if applicable)
├── 3. Clinical Background
│   ├── Disease/condition overview
│   ├── Current treatment options
│   └── State of the art
├── 4. Clinical Data Sources
│   ├── Pre-clinical data (bench, animal)
│   ├── Clinical investigation data
│   ├── Literature search methodology
│   └── Post-market surveillance data
├── 5. Data Appraisal
│   ├── Study quality assessment
│   ├── Relevance to subject device
│   └── Data contribution to evaluation
├── 6. Data Analysis
│   ├── Safety analysis
│   ├── Performance analysis
│   └── Benefit-risk determination
├── 7. Conclusions
│   ├── Clinical evidence summary
│   ├── Residual risks
│   └── PMCF requirements
└── 8. PMCF Plan Summary
    ├── Data gaps identified
    ├── PMCF activities planned
    └── Update schedule
```

### Qualified Clinical Evaluator

Requirements per Annex XIV:

- Medical degree or equivalent healthcare qualification
- 4+ years clinical experience in relevant field OR
- Research background in relevant domain
- Training in clinical evaluation methodology
- Understanding of MDR requirements

---

## Literature-Based Evidence

### Literature Search Strategy

Execute systematic literature review:

1. Define PICO question (Population, Intervention, Comparison, Outcome)
2. Develop search string with Boolean operators
3. Select databases (PubMed, Embase, Cochrane, etc.)
4. Set date range and language filters
5. Execute search and document results
6. Screen abstracts and full texts
7. **Validation:** Reproducible search, documented exclusion criteria

### Database Selection

| Database | Coverage | Best For |
|----------|----------|----------|
| PubMed/MEDLINE | Biomedical literature | Primary clinical data |
| Embase | Drugs, devices, biomedical | European studies |
| Cochrane Library | Systematic reviews | Meta-analyses |
| CINAHL | Nursing, allied health | User studies |
| IEEE Xplore | Engineering | Technical performance |
| Manufacturer data | Proprietary | Direct device data |

### Data Appraisal Criteria

Evaluate each source:

| Criterion | Assessment | Score |
|-----------|------------|-------|
| Study design | RCT > cohort > case series | 1-5 |
| Sample size | Statistical power adequate | 1-5 |
| Follow-up duration | Sufficient for outcomes | 1-5 |
| Population relevance | Matches IFU population | 1-5 |
| Device equivalence | Technical, biological, clinical | 1-5 |
| Bias risk | Low/medium/high | 1-5 |

### Equivalence Assessment

Demonstrate equivalence per MDCG 2020-5:

**Technical equivalence:**
- Similar design
- Same materials
- Same specifications
- Same manufacturing process

**Biological equivalence:**
- Same tissue contact
- Same biocompatibility
- Same sterilization method

**Clinical equivalence:**
- Same intended purpose
- Same clinical condition
- Same patient population
- Same user (professional/lay)

---

## Clinical Investigation Requirements

### When Investigation is Required

Clinical investigation mandatory:

- [ ] Class III implantable devices (Article 61(4))
- [ ] Novel technology without equivalent
- [ ] Significant modification to existing device
- [ ] New clinical claims not supported by literature
- [ ] Addressing gaps identified in clinical evaluation

### Clinical Investigation Workflow

Conduct clinical investigation:

1. Develop Clinical Investigation Plan (CIP)
2. Submit to Ethics Committee for approval
3. Notify Competent Authority (via EUDAMED)
4. Conduct investigation per GCP principles
5. Collect and analyze clinical data
6. Prepare Clinical Investigation Report
7. Submit serious adverse event reports (within 7-15 days)
8. **Validation:** All subjects completed, data lock achieved

### Clinical Investigation Plan Elements

| Section | Content |
|---------|---------|
| Objectives | Primary and secondary endpoints |
| Design | Randomized, controlled, blinded |
| Population | Inclusion/exclusion criteria |
| Sample size | Statistical justification |
| Procedures | Visit schedule, assessments |
| Endpoints | Safety and performance measures |
| Analysis | Statistical methods |
| Safety | Adverse event definitions, reporting |

### Ethics Committee Submission

Required documentation:

- Clinical Investigation Plan
- Investigator's Brochure
- Informed consent documents
- Case Report Forms
- Investigator CVs
- Insurance certificate
- Device documentation

---

## Post-Market Clinical Follow-up

### PMCF Plan Requirements

Develop PMCF Plan per Annex XIV Part B:

1. Identify residual risks from clinical evaluation
2. Define clinical questions to address
3. Select PMCF methods (survey, registry, study)
4. Specify endpoints and success criteria
5. Define timeline and milestones
6. Plan data collection and analysis
7. Schedule PMCF Evaluation Report updates
8. **Validation:** PMCF Plan approved by Notified Body

### PMCF Methods

| Method | Description | Best For |
|--------|-------------|----------|
| Literature review | Ongoing systematic search | Mature devices |
| Survey | User/patient questionnaire | Real-world experience |
| Registry | Multi-site data collection | Long-term outcomes |
| PMCF study | Prospective clinical study | Specific questions |
| Complaint analysis | Structured complaint review | Safety signals |
| Vigilance data | MAUDE, EUDAMED analysis | Comparative safety |

### PMCF Evaluation Report

Update frequency:

| Device Class | Update Frequency |
|--------------|------------------|
| Class III | Annual |
| Class IIb implantable | Annual |
| Class IIb | Every 2 years |
| Class IIa | Every 2-5 years |
| Class I | When clinically relevant |

### PMCF Report Structure

```
PMCF EVALUATION REPORT
├── 1. Executive Summary
│   └── Key findings and conclusions
├── 2. Scope
│   ├── Device covered
│   └── Reporting period
├── 3. PMCF Activities
│   ├── Methods employed
│   └── Data sources
├── 4. Results
│   ├── Safety data
│   ├── Performance data
│   └── Clinical questions addressed
├── 5. Conclusions
│   ├── Benefit-risk confirmation
│   ├── Residual risks updated
│   └── Need for corrective action
└── 6. Next Steps
    ├── CER update requirements
    └── PMCF Plan modifications
```

### Integration with CER

PMCF data feeds clinical evaluation:

1. PMCF data collected per plan
2. Data analyzed in PMCF Evaluation Report
3. CER updated with PMCF conclusions
4. Risk management file updated
5. IFU updated if needed
6. **Validation:** CER update cycle completed
