# Management Review Guide

ISO 13485 Clause 5.6 management review requirements, inputs, outputs, and action tracking.

---

## Table of Contents

- [Review Requirements](#review-requirements)
- [Required Inputs](#required-inputs)
- [Review Agenda](#review-agenda)
- [Required Outputs](#required-outputs)
- [Action Tracking](#action-tracking)
- [Documentation Templates](#documentation-templates)

---

## Review Requirements

### ISO 13485:2016 Clause 5.6

| Requirement | Specification |
|-------------|---------------|
| Frequency | Planned intervals (typically quarterly or semi-annually) |
| Participants | Top management involvement required |
| Documentation | Records must be maintained |
| Inputs | All required inputs must be reviewed |
| Outputs | Decisions and actions documented |

### Review Schedule

| Review Type | Frequency | Focus | Participants |
|-------------|-----------|-------|--------------|
| Full Management Review | Semi-annual or Annual | Complete QMS performance | CEO, QMR, all department heads |
| Quarterly Quality Review | Quarterly | Key metrics and actions | QMR, Quality team, affected managers |
| Monthly Quality Update | Monthly | Operational metrics | QMR, Quality team leads |

### Planning Checklist

- [ ] Review date scheduled and communicated
- [ ] Previous review actions status updated
- [ ] All input data collected and analyzed
- [ ] Presentation/report prepared
- [ ] Attendee availability confirmed
- [ ] Meeting room and resources arranged
- [ ] Agenda distributed 1 week in advance

---

## Required Inputs

### ISO 13485 Required Input Topics

| Input | Source | Data Period | Responsible |
|-------|--------|-------------|-------------|
| Audit results | Internal and external audits | Since last review | QA Manager |
| Customer feedback | Complaints, surveys, returns | Since last review | Customer Quality |
| Process performance | Process metrics, yields | Since last review | Process owners |
| Product conformity | Inspection data, NCRs | Since last review | QC Manager |
| CAPA status | Open/closed CAPAs | Current status | CAPA Officer |
| Previous review actions | Action item tracker | Since last review | QMR |
| Changes to QMS | Regulatory, standard changes | Since last review | RA Manager |
| Recommendations | Improvement opportunities | Ongoing collection | All managers |

### Input Data Collection Template

```
MANAGEMENT REVIEW INPUT SUMMARY

Review Period: [Start Date] to [End Date]
Prepared By: [Name]
Date Prepared: [Date]

1. AUDIT RESULTS
Internal Audits Completed: [Number]
External Audits Completed: [Number]
Major Findings: [Number] | Minor Findings: [Number]
Open Audit Actions: [Number]
Summary: [Brief narrative]

2. CUSTOMER FEEDBACK
Total Complaints: [Number]
Complaint Rate: [X per 1000 units]
Customer Satisfaction Score: [Score]
Top Complaint Categories:
- [Category 1]: [Count]
- [Category 2]: [Count]
Trend: [Improving/Stable/Declining]

3. PROCESS PERFORMANCE
| Process | Target | Actual | Status |
|---------|--------|--------|--------|
| [Process 1] | [Target] | [Actual] | [Met/Not Met] |

4. PRODUCT CONFORMITY
First Pass Yield: [%]
Nonconformance Rate: [%]
Reject/Scrap Cost: [$]
Top NC Categories:
- [Category 1]: [Count]

5. CAPA STATUS
Open CAPAs: [Number]
Overdue CAPAs: [Number]
Effectiveness Rate: [%]
Average Closure Time: [Days]

6. PREVIOUS ACTIONS
Total Actions from Last Review: [Number]
Completed: [Number] | In Progress: [Number] | Overdue: [Number]

7. QMS CHANGES
Regulatory Changes: [List]
Standard Updates: [List]
Internal Changes: [List]

8. RECOMMENDATIONS
[List improvement opportunities collected]
```

### Data Analysis Guidelines

| Input | Analysis Required | Red Flags |
|-------|------------------|-----------|
| Audit results | Trend by area, repeat findings | Major NC in same area twice |
| Complaints | Pareto analysis, rate trending | Increasing rate, safety issues |
| Process performance | Control charts, capability | Out of control, Cpk <1.33 |
| Product conformity | Defect Pareto, yield trending | Declining yield, new defect types |
| CAPA | Aging analysis, effectiveness | >10% overdue, <80% effective |

---

## Review Agenda

### Standard Agenda Template

```
MANAGEMENT REVIEW AGENDA

Date: [Date]
Time: [Start] - [End]
Location: [Room/Virtual Link]
Chair: [QMR Name]

1. OPENING (10 min)
   - Call to order and attendance
   - Approval of previous meeting minutes
   - Review of previous action items

2. QMS PERFORMANCE (30 min)
   - Audit results summary
   - Process performance metrics
   - Product conformity data
   - Customer feedback analysis

3. COMPLIANCE STATUS (20 min)
   - Regulatory compliance status
   - Certification status
   - Changes affecting QMS

4. CAPA AND IMPROVEMENT (20 min)
   - CAPA status and trends
   - Improvement initiatives status
   - Recommendations for improvement

5. RESOURCE REVIEW (15 min)
   - Resource adequacy assessment
   - Training and competency status
   - Infrastructure needs

6. STRATEGIC ITEMS (15 min)
   - Quality objectives progress
   - Quality policy adequacy
   - Strategic quality initiatives

7. DECISIONS AND ACTIONS (15 min)
   - Decisions required
   - New action items
   - Next review planning

8. CLOSING (5 min)
   - Summary of decisions
   - Action item review
   - Adjournment
```

### Time Allocation by Review Type

| Review Type | Duration | Focus Areas |
|-------------|----------|-------------|
| Full Annual Review | 3-4 hours | All inputs, strategic planning |
| Semi-annual Review | 2-3 hours | All inputs, trend analysis |
| Quarterly Review | 1.5-2 hours | Key metrics, action tracking |

---

## Required Outputs

### ISO 13485 Required Output Topics

| Output | Description | Documentation |
|--------|-------------|---------------|
| Improvement decisions | QMS and process improvements | Action items with owners |
| Resource decisions | Changes to resource allocation | Resource plan updates |
| Quality objectives | Changes to objectives or targets | Updated objectives document |
| QMS changes | Decisions on system modifications | Change requests initiated |

### Output Documentation Template

```
MANAGEMENT REVIEW OUTPUTS

Review Date: [Date]
Review Type: [Annual/Semi-annual/Quarterly]

DECISIONS MADE:

1. QMS IMPROVEMENT DECISIONS
| Decision | Rationale | Owner | Due Date |
|----------|-----------|-------|----------|
| [Decision 1] | [Why] | [Who] | [When] |

2. RESOURCE DECISIONS
| Decision | Resources Required | Budget Impact | Owner |
|----------|-------------------|----------------|-------|
| [Decision 1] | [What needed] | [$] | [Who] |

3. QUALITY OBJECTIVES
| Objective | Current | Target | Change | Rationale |
|-----------|---------|--------|--------|-----------|
| [Objective 1] | [Current target] | [New target] | [+/-] | [Why] |

4. QMS CHANGES APPROVED
| Change | Scope | Implementation Date | Owner |
|--------|-------|---------------------|-------|
| [Change 1] | [Affected areas] | [Date] | [Who] |

CONCLUSIONS:
- Overall QMS effectiveness: [Effective/Needs Improvement]
- Quality policy adequacy: [Adequate/Needs Update]
- Quality objectives progress: [On Track/Behind/Ahead]

NEXT REVIEW:
Date: [Date]
Special Focus Areas: [Areas requiring attention]
```

---

## Action Tracking

### Action Item Format

```
ACTION ITEM

ID: MR-[Year]-[Number]
Source: Management Review [Date]
Category: [ ] Improvement [ ] Resource [ ] Compliance [ ] Other

Description: [Specific action to be taken]
Owner: [Name, Title]
Due Date: [Date]
Priority: [ ] High [ ] Medium [ ] Low

Success Criteria: [How completion will be verified]
Resources Required: [People, budget, equipment]
Dependencies: [Other actions or conditions]

Status Updates:
| Date | Update | Updated By |
|------|--------|------------|
| [Date] | [Progress note] | [Name] |

Completion:
Completed Date: [Date]
Evidence: [Reference to evidence of completion]
Verified By: [Name, Date]
```

### Action Status Categories

| Status | Definition | Color Code |
|--------|------------|------------|
| Not Started | Assigned but work not begun | Gray |
| In Progress | Work underway | Blue |
| On Hold | Blocked, awaiting dependency | Yellow |
| Overdue | Past due date, not complete | Red |
| Complete | Finished, pending verification | Green |
| Verified | Completion verified | Dark Green |
| Cancelled | No longer required | Strikethrough |

### Action Tracking Dashboard

```
MANAGEMENT REVIEW ACTION TRACKER

Review: [Date]
Last Updated: [Date]

SUMMARY:
Total Actions: [Number]
| Status | Count | % |
|--------|-------|---|
| Complete/Verified | [N] | [%] |
| In Progress | [N] | [%] |
| Not Started | [N] | [%] |
| Overdue | [N] | [%] |
| On Hold | [N] | [%] |

OVERDUE ACTIONS (Requires Escalation):
| ID | Description | Owner | Due Date | Days Overdue |
|----|-------------|-------|----------|--------------|
| [ID] | [Brief] | [Name] | [Date] | [Days] |

UPCOMING DUE (Next 30 Days):
| ID | Description | Owner | Due Date |
|----|-------------|-------|----------|
| [ID] | [Brief] | [Name] | [Date] |
```

---

## Documentation Templates

### Meeting Minutes Template

```
MANAGEMENT REVIEW MEETING MINUTES

Date: [Date]
Time: [Start] - [End]
Location: [Location]
Chair: [Name]
Recorder: [Name]

ATTENDEES:
| Name | Title | Present |
|------|-------|---------|
| [Name] | [Title] | ☑ Yes / ☐ No |

AGENDA ITEMS REVIEWED:

1. [Topic]
   Discussion: [Summary of discussion]
   Decision: [Decision made, if any]
   Action: [Action assigned, if any]

2. [Topic]
   ...

DECISIONS SUMMARY:
1. [Decision 1]
2. [Decision 2]

ACTIONS ASSIGNED:
| ID | Action | Owner | Due Date |
|----|--------|-------|----------|
| MR-XX-01 | [Action] | [Name] | [Date] |

NEXT MEETING:
Date: [Date]
Preliminary Agenda Items: [Topics to cover]

APPROVAL:
Chair: _________________ Date: _______
QMR: _________________ Date: _______
```

### Review Effectiveness Metrics

| Metric | Target | Calculation |
|--------|--------|-------------|
| Action completion rate | >90% | Completed on time / Total actions |
| Review attendance | 100% required | Required attendees present / Required |
| Input completeness | 100% | Inputs provided / Required inputs |
| Decision documentation | 100% | Documented decisions / Decisions made |
| Time to complete review | Per schedule | Actual date - Planned date |
