---
name: analyze
description: 个股深度分析。当用户说"分析XX"、"看看XX怎么样"、"XX值得买吗"、"研究一下XX"时使用此skill。
user-invocable: true
---

# /analyze - 个股深度分析 v3.0

基于**宏观-行业-个股**三层分析框架，数据驱动的专业投资分析。

## 使用方式

```
/analyze 588000        # 分析ETF
/analyze 002594        # 分析A股
/analyze 00700         # 分析港股
/analyze 比亚迪        # 用名称也可以
```

---

## 核心投资框架

```
┌─────────────────────────────────────────────────┐
│                 投资分析框架                      │
├─────────────────────────────────────────────────┤
│  1. 宏观环境（大势）20分                          │
│     ├─ 市场周期：牛市/熊市/震荡                   │
│     ├─ 指数趋势：沪深300 vs MA20                 │
│     ├─ 资金环境：北向资金流向                     │
│     └─ 市场情绪：涨跌比例                        │
├─────────────────────────────────────────────────┤
│  2. 行业分析（中观）20分                          │
│     ├─ 板块强弱：相关板块排名                     │
│     ├─ 资金流向：板块净流入                       │
│     ├─ 相对强度：ETF横向对比                     │
│     └─ 政策催化：行业政策动向                     │
├─────────────────────────────────────────────────┤
│  3. 个股分析（微观）60分                          │
│     ├─ 趋势：均线排列+多周期共振                  │
│     ├─ 动能：MACD+RSI                           │
│     ├─ 量价：量比+量价配合+背离                   │
│     └─ 位置：ATR止损+支撑压力                    │
├─────────────────────────────────────────────────┤
│  4. 交易策略                                     │
│     ├─ 买点：理想/激进价位                       │
│     ├─ 止损：ATR动态止损                         │
│     └─ 目标：压力位参考                          │
└─────────────────────────────────────────────────┘
```

---

## 数据来源优先级

| 优先级 | 来源 | 用途 |
|--------|------|------|
| **1** | `fetch_full_analysis.py` | 宏观+行业+技术全套数据 |
| **2** | 用户配置文件 | 持仓、关注方向、投资风格 |
| **3** | WebSearch | **仅用于**财报、公告、研报 |

### 禁止行为

- ❌ 使用WebSearch获取价格数据
- ❌ 编造技术指标
- ❌ 脚本失败时跳过分析
- ❌ 没有数据支撑的模糊判断

---

## 执行步骤

### 第一步：运行完整分析脚本（必须）

```bash
cd "股市信息" && python3 scripts/fetch_full_analysis.py <代码>
```

港股：
```bash
cd "股市信息" && python3 scripts/fetch_full_analysis.py 00700 --market hk
```

### 第二步：解读脚本输出

脚本输出的核心模块：

| 模块 | 字段 | 说明 |
|------|------|------|
| **宏观** | `macro.indices` | 主要指数涨跌 |
| | `macro.market_trend` | 牛市/熊市/震荡判断 |
| | `macro.north_flow` | 北向资金流向 |
| | `macro.market_sentiment` | 涨跌家数比 |
| **行业** | `sector.related_sectors` | 相关板块表现 |
| | `sector.sector_flow` | 板块资金流入 |
| | `sector.etf_comparison` | ETF横向对比 |
| | `sector.relative_strength` | 领涨/跟涨/跟跌 |
| **技术** | `technical.trend` | 均线趋势 |
| | `technical.macd` | MACD状态 |
| | `technical.rsi` | RSI超买超卖 |
| | `technical.atr` | ATR止损参考 |
| | `technical.volume` | 量价配合 |
| **评分** | `score` | 100分制综合评分 |

### 第三步：读取用户配置

```
股市信息/Config/Holdings.md   → 是否已持有
股市信息/Config/Watchlist.md  → 关注方向
股市信息/Config/Profile.md    → 投资风格
```

### 第四步：WebSearch补充（仅限必要时）

只在以下情况使用：
- 公司最新财报
- 近期重大公告
- 机构研报/目标价

**必须标注来源和日期**

---

## 分析框架详解

### 一、宏观环境分析（20分）

脚本输出 `macro` 字段：

```json
{
  "market_trend": {
    "cycle": "牛市",
    "cycle_score": 2,
    "hs300_vs_ma20": 1.51
  },
  "north_flow": {
    "5d_total": 150.5,
    "consecutive_days": 3,
    "direction": "流入",
    "signal": "外资积极"
  },
  "market_sentiment": {
    "up_ratio": 65.2,
    "sentiment": "偏乐观"
  }
}
```

**市场周期判断规则**：

| 条件 | 周期 | 得分 |
|------|------|------|
| 沪深300 > MA20 且 60日涨幅>0 | 牛市 | +12 |
| 沪深300 < MA20 且 60日跌幅>10% | 熊市 | +4 |
| 其他 | 震荡 | +8 |

**北向资金信号**：

| 5日累计 | 方向 | 得分 |
|---------|------|------|
| > 50亿 | 持续流入 | +8 |
| < -50亿 | 持续流出 | +2 |
| 其他 | 中性 | +4 |

### 二、行业分析（20分）

脚本输出 `sector` 字段：

```json
{
  "related_sectors": [
    {"name": "半导体概念", "change": 2.34, "turnover": 5.95},
    {"name": "存储芯片", "change": 1.13, "turnover": 4.27}
  ],
  "sector_flow": [
    {"name": "半导体概念", "net_flow": 38.8亿, "net_ratio": 0.88}
  ],
  "etf_comparison": [
    {"code": "159995", "name": "芯片ETF", "change": 1.16},
    {"code": "588000", "name": "科创50ETF", "change": -0.38}
  ],
  "relative_strength": "跟跌"
}
```

**相对强度判断**：

| ETF vs 同类 | 相对强度 | 得分 |
|-------------|----------|------|
| 涨幅排名前30% | 领涨 | +15 |
| 涨幅接近平均 | 跟涨 | +10 |
| 涨幅排名后30% | 跟跌 | +5 |

**板块资金流向**：

| 相关板块净流入 | 信号 | 得分 |
|----------------|------|------|
| 多数流入 | 板块热度高 | +5 |
| 多数流出 | 板块退潮 | +0 |

### 三、个股技术分析（60分）

#### 趋势分析（25分）

```json
{
  "trend": {
    "status": "多头排列",
    "score": 2
  }
}
```

| 均线状态 | 得分 |
|----------|------|
| 多头排列（MA5>MA10>MA20>MA60） | +25 |
| 偏多（价格>MA20） | +15 |
| 纠缠 | +10 |
| 空头排列 | +5 |

#### 动能指标（15分）

```json
{
  "macd": {"signal": "多头"},
  "rsi": {"value": 65, "signal": "中性"}
}
```

| MACD状态 | 得分 |
|----------|------|
| 金叉/多头 | +10 |
| 死叉/空头 | +5 |

| RSI状态 | 得分 |
|---------|------|
| 中性(30-70) | +5 |
| 超买(>70)或超卖(<30) | +3 |

#### 量价分析（10分）

```json
{
  "volume": {
    "ratio": 0.87,
    "vol_price": "量价平稳"
  }
}
```

| 量价关系 | 得分 |
|----------|------|
| 放量上涨 | +10 |
| 量价平稳 | +6 |
| 缩量上涨 | +4 |
| 放量下跌 | +2 |

#### ATR止损（10分）

```json
{
  "atr": {
    "value": 0.0382,
    "stop_loss": 1.4966,
    "stop_loss_pct": -4.86
  }
}
```

**止损建议**：
- 保守：1倍ATR
- **标准：2倍ATR** → 使用 `stop_loss`
- 激进：3倍ATR

---

## 综合评分体系

| 维度 | 满分 | 评估内容 |
|------|------|----------|
| 宏观 | 20 | 市场周期+北向资金 |
| 行业 | 20 | 相对强度+板块资金 |
| 技术 | 60 | 趋势+动能+量价+位置 |
| **总分** | **100** | |

**评分等级**：

| 分数 | 等级 | 建议 |
|------|------|------|
| 80-100 | **强势** | 可积极参与 |
| 65-79 | **偏强** | 可适度参与 |
| 50-64 | **中性** | 观望为主 |
| 35-49 | **偏弱** | 谨慎 |
| 0-34 | **弱势** | 回避 |

---

## 报告模板

```markdown
# [代码] [名称] 深度分析

**分析时间**：YYYY-MM-DD HH:MM
**数据来源**：AKShare v3.0
**分析框架**：宏观-行业-个股

---

## 快速摘要

| 层级 | 判断 | 得分 |
|------|------|------|
| 宏观环境 | 牛市/熊市/震荡 | XX/20 |
| 行业强度 | 领涨/跟涨/跟跌 | XX/20 |
| 技术形态 | 多头/空头/震荡 | XX/60 |
| **综合** | **强势/偏强/中性/偏弱/弱势** | **XX/100** |

---

## 一、宏观环境（大势）

### 市场周期
- 沪深300：XXXX (+X.X%)
- vs MA20：+X.X%
- 判断：**牛市/熊市/震荡**

### 北向资金
- 今日净流入：XX亿
- 5日累计：XX亿
- 连续流入/流出：X天
- 信号：外资积极/观望/撤退

### 市场情绪
- 上涨家数：XXXX
- 下跌家数：XXXX
- 涨跌比：X:X
- 情绪：乐观/中性/悲观

**宏观得分**：XX/20

---

## 二、行业分析（中观）

### 相关板块表现
| 板块 | 涨跌 | 换手 |
|------|------|------|
| XX | +X.X% | X.X% |

### 板块资金流向
| 板块 | 净流入 | 占比 |
|------|--------|------|
| XX | XX亿 | X.X% |

### ETF横向对比
| ETF | 涨跌 | 相对强度 |
|-----|------|----------|
| 目标ETF | X.X% | 领涨/跟跌 |
| 同类ETF | X.X% | |

**行业得分**：XX/20

---

## 三、技术分析（微观）

### 趋势
- 均线排列：多头/空头/纠缠
- MA5/10/20/60位置

### MACD
- DIF: X.XXX
- DEA: X.XXX
- 状态：多头/空头/金叉/死叉

### RSI
- 数值：XX
- 状态：超买/超卖/中性

### 量价
- 量比：X.XX
- 量价配合：健康/警惕/观望

**技术得分**：XX/60

---

## 四、综合评分

| 维度 | 得分 | 满分 | 明细 |
|------|------|------|------|
| 宏观 | XX | 20 | [detail] |
| 行业 | XX | 20 | [detail] |
| 技术 | XX | 60 | [detail] |
| **总分** | **XX** | 100 | **等级** |

---

## 五、交易策略

### ATR动态止损
- 当前ATR：X.XXX (X.X%)
- **建议止损**：X.XX (-X.X%)

### 操作建议
| 场景 | 价格 | 说明 |
|------|------|------|
| 理想买点 | X.XX | 回调到支撑位 |
| 激进买点 | X.XX | 突破确认 |
| 止损位 | X.XX | 2倍ATR |
| 目标位 | X.XX | 压力位附近 |

### 适合您吗
- ✅/❌ 宏观环境支持
- ✅/❌ 行业处于上升周期
- ✅/❌ 技术形态健康
- ✅/❌ 符合您的投资风格

---

*数据来源：AKShare*
*免责声明：本分析基于历史数据，不构成投资建议*
```

---

## 保存与记录

### 保存报告
```
股市信息/Analysis/[代码]-[名称].md
```

### 更新 Insight.md
将核心建议记录到采纳追踪表。

---

## ETF vs 个股差异

| 项目 | ETF | 个股 |
|------|-----|------|
| 资金流向 | 无（看板块） | 有 |
| 估值数据 | 无 | 有 |
| 财务数据 | 无 | 有 |
| 龙虎榜 | 无 | 有 |
| 成分股 | 有 | 无 |
| 分析重点 | 宏观+行业+趋势 | 全面分析 |

---

## 重要提醒

1. **宏观环境决定方向** - 熊市中再好的股票也难逃下跌
2. **行业强弱决定超额收益** - 选对行业比选对股票更重要
3. **技术分析决定买卖点** - 即使看好也要等合适的位置
4. **止损是最后的防线** - 永远设置止损，控制风险
5. **评分是参考不是决策** - 需结合定性判断

---

## 版本历史

| 版本 | 日期 | 更新内容 |
|------|------|----------|
| v1.0 | 2026-01 | 基础技术分析 |
| v2.0 | 2026-01 | 增加量价分析、多周期趋势、ATR止损 |
| v3.0 | 2026-01 | **完整三层框架：宏观+行业+个股** |
