---
name: review
description: 周期性复盘分析。当用户说"复盘"、"回顾"、"验证"、"总结"、"这周怎么样"时使用此skill。
user-invocable: true
---

# /review - 周期性复盘

对交易决策进行周期性复盘，验证建议准确性，沉淀投资经验。

## 使用方式

- `/review` - 自动判断该做周复盘还是月复盘
- `/review week` - 强制进行周复盘
- `/review month` - 强制进行月复盘
- `/review 2026-01-08` - 复盘某笔特定交易

## 执行步骤

### 第一步：确定复盘范围

读取以下文件确定需要复盘的内容：
- `股市信息/Records/trades.md` - 查找需要验证的交易
- `股市信息/Daily/` - 查找这段时间的简报和建议

**自动判断逻辑**：
- 如果是周末（周六/周日）→ 周复盘
- 如果是月末最后一个交易日 → 月复盘
- 其他时候 → 问用户想做什么

### 第二步：获取验证数据（核心步骤）

运行数据获取脚本获取相关标的的最新价格：
```bash
cd "股市信息" && python3 scripts/fetch_market_data.py
```

**脚本输出包含**：
- `holdings`: 当前持仓行情/净值（含ETF/A股/港股/基金，含成本、盈亏、持有天数）
- `indices`: 大盘指数（用于对比基准收益）
- `north_flow`: 北向资金数据（优先当日分时实时值，可能包含 time 字段）

**必须严格遵守**：
1. **等待脚本执行完成**（约1-2分钟）
2. **所有价格必须来自脚本JSON输出**，不能编造
3. 脚本失败时告知用户，禁止使用默认值
4. 价格展示格式：`X.XXX（来源：AKShare）`

### 第三步：执行复盘分析

#### 周复盘内容

```markdown
# 周复盘 YYYY-WXX (MM-DD ~ MM-DD)

## 一、本周交易回顾

| 日期 | 操作 | 标的 | 操作价 | 现价 | 涨跌 | 初步判断 |
|------|------|------|--------|------|------|----------|
| ... | ... | ... | ... | ... | ... | ... |

## 二、建议执行情况

| 日期 | 建议内容 | 是否执行 | 结果 |
|------|----------|----------|------|
| ... | ... | 是/否 | 对了/错了 |

### 执行了的建议
- 分析执行后的结果

### 没执行的建议
- 分析如果执行了会怎样
- 用户当时为什么没执行
- 这个决策对不对

## 三、持仓变化

| 标的 | 周初价 | 周末价 | 周涨跌 | 贡献 |
|------|--------|--------|--------|------|
| ... | ... | ... | ... | ... |

**本周组合收益**：+/-X.XX%

## 四、经验总结

### 做对了什么
- ...

### 做错了什么
- ...

### 需要改进的
- ...

## 五、下周关注

- ...
```

#### 月复盘内容

```markdown
# 月复盘 YYYY年MM月

## 一、本月交易汇总

### 买入操作
| 日期 | 标的 | 买入价 | 现价 | 浮盈/亏 | 决策质量 |
|------|------|--------|------|---------|----------|

### 卖出操作
| 日期 | 标的 | 卖出价 | 现价 | 卖对了吗 | 决策质量 |
|------|------|--------|------|----------|----------|

### 决策质量评分
- A：完美决策，时机和方向都对
- B：方向对，时机可以更好
- C：方向错，但及时纠正
- D：方向错，且没及时纠正

## 二、建议准确性统计

| 类型 | 总数 | 正确 | 错误 | 准确率 |
|------|------|------|------|--------|
| 止盈建议 | | | | |
| 止损建议 | | | | |
| 加仓建议 | | | | |
| 观望建议 | | | | |

### 错误建议分析
- 哪些建议是错的
- 错在哪里
- 如何改进分析逻辑

## 三、组合表现

### 收益统计
- 月初市值：XXX
- 月末市值：XXX
- 本月收益：+/-X.XX%
- 对比指数：沪深300 X.XX%，中证500 X.XX%

### 持仓变化
| 标的 | 月初仓位 | 月末仓位 | 变化 |
|------|----------|----------|------|

## 四、经验沉淀

### 本月学到的
1. ...
2. ...

### 需要形成的规则
（如果有值得固化的经验，建议添加到 Principles.md）
- ...

### 下月改进计划
1. ...
2. ...

## 五、准则更新建议

基于本月经验，建议添加/修改以下投资准则：
- ...
```

### 第四步：保存复盘报告

- 周复盘保存到：`股市信息/Records/reviews/YYYY-WXX.md`
- 月复盘保存到：`股市信息/Records/reviews/YYYY-MM.md`

### 第五步：更新投资准则（如适用）

如果复盘中沉淀出了值得固化的经验，询问用户是否添加到 `股市信息/Config/Principles.md`

### 第六步：更新待验证交易

在 `trades.md` 中更新已验证交易的验证结果。

### 第七步：更新用户洞察（Insight.md）

读取并更新 `股市信息/Config/Insight.md`：

1. **更新成长轨迹**：
   - 本周期有什么进步，添加到"进步记录"
   - 发现新的问题，添加到"待改进事项"
   - 更新问题出现次数

2. **验证行为模式**：
   - 对比用户自述弱点与实际表现
   - 更新"行为模式观察"的置信度
   - 记录新发现的行为模式

3. **汇总采纳情况**：
   - 统计本周期各类建议的采纳率
   - 分析采纳/不采纳的模式
   - 验证采纳建议的结果（30天/90天后）

4. **提炼关键洞察**：
   - 将复盘中的重要发现记录到"关键洞察"
   - 整理过往洞察，归类到对应板块

---

## 30天/90天验证逻辑

对于每笔交易，系统会在记录时设置验证时点。复盘时检查：

1. **查找到期验证**：检查哪些交易到了30天或90天验证点
2. **获取真实价格**：获取该标的当前真实价格
3. **计算结果**：对比操作价和当前价
4. **判断对错**：
   - 卖出操作：卖后跌了=卖对了，卖后涨了=卖错了
   - 买入操作：买后涨了=买对了，买后跌了=买错了
5. **记录判断**：更新 trades.md 中的验证结果

---

## 数据真实性保障

1. **所有价格必须实时获取**：通过 AKShare 获取，不能编造
2. **无法获取时明确说明**：如果某个数据无法获取，告知用户，不猜测
3. **计算过程透明**：展示收益计算的过程，用户可以验证
4. **数据来源标注**：报告中标注数据获取时间和来源

---

## 示例输出

**用户**：/review

**助手**：今天是周六，我来为您做本周复盘。

首先获取最新数据...

# 周复盘 2026-W02 (01-06 ~ 01-10)

## 一、本周交易回顾

您本周执行了以下操作：

| 日期 | 操作 | 标的 | 操作价 | 现价 | 涨跌 | 初步判断 |
|------|------|------|--------|------|------|----------|
| 01-08 | 清仓 | 消费ETF | 0.805 | 0.812 | +0.87% | 暂时卖早了 |
| 01-09 | 减仓50% | 恒生互联网 | 0.538 | 0.541 | +0.56% | 暂时卖早了 |

（注：短期涨跌不代表决策对错，需要更长时间验证）

## 二、建议执行情况

| 日期 | 建议内容 | 是否执行 | 现在看 |
|------|----------|----------|--------|
| 01-07 | 清仓消费ETF | 是 ✓ | 执行正确，止损逻辑成立 |
| 01-07 | 减仓工业有色一半 | 否 | 好决策！后涨了8% |
| 01-08 | 减仓恒生互联网一半 | 是 ✓ | 待验证 |

...

*数据来源：AKShare，获取时间：2026-01-11 10:00*
