---
name: trade
description: 记录交易操作。当用户说"买了"、"卖了"、"加仓"、"减仓"、"清仓"、"今天没操作"、"记录交易"时使用此skill。
user-invocable: true
---

# /trade - 交易记录

记录用户的买卖操作，更新持仓和交易记录。

## 使用方式

用户会告诉你今天的交易情况，可能的形式：
- "今天买了xxx"
- "卖出了xxx"
- "今天没有操作"
- "加仓了xxx"

## 执行步骤

### 第一步：确认交易信息

向用户确认以下信息（如果用户没有提供完整信息）：
- 标的代码和名称
- 操作类型（买入/卖出/加仓/减仓）
- 成交价格
- 成交数量
- 决策理由（为什么做这个操作）

### 第二步：验证价格真实性（核心步骤）

**必须验证用户提供的价格是否合理**

运行数据获取脚本获取该标的的实时/最新价格：
```bash
cd "股市信息" && python3 scripts/fetch_market_data.py
```

**脚本输出包含**：
- `holdings`: 当前持仓行情（如果是已有持仓的交易）
- 可用于验证用户提供的价格

**必须严格遵守**：
1. **等待脚本执行完成**
2. **使用脚本JSON输出的价格**进行验证
3. 用户提供的成交价与当前价偏差不应超过5%（考虑盘中波动）
4. 如果偏差过大，向用户确认是否输入错误
5. 脚本失败时告知用户，不影响交易记录（以用户提供的价格为准）

### 第三步：更新交易记录

将交易记录追加到 `股市信息/Records/trades.md`，格式：

```markdown
### YYYY-MM-DD

#### 操作N：[操作类型][标的名称]
| 项目 | 内容 |
|------|------|
| 标的 | 代码 名称 |
| 操作 | **买入/卖出/加仓/减仓** |
| 成本/卖出价 | X.XX |
| 数量 | XXXX份/股 |
| 金额 | XXXX元 |
| 盈亏 | （卖出时填写）+/-XX% (约XXXX元) |
| **决策理由** | 用户说明的理由 |
| **当时建议** | 简报中的相关建议（如有） |
| 验证时点 | 30天后日期 / 90天后日期 |
| 验证标准 | 用什么标准判断这次操作对不对 |
```

### 第四步：更新持仓明细

根据操作类型更新 `股市信息/Config/Holdings.md`：

**买入/加仓**：
- 新标的：新增一行
- 已有标的：更新成本价（加权平均）、持仓数量、仓位%

**卖出/减仓**：
- 全部卖出：删除该行
- 部分卖出：更新持仓数量、仓位%（成本价不变）

成本价计算公式（加仓时）：
```
新成本价 = (原成本价 × 原数量 + 新买入价 × 新数量) / (原数量 + 新数量)
```

### 第五步：关联简报建议

读取最近的简报文件（`股市信息/Daily/`），找到相关的操作建议，记录：
- 简报是否建议了这个操作
- 用户是否按建议执行
- 如果用户没有按建议执行，记录用户的独立判断理由

### 第六步：确认并汇总

向用户确认：
1. 交易记录已保存
2. 持仓已更新
3. 显示更新后的持仓概览
4. 提醒验证时点

### 第七步：更新用户洞察（Insight.md）

读取并更新 `股市信息/Config/Insight.md`：

1. **检查建议采纳情况**：
   - 这笔交易是否对应之前简报/投委会的建议
   - 如果是，记录到"采纳记录"表
   - 更新对应来源的采纳率统计

2. **分析决策心理**：
   - 用户的决策理由是什么
   - 是理性分析还是情绪驱动
   - 是否符合/违背用户自述的弱点模式

3. **记录关键洞察**：
   - 如有新发现（如"用户对止盈建议执行很果断"），添加到"关键洞察"
   - 更新"行为模式观察"中的相关判断

---

## 特殊情况处理

### 用户说"今天没操作"

记录到日志，但不更新任何文件。回复：
- 确认收到
- 简要回顾当天简报的建议
- 问用户为什么没有执行（如果简报有建议操作的话）

### 用户补录历史交易

- 确认日期
- 按相同流程处理
- 标注为"补录"

---

## 数据真实性保障

1. **价格验证**：所有用户提供的价格必须与实时数据对比验证
2. **不猜测数据**：如果无法获取某个数据，明确告知用户，不编造
3. **来源标注**：所有自动获取的数据标注来源（AKShare）
4. **用户确认**：关键数据变更前必须让用户确认

---

## 示例对话

**用户**：今天把红利ETF清仓了

**助手**：收到，我来记录这笔交易。请确认以下信息：
- 标的：510880 红利ETF
- 操作：全部卖出
- 您的成交价是多少？
- 卖出数量是多少份？

（用户确认后）

我已验证价格合理（当前价3.50，您的成交价3.48在合理范围内）。

交易记录已保存，持仓已更新：
- 红利ETF 已从持仓中移除
- 本次交易盈利 +8.5%（约1700元）
- 30天验证时点：2026-02-19

这笔操作符合昨天简报的建议。我会在验证时点提醒您回顾。
