# Elevated Direct Response Style Guide

## Voice Characteristics

### DO
- Write like a smart friend texting you
- Use specific numbers ("47 apps" not "many apps")
- Share the system, not just the result
- Include your failures and learning moments
- Use short sentences. Like this.
- Break paragraphs after 2-3 lines max
- Lead with contrarian takes backed by data

### DON'T
- Sound like a corporation ("leverage synergies")
- Use vague superlatives ("best-in-class", "world-class")
- Promise without proof
- Write long, dense paragraphs
- Use fake urgency ("Only 3 spots left!")
- Add unnecessary exclamation marks!!!

## Sentence Structure

**Vary length for rhythm:**
```
Long sentence that sets up the context and gives background.
Short punch.
Another longer sentence that expands on the point.
Then this.
```

**Use fragments intentionally:**
```
The result?
3x growth. Half the effort. Zero burnout.
```

## Formatting Patterns

### Lists
Use bullets for scanability:
- Start each with an action verb
- Keep parallel structure
- End with the strongest point

### Numbers
- Specific > round ("$47,293" not "$50,000")
- Percentages for improvements ("43% faster")
- Time frames for credibility ("in 90 days")

### Emphasis
- **Bold** for key phrases
- Use sparingly
- Never bold entire paragraphs

## Words to Avoid

| Instead of... | Use... |
|---------------|--------|
| Leverage | Use |
| Utilize | Use |
| Innovative | [Be specific about what's new] |
| Best-in-class | [Show the data] |
| Synergy | [Just explain what happens] |
| Transform | [Specific outcome] |
| Revolutionary | [Proof of what changed] |
| Exclusive | Limited to [specific criteria] |

## Words That Work

- Exact ("the exact system")
- Specific ("this specific approach")
- Simple ("simple 3-step process")
- Free (when true)
- New (when actually new)
- Now ("available now")
- Proven ("proven by X")

## Proof Hierarchy

**Strongest to weakest:**
1. Specific numbers with context
2. Named testimonials with results
3. Aggregate data ("12,000+ users")
4. Third-party validation (press, awards)
5. General testimonials
6. Claims without proof (avoid)

## CTA Psychology

**Good CTAs answer:**
- What will I get?
- What do I need to do?
- What happens next?

**Formula:** [Action verb] + [What they get] + [→]

Examples:
- "Download the free checklist →"
- "Start your trial →"
- "Get instant access →"
