---
name: env-management
description: Complete better-env workflow: typed config schema, Vercel sync, and prebuild validation.
---

# Environment Variable Management

Complete better-env workflow: typed config schema, Vercel sync, and prebuild validation.

## Cookbook - Complete These Recipes in Order

### Type-Safe Environment Configuration with better-env

Use better-env config modules for type-safe server/public env access, feature flags, and either-or credential constraints.

```bash
curl -H "Accept: text/markdown" https://fullstackrecipes.com/api/recipes/config-schema-setup
```

### Environment Variable Management with better-env + Vercel

Sync local env files with Vercel environments using better-env pull/load commands while preserving local overrides.

```bash
curl -H "Accept: text/markdown" https://fullstackrecipes.com/api/recipes/env-workflow-vercel
```

### Build-Time Environment Validation with better-env

Validate all env-backed config modules with better-env before build and in CI.

```bash
curl -H "Accept: text/markdown" https://fullstackrecipes.com/api/recipes/env-validation
```
