# Brain Dump Phase

The brain dump is about removing friction. Let the user share information in whatever way is natural for them.

## Purpose

Gather raw material for understanding. You'll refine and clarify later - first, just collect.

## Your Mindset

"Help me understand everything you know about this."

Not: "Tell me about X, then Y, then Z."

## What You're Listening For

### Explicit Information
- The core problem or goal
- Who benefits and how
- Technical requirements
- Constraints and boundaries

### Implicit Information
- Context they assume you know
- Assumptions they're making
- Excitement or concern in their language
- References to other systems or people

### Missing Information
- Things they should mention but don't
- Gaps you'll need to explore later

## Prompts That Work

**Opening:**
- "Tell me everything about this project"
- "What are we trying to accomplish here?"
- "Walk me through what you're imagining"

**Continuation:**
- "What else should I know?"
- "What's the backstory?"
- "Are there related systems or projects?"

**Sources:**
- "What should I reference while working on this?"
- "Are there docs, designs, or existing code I should look at?"
- "Who else knows about this that I might need to consult?"

## What to Avoid

**Don't interrupt too early**
Let them finish their thought. Clarifying questions come later.

**Don't impose structure**
If they want to jump around, let them. You'll organize later.

**Don't dismiss tangents**
"Irrelevant" information often isn't. Let them share it.

**Don't show impatience**
They're sharing context. Even if it seems slow, it matters.

## When to Move On

Move to clarifying questions when:
- They've shared everything they want to share
- Natural pauses indicate they're waiting for you
- You've asked "What else?" and they have nothing more

Don't move on if:
- They're still mid-thought
- You haven't asked about sources/references
- They seem to have more but aren't sure if it's relevant
