# Confirmation Phase

Before generating the PRD, present your understanding and get explicit approval.

## Purpose

Validate that your understanding matches the user's intent. Catch misunderstandings before they become wasted work.

## What to Present

### 1. Problem Statement
What problem are we solving? For whom?

"We're building [X] to solve [problem] for [users]."

### 2. Proposed Solution
What will we actually build?

"The solution includes [components/features]. It will [do X, Y, Z]."

### 3. Scope Boundaries
What's in? What's explicitly out?

"In scope: [list]. Out of scope for now: [list]."

### 4. Approach Overview
High-level phases and key decisions.

"I'm planning to approach this in [N] phases: [phase summary]."

### 5. Verification Strategy
How will we know it works?

"We'll verify through [testing approach] and [browser verification if applicable]."

## Getting Real Approval

"Does this match your expectations?" is weak.

**Ask specifically:**
- "Is anything missing from this understanding?"
- "Is anything here that shouldn't be?"
- "Do the phases make sense in this order?"
- "Is the verification approach sufficient?"
- "What would make you uncomfortable proceeding with this plan?"

## Handling Feedback

### If they agree
- Confirm: "I'll proceed with generating the PRD based on this understanding."
- Move to generation.

### If they have minor adjustments
- Incorporate the changes.
- Briefly confirm the updates: "So [change], correct?"
- Move to generation.

### If they have major changes
- Don't generate yet.
- Discuss the changes.
- Re-present the full understanding.
- Get fresh approval.

### If they're uncertain
- Ask what specifically feels off.
- Return to clarifying questions for that area.
- Re-confirm when resolved.

## Common Issues

### Scope Creep at Confirmation
User suddenly adds features during confirmation.

- Acknowledge the addition.
- Clarify: "Should this be part of this PRD or a follow-up?"
- Adjust understanding and re-confirm.

### Misaligned Priorities
User emphasizes something you thought was minor.

- Adjust phase breakdown to reflect real priorities.
- Re-confirm the updated approach.

### Technical Disagreement
You disagree with an approach they want.

- Explain your concern clearly.
- Offer alternatives.
- Ultimately, defer to their decision (it's their project).
- Document the risk if relevant.

## The Quality Bar

Don't proceed until:
- User has explicitly approved the understanding
- You're confident in the scope and approach
- No significant open questions remain
- Testing strategy is clear

Proceed even if:
- Some implementation details are fuzzy (you'll figure them out)
- Minor edge cases aren't fully specified (you'll handle them)
- The approach might evolve (that's normal)
