# [Project Name]

[2-3 sentence description of what this project does, its tech stack, and its current status.]

**Tech Stack**: [Framework], [Database], [Key Libraries]
**Status**: [Development/Production]
**Target Users**: [Who uses this]

---

## Development Workflow

1. **Create feature branch** from `main`
2. **Implement with tests** (TDD encouraged)
3. **Run checks**: `[lint command] && [typecheck command] && [test command]`
4. **Create PR** with description
5. **Get review** and address feedback
6. **Merge to main** (squash merge)
7. **Auto-deploy** to [environment]

### Local Development
1. Clone repo
2. Copy `.env.example` to `.env.local`
3. Run `[install command]`
4. Run `[dev command]`
5. Open http://localhost:[port]

---

## Things NOT to Do

- **NEVER** commit `.env` files
- **NEVER** [project-specific warning 1]
- **NEVER** [project-specific warning 2]
- **DON'T** [anti-pattern 1]
- **DON'T** [anti-pattern 2]
- **AVOID** [thing to avoid]

---

## Common Code Practices

### Component Structure
- [Convention 1]
- [Convention 2]

### Naming Conventions
- Components: PascalCase
- Utilities: camelCase
- Constants: SCREAMING_SNAKE_CASE

### Patterns
- Prefer `async/await` over `.then()`
- Use early returns to reduce nesting
- [Project-specific pattern 1]
- [Project-specific pattern 2]

### File Organization
- [Where tests live]
- [Where types live]
- [Where utilities live]

---

## Commands

| Command | Description |
|---------|-------------|
| `[install]` | Install dependencies |
| `[dev]` | Start dev server |
| `[test]` | Run unit tests |
| `[test:e2e]` | Run E2E tests |
| `[build]` | Build for production |
| `[lint]` | Run linter |
| `[typecheck]` | Type checking |

### Combined Commands
- **Before commit**: `[lint] && [typecheck] && [test]`
- **Full validation**: `[build] && [test:e2e]`

---

## Available Skills

Skills are specialized workflows triggered by slash commands.

| Skill | Trigger | Purpose |
|-------|---------|---------|
| prd | `/prd` | Create product requirements documents |
| agent-browser | `/agent-browser` | Browser automation and E2E testing |
| [skill-name] | `/[trigger]` | [Purpose] |
| [skill-name] | `/[trigger]` | [Purpose] |

### When to Use Each
- **prd**: Before implementing any significant feature
- **agent-browser**: For E2E testing or browser automation
- **[skill]**: [When to use]

---

## MCP Servers

MCPs provide additional capabilities.

| MCP | Purpose | When to Use |
|-----|---------|-------------|
| context7 | Framework documentation | Looking up framework/library docs |
| [mcp-name] | [Purpose] | [When to use] |

### MCP vs CLI
Prefer CLIs over MCPs (more token-efficient):
- Use `[cli]` CLI, not [Service] MCP
- Use `gh` CLI, not GitHub MCP

### Context Window Status
- MCPs enabled: [N]
- Estimated tools: ~[N]
- Status: [Healthy/Warning]

---

## Documentation Methods

### Framework/Library Docs
Use Context7 MCP for:
- [Framework] documentation
- Package documentation

### Errors and Solutions
Use web search for:
- Error messages
- Stack Overflow solutions
- GitHub issues

### Project Docs
- [Doc type]: `[path]`
- [Doc type]: `[path]`

### External Resources
- [Resource]: [URL]
- [Resource]: [URL]

---

## Subagents

Subagents are specialized Claude instances with limited tools.

| Subagent | Tools | When to Use |
|----------|-------|-------------|
| planner | Read, Glob, Grep | Before implementing features |
| code-reviewer | Read, Glob, Grep | After completing features |
| tdd-guide | Full dev tools | Test-driven development |
| refactor-cleaner | Read, Edit, Grep | Removing dead code |

### When to Delegate
- **planner**: Before any significant implementation
- **code-reviewer**: Before creating PR
- **tdd-guide**: When tests are required
- **refactor-cleaner**: For cleanup tasks

---

## General Guidelines

### Performance
- [Performance guideline 1]
- [Performance guideline 2]

### Security
- Validate all user input
- Never expose API keys in client code
- [Project-specific security note]

### Testing Priority
1. Business logic (highest)
2. API endpoints
3. Complex UI interactions
4. Simple components (lowest)

### Getting Help
- Check existing code for patterns
- Search codebase before creating new utilities
- Ask if unsure about conventions

---

## Active Rules

Rules in `.claude/rules/` are always enforced:

| Rule | Key Points |
|------|------------|
| security.md | No secrets in code, validate inputs |
| coding-style.md | [Style summary] |
| testing.md | [Testing summary] |
| git-workflow.md | [Git summary] |

---

<!--
Template version: 1.0
Generated by: setup-claude skill
Last updated: [DATE]

Sections:
1. Project Description ✓
2. Development Workflow ✓
3. Things NOT to Do ✓
4. Common Code Practices ✓
5. Commands ✓
6. Available Skills ✓
7. MCP Servers ✓
8. Documentation Methods ✓
9. Subagents ✓
10. General Guidelines ✓
-->
