# Create an Asset

**For Sales Teams Everywhere**

Generate professional, customer-ready sales assets in minutes. No design skills required.

---

## What It Does

This skill creates tailored sales assets by asking you about:
1. **Your prospect** — who they are, what you've discussed
2. **Your audience** — who's viewing, what they care about
3. **Your purpose** — what you want to achieve
4. **Your format** — how you want to present it

Then it researches, writes, designs, and builds a polished asset you can share with customers.

---

## Supported Formats

| Format | Best For | Output |
|--------|----------|--------|
| **Interactive Landing Page** | Exec meetings, value prop presentations | Multi-tab page with demos and calculators |
| **Deck-Style** | Formal presentations, large audiences | Linear slides with navigation |
| **One-Pager** | Leave-behinds, quick summaries | Single-scroll executive summary |
| **Workflow / Architecture Demo** | Technical deep-dives, POC proposals | Interactive diagram with animated flow |

---

## Quick Start

### Option 1: Simple prompt
```
Create an asset for Acme Corp
```

### Option 2: With context
```
Create an asset for Acme Corp. I met with their VP Engineering
last week - they're struggling with slow release cycles and
want to improve developer productivity. This is for a follow-up
with their technical team.
```

### Option 3: Workflow demo
```
I want to mock up a workflow showing how a customer would use
our product to automate their invoice processing. The flow is:
invoices come in via email → our AI extracts data → validates
against their ERP → flags exceptions for human review.
```

---

## What Gets Created

### Interactive Landing Page
- Tabbed navigation
- Company metrics and research
- Use case demos
- ROI calculator
- Professional dark theme with prospect's brand colors

### Deck-Style
- Title slide with both logos
- Agenda
- Content slides (one message per slide)
- Summary and next steps
- Speaker notes included

### One-Pager
- Hero statement
- 3 key value points
- Proof point
- Clear CTA

### Workflow Demo
- Visual component nodes
- Animated data flow
- Step-by-step walkthrough
- Play/pause/step controls
- Sample data at each stage

---

## The Process

```
1. You provide context (prospect, audience, purpose)
          ↓
2. Skill researches the prospect company
          ↓
3. Skill asks 3-4 clarifying questions
          ↓
4. You confirm direction
          ↓
5. Skill builds the asset
          ↓
6. You iterate as needed
```

---

## Sharing Your Asset

The output is a self-contained HTML file. Share it by:

- **Static hosting**: Upload to Netlify, Vercel, GitHub Pages, or any web host
- **Password protect**: Most hosts offer simple password protection
- **Direct share**: Email the HTML file — it works offline
- **Embed**: iframe it into other pages or portals

---

## Tips for Best Results

### Provide Rich Context
The more you share about past conversations, pain points, and stakeholder concerns, the more tailored the asset will be.

### Upload Transcripts
If you have call recordings, meeting notes, or email threads, upload them. The skill will extract key quotes and priorities.

### Be Specific About Audience
"Technical team" is good. "IT architects evaluating our security model" is better.

### Iterate Freely
First draft not quite right? Just say what to change. Colors, sections, messaging, flow — all adjustable.

---

## Examples

| Scenario | Format | Key Features |
|----------|--------|--------------|
| Post-discovery exec meeting | Interactive page | ROI calculator, their stated priorities, case studies |
| Technical architecture review | Workflow demo | System diagram, data flows, integration points |
| Board presentation leave-behind | One-pager | Strategic alignment, key metrics, clear CTA |
| Large stakeholder meeting | Deck-style | Linear narrative, one point per slide, appendix |

---

## FAQ

**Q: Does it work for any product/company?**
A: Yes. The skill detects what you're selling from your email domain and researches accordingly.

**Q: How does it know my prospect's brand colors?**
A: It extracts them from the prospect's website or brand guidelines. You can adjust after.

**Q: Can I use my company's branding instead?**
A: Yes — after the first build, just ask to switch to your brand colors.

**Q: What if the research is wrong?**
A: Flag it and provide corrections. The skill will regenerate with accurate info.

**Q: Can I export as PDF?**
A: Yes — ask for a print-optimized version and use your browser's print-to-PDF.

---

## Support

Questions or feedback? This skill is part of the public sales skills collection.

---

*Built for salespeople who'd rather sell than design slides.*
