# SKILL 5: Decision Tree Navigation ("The Altitude Dance")

## Overview
This skill teaches you to move fluidly between execution (Level 1: getting stuff done) and strategic evaluation (Level 2: critical thinking). Projects rarely unfold linearly—they require frequent course correction. Most trainees should spend MORE time on their project's decision tree.

## Core Principle
**"Learn the altitude dance"**

Move back and forth frequently between:
- **Level 1:** Full immersion in experimental details or coding
- **Level 2:** Step back, clear your head, evaluate as if someone else did the work

These cannot be done simultaneously. The key to navigating a project's decision tree is alternating between these levels deliberately.

## Key Concepts

**Why Decision Trees Matter:**
Once you're in a project, the landscape changes:
- You've learned from initial experiments
- New papers have been published
- Technology has advanced
- Your assumptions have been tested

At any decision point, you should rarely follow your plan from 2 years ago—there will be a better alternative.

**The Altitude Levels:**
- **Level 1 (Ground Level):** Doing the work, troubleshooting, optimizing
- **Level 2 (Strategic Altitude):** What did we learn? What should we do next?
- **Level 3 (Field Altitude):** How does this fit in the broader landscape?
- **Level 4 (Career Altitude):** Is this the right use of my finite time?

**Common Failure Modes:**
1. **Stuck in Level 1:** Troubleshooting endlessly without reassessing the plan
2. **Only Level 2:** Brilliant strategist but never rolls up sleeves
3. **No rhythm:** Switching randomly instead of deliberately

## Workflow

### Phase 1: Map Your Decision Tree

For your project, identify:
1. **Initial plan:** What was the intended path?
2. **Branch points:** Where might alternative paths emerge?
3. **Decision criteria:** What determines which branch to take?
4. **New information:** What could change the landscape?

### Phase 2: Establish Your Rhythm

**Recommended Schedule:**
- **Daily:** Level 1 work (experiments, coding, analysis)
- **Weekly:** Level 2 evaluation (1-2 hours, ideally Friday afternoon)
- **Monthly:** Level 3 field review (read new papers, attend seminars)
- **Quarterly:** Level 4 career check-in (with mentor)

**Level 2 Weekly Protocol:**
1. Clear your head (walk, coffee, change of scene)
2. Review what happened this week
3. Ask: What did we learn?
4. Ask: What should happen next?
5. Update decision tree
6. Plan next week's Level 1 work

### Phase 3: Decision Points

At each major branch point:

**Example: Genetic Screen Hits Wall**

Instead of endless troubleshooting:
- **Alternative 1:** Redo computational analysis with larger genome dataset
- **Alternative 2:** Use AlphaFold models to search for similar folds
- **Alternative 3:** Print and test larger candidate set (DNA synthesis cheaper now)

**Framework:**
1. **Acknowledge the stuck point**
2. **Step to Level 2:** Evaluate with fresh eyes
3. **Consider: What's newly possible?** (technology, knowledge)
4. **Generate 3 alternatives**
5. **Decide:** Troubleshoot more vs. pursue alternative

## Output: Decision Tree Map
- Visual map of your project's decision points
- Update frequency schedule
- Criteria for each branch point
- Protocol for getting unstuck
