**PREFACE**

Remove this **Preface** before finalizing and distributing the clinical trial protocol.

This clinical trial protocol template is a suggested format for Phase 2 and 3 clinical trials funded by the National Institutes of Health (NIH) that are being conducted under a Food and Drug Administration (FDA) Investigational New Drug (IND) or Investigational Device Exemption (IDE) Application. Investigators for such trials are encouraged to use this template when developing protocols for NIH-funded clinical trial(s). This template may also be useful to others developing phase 2 and 3 IND/IDE clinical trials.

The goal of this template is to assist investigators to write a comprehensive clinical trial protocol that meets the standard outlined in the *International Conference on Harmonisation (ICH) Guidance for Industry, E6 Good Clinical Practice: Consolidated Guidance (ICH-E6)*. Its use will also help investigators think through the scientific basis of their assumptions, minimize uncertainty in the interpretation of outcomes, and prevent loss of data. A common protocol structure and organization will facilitate protocol review by oversight entities.

It is important to note that the clinical trial protocol template is just one piece of information required for an IND or IDE submission. For complete details on IND or IDE submissions see 21 CFR Part 312: Investigational New Drug Application or 21 CFR Part 812: Investigational Device Exemptions, respectively.

**How To Use This Template**

It is important to incorporate all sections of the template into your protocol and to do so in the same order. If a particular section is not applicable to your trial, include it, but indicate that it is not applicable.

This template contains two types of text: instruction/explanatory and example.

**Instruction/explanatory text** are indicated by *italics* and should deleted. Footnotes to instructional text should also be deleted. This text provides information on the content that should be included. It also notes if a section should be left blank. For example, many headings include the instruction, "*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*"

**Example text** is included to further aid in protocol writing and should either be modified to suit the drug, biologic or device (study intervention), design, and conduct of the planned clinical trial or deleted. Example text is indicated in [regular font]. Within example text, a need for insertion of specific information is notated by <angle brackets>.

Instruction/explanatory text should be deleted. Example text can be incorporated as written or tailored to a particular protocol. If it is not appropriate to the protocol, however, it too should be deleted. The section headers include formatting to generate a table of contents.

Version control is important to track protocol development, revisions, and amendments. It is also necessary to ensure that the correct version of a protocol is used by all staff conducting the study. With each revision, the version number and date located in the footer of each page should be updated. When making changes to an approved and "final" protocol, the protocol amendment history should be maintained (see Section 10.4).

**RESOURCES**

Remove **Resources** before finalizing and distributing the clinical trial protocol.

Center for Medicare & Medicaid Services (CMS)

- [Clinical Laboratory Improvement Amendments](https://www.cms.gov/Regulations-and-Guidance/Legislation/CLIA/index.html?redirect=/clia/)

Code of Federal Regulations (CFR)

- [21 CFR Part 11: Electronic Records, Electronic Signatures](https://www.ecfr.gov/cgi-bin/text-idx?SID=007006046b07c9fc5244ec13ef4a77bb&mc=true&node=pt21.1.11&rgn=div5)

- [21 CFR Part 50: Protection of Human Subjects](https://www.ecfr.gov/cgi-bin/text-idx?SID=6d82202a67ba5bd44148d99f4aaf7198&mc=true&node=pt21.1.50&rgn=div5)

- [21 CFR Part 54: Financial Disclosure by Clinical Investigators](https://www.ecfr.gov/cgi-bin/text-idx?SID=bae2d66180fd49cb11f40a935cd760a7&mc=true&node=pt21.1.54&rgn=div5)

- [21 CFR Part 56: Institutional Review Boards](https://www.ecfr.gov/cgi-bin/text-idx?SID=64724709940d94a34270c77fdb8d307f&mc=true&node=pt21.1.56&rgn=div5)


- [21 CFR Part 58: Good Laboratory Practice for Nonclinical Laboratory Studies](http://www.ecfr.gov/cgi-bin/text-idx?SID=90f8b344173d4c43e0c515d0a0cbc4de&mc=true&node=pt21.1.58&rgn=div5)

- [21 CFR Part 210: Current Good Manufacturing Practice In Manufacturing, Processing, Packing, Or Holding Of Drugs; General](http://www.ecfr.gov/cgi-bin/text-idx?SID=90f8b344173d4c43e0c515d0a0cbc4de&mc=true&node=pt21.4.210&rgn=div5)

- [21 CFR Part 211: Current Good Manufacturing Practice For Finished Pharmaceuticals](http://www.ecfr.gov/cgi-bin/text-idx?SID=90f8b344173d4c43e0c515d0a0cbc4de&mc=true&node=pt21.4.211&rgn=div5)
- [21 CFR Part 312: Investigational New Drug Application](https://www.ecfr.gov/cgi-bin/text-idx?SID=27a0c0825d11663283856731fb14c8d2&mc=true&node=pt21.5.312&rgn=div5)

- [21 CFR Part 812: Investigational Device Exemptions](https://www.ecfr.gov/cgi-bin/text-idx?SID=0f8fa3b740966b3d21d5501233e2b493&mc=true&node=pt21.8.812&rgn=div5)

- [42 CFR Part 11: Clinical Trial Registration and Results Information Submission](https://www.gpo.gov/fdsys/pkg/CFR-2016-title42-vol1/pdf/CFR-2016-title42-vol1-part11.pdf)

- [45 CFR Part 46: Protection of Human Subjects Research](http://www.hhs.gov/ohrp/humansubjects/guidance/45cfr46.html)

Food and Drug Administration (FDA)

- [Compliance Actions and Activities](http://www.fda.gov/ICECI/EnforcementActions/default.htm)

- [FDA Regulations Relating to Good Clinical Practice and Clinical Trials](http://www.fda.gov/ScienceResearch/SpecialTopics/RunningClinicalTrials/ucm155713.htm)

- [Guidance for Clinical Investigators, Sponsors, and IRBs Adverse Event Reporting to IRBs -- Improving Human Subject Protection](http://www.fda.gov/downloads/RegulatoryInformation/Guidances/UCM126572.pdf)

- [Guidance for Clinical Trial Sponsors: Establishment and Operation of Clinical Trial Data Monitoring Committees](http://www.fda.gov/downloads/RegulatoryInformation/Guidances/ucm127073.pdf)

- [Guidance for Industry: E6 Good Clinical Practice: Consolidated Guidance](https://www.fda.gov/downloads/Drugs/.../Guidances/ucm073122.pdf)

- [Guidance for Industry: Electronic Source Data in Clinical Investigations](http://www.fda.gov/downloads/drugs/guidancecomplianceregulatoryinformation/guidances/ucm328691.pdf)

- [Guidance for Industry: Multiple Endpoints in Clinical Trials](https://www.fda.gov/downloads/Drugs/GuidanceComplianceRegulatoryInformation/Guidances/UCM536750.pdf)

- [Guidance for Industry: Oversight of Clinical Investigations -- A Risk-Based Approach to Monitoring](http://www.fda.gov/downloads/Drugs/Guidances/UCM269919.pdf)

- [Guidance for Industry: Providing Regulatory Submissions in Electronic Format - Human Pharmaceutical Product Applications and Related Submissions Using the eCTD Specifications](http://www.fda.gov/downloads/Drugs/GuidanceComplianceRegulatoryInformation/Guidances/UCM333969.pdf)

- [Guidance for Industry: Providing Regulatory Submissions in Electronic Format --- Standardized Study Data](http://www.fda.gov/downloads/Drugs/GuidanceComplianceRegulatoryInformation/Guidances/UCM292334.pdf)

- [Guidance for Industry: Safety Assessment for IND Safety Reporting](http://www.fda.gov/downloads/drugs/guidancecomplianceregulatoryinformation/guidances/ucm477584.pdf)

Department of Health and Human Services (HHS)

- [The HIPAA Privacy Rule](http://www.hhs.gov/hipaa/for-professionals/privacy/)


[HIPAA Privacy Rule: Information for Researchers](https://www.hhs.gov/hipaa/for-professionals/special-topics/research/index.html)

International Conference on Harmonisation of Technical Requirements for Registration of Pharmaceuticals for Human Use (ICH)


- [Guidance for Industry, E6 (R2) Good Clinical Practice: Consolidated Guidance](http://www.fda.gov/downloads/Drugs/GuidanceComplianceRegulatoryInformation/Guidances/UCM464506.pdf)
- [Guidance for Industry, M3(R2) Nonclinical Safety Studies for the Conduct of Human Clinical Trials and Marketing Authorization for Pharmaceuticals](http://www.fda.gov/downloads/drugs/guidancecomplianceregulatoryinformation/guidances/ucm073246.pdf)

- [Guideline for Industry, E3 Structure and Content of Clinical Reports](http://www.fda.gov/downloads/drugs/guidancecomplianceregulatoryinformation/guidances/ucm073113.pdf)

- [Guidance for Industry, E9 Statistical Principles for Clinical Trials](http://www.fda.gov/downloads/drugs/guidancecomplianceregulatoryinformation/guidances/ucm073137.pdf)

- [Final Concept Paper E9(R1): Addendum to Statistical Principles for Clinical Trials on Choosing Appropriate Estimands and Defining Sensitivity Analyses in Clinical Trials](http://www.ich.org/fileadmin/Public_Web_Site/ICH_Products/Guidelines/Efficacy/E9/E9__R1__Final_Concept_Paper_October_23_2014.pdf)

International Organization for Standardization (ISO)

- [Clinical Investigation of Medical Devices for Human Subjects -- Good Clinical Practice (ISO 14155:2011)](https://www.iso.org/obp/ui/%20-%20iso:std:iso:14155:ed-2:v1:en)

National Institutes of Health (NIH)

- [Certificates of Confidentiality (CoC) Kiosk](http://grants.nih.gov/grants/policy/coc/index.htm)

- [Clinical Trials Registration and Results Information Submission](https://www.federalregister.gov/documents/2016/09/21/2016-22129/clinical-trials-registration-and-results-information-submission)

- [Financial Conflict of Interest](http://grants.nih.gov/grants/policy/coi/)

- [Inclusion of Children- Policy Implementation](https://grants.nih.gov/grants/funding/children/children.htm)

- [Inclusion Of Women And Minorities As Participants In Research Involving Human Subjects- Policy Implementation Page](http://grants.nih.gov/grants/funding/women_min/women_min.htm)

- [NIH Data Sharing Policies and Related Guidance on NIH-Funded Research Resources](http://grants.nih.gov/policy/sharing.htm)

- [NIH Data Sharing Policy and Implementation Guidance](http://grants.nih.gov/grants/policy/data_sharing/data_sharing_guidance.htm)

- [NIH Genomic Data Sharing Policy](https://gds.nih.gov/03policy2.html)

- [NIH Grants Policy Statement, Section 8.2 Availability of Research Results: Publications, Intellectual Property Rights, and Sharing Research Resources](http://grants.nih.gov/grants/policy/nihgps/HTML5/section_8/8.2_availability_of_research_results_publications__intellectual_property_rights__and_sharing_research_resources.htm)


- [NIH Policy on the Dissemination of NIH-Funded Clinical Trial Information](https://www.gpo.gov/fdsys/pkg/FR-2016-09-21/pdf/2016-22379.pdf)
- [NIH Public Access Policy Details](http://publicaccess.nih.gov/policy.htm)

- [Policy on Good Clinical Practice Training for NIH Awardees Involved in NIH-funded Clinical Trials](https://grants.nih.gov/grants/guide/notice-files/NOT-OD-16-148.html)

- [Required Education in the Protection of Human Research Participants](http://grants.nih.gov/grants/guide/notice-files/NOT-OD-01-061.html)

Office for Human Research Protections (OHRP)

- [Human Subject Regulations Decision Charts](http://www.hhs.gov/ohrp/policy/checklists/decisioncharts.html)

- [Informed Consent Checklist](http://www.hhs.gov/ohrp/policy/consentckls.html)

- [Informed Consent Tips](http://www.hhs.gov/ohrp/policy/ictips.html)

- [IRBs and Assurances](http://www.hhs.gov/ohrp/assurances/)

- [Regulations & Policy Index](http://www.hhs.gov/ohrp/regulations-and-policy/index.html)

- [Unanticipated Problems Involving Risks and Adverse Events Guidance](http://www.hhs.gov/ohrp/regulations-and-policy/guidance/reviewing-unanticipated-problems/index.html)

- [Vulnerable Populations](http://www.hhs.gov/ohrp/regulations-and-policy/guidance/vulnerable-populations/)

Other

- [Citing Medicine, 2nd edition: The NLM Style Guide for Authors, Editors, and Publishers](http://www.ncbi.nlm.nih.gov/books/NBK7256/)

- [CONSORT statement](http://www.consort-statement.org/)


- [International Committee of Medical Journal Editors (ICMJE): Recommendations](http://www.icmje.org/recommendations/)

[Practical Aspects of Signal Detection in Pharmacovigilance: Report of CIOMS Working Group VIII](http://cioms.ch/shop/product/practical-aspects-of-signal-detection-in-pharmacovigilance-report-of-cioms-working-group-viii/)

**<Title>**

*The title should be easy to remember, recognizable by administrative support staff, and sufficiently different from other protocol titles to avoid confusion. Brevity with specificity and neutrality is the goal. If there is a "short title" (e.g., an abbreviation used to refer to the study title, include here and that can be used throughout this document in place of the full title).*

**Protocol Number: < Number>**

**National Clinical Trial (NCT) Identified Number: <Number, if available>**

**Principal Investigator:** **< Principal investigator>**

**<IND/IDE> Sponsor: <Sponsor name, if applicable>**

*Sponsor means an individual or pharmaceutical or medical device company, governmental agency, academic institution, private organization, or other organization who takes responsibility for and initiates a clinical investigation.*

**Funded by: < NIH Institute or Center (IC)>**

**Version Number: v.<x.x>**

**<Day Month Year>**

*All versions should have a version number and a date. Use the international date format (day month year) and write out the month (e.g., 23 June 2015).*

**Summary of Changes from Previous Version:**

| Affected Section(s) | Summary of Revisions Made | Rationale |
|---------------------|---------------------------|-----------|
| | | |
| | | |

**Table of Contents**

STATEMENT OF COMPLIANCE

1 PROTOCOL SUMMARY

1.1 Synopsis

1.2 Schema

1.3 Schedule of Activities (SoA)

2 INTRODUCTION

2.1 Study Rationale

2.2 Background

2.3 Risk/Benefit Assessment

2.3.1 Known Potential Risks

2.3.2 Known Potential Benefits

2.3.3 Assessment of Potential Risks and Benefits

3 OBJECTIVES AND ENDPOINTS

4 STUDY DESIGN

4.1 Overall Design

4.2 Scientific Rationale for Study Design

4.3 Justification for Dose

4.4 End of Study Definition

5 STUDY POPULATION

5.1 Inclusion Criteria

5.2 Exclusion Criteria

5.3 Lifestyle Considerations

5.4 Screen Failures

5.5 Strategies for Recruitment and Retention

6 STUDY INTERVENTION

6.1 Study Intervention(s) Administration

6.1.1 Study Intervention Description

6.1.2 Dosing and Administration

6.2 Preparation/Handling/Storage/Accountability

6.2.1 Acquisition and accountability

6.2.2 Formulation, Appearance, Packaging, and Labeling

6.2.3 Product Storage and Stability

6.2.4 Preparation

6.3 Measures to Minimize Bias: Randomization and Blinding

6.4 Study Intervention Compliance

6.5 Concomitant Therapy

6.5.1 Rescue Medicine

7 STUDY INTERVENTION DISCONTINUATION AND PARTICIPANT DISCONTINUATION/WITHDRAWAL

7.1 Discontinuation of Study Intervention

7.2 Participant Discontinuation/Withdrawal from the Study

7.3 Lost to Follow-Up

8 STUDY ASSESSMENTS AND PROCEDURES

8.1 Efficacy Assessments

8.2 Safety and Other Assessments

8.3 Adverse Events and Serious Adverse Events

8.3.1 Definition of Adverse Events (AE)

8.3.2 Definition of Serious Adverse Events (SAE)

8.3.3 Classification of an Adverse Event

8.3.4 Time Period and Frequency for Event Assessment and Follow-Up

8.3.5 Adverse Event Reporting

8.3.6 Serious Adverse Event Reporting

8.3.7 Reporting Events to Participants

8.3.8 Events of Special Interest

8.3.9 Reporting of Pregnancy

8.4 Unanticipated Problems

8.4.1 Definition of Unanticipated Problems (UP)

8.4.2 Unanticipated Problem Reporting

8.4.3 Reporting Unanticipated Problems to Participants

9 STATISTICAL CONSIDERATIONS

9.1 Statistical Hypotheses

9.2 Sample Size Determination

9.3 Populations for Analyses

9.4 Statistical Analyses

9.4.1 General Approach

9.4.2 Analysis of the Primary Efficacy Endpoint(s)

9.4.3 Analysis of the Secondary Endpoint(s)

9.4.4 Safety Analyses

9.4.5 Baseline Descriptive Statistics

9.4.6 Planned Interim Analyses

9.4.7 Sub-Group Analyses

9.4.8 Tabulation of Individual participant Data

9.4.9 Exploratory Analyses

10 SUPPORTING DOCUMENTATION AND OPERATIONAL CONSIDERATIONS

10.1 Regulatory, Ethical, and Study Oversight Considerations

10.1.1 Informed Consent Process

10.1.2 Study Discontinuation and Closure

10.1.3 Confidentiality and Privacy

10.1.4 Future Use of Stored Specimens and Data

10.1.5 Key Roles and Study Governance

10.1.6 Safety Oversight

10.1.7 Clinical Monitoring

10.1.8 Quality Assurance and Quality Control

10.1.9 Data Handling and Record Keeping

10.1.10 Protocol Deviations

10.1.11 Publication and Data Sharing Policy

10.1.12 Conflict of Interest Policy

10.2 Additional Considerations

10.3 Abbreviations

10.4 Protocol Amendment History

11 REFERENCES

# STATEMENT OF COMPLIANCE

*Provide a statement that the trial will be conducted in compliance with the protocol, International Conference on Harmonisation Good Clinical Practice (ICH GCP) and applicable state, local and federal regulatory requirements. Each engaged institution must have a current Federal-Wide Assurance (FWA) issued by the Office for Human Research Protections (OHRP) and must provide this protocol and the associated informed consent documents and recruitment materials for review and approval by an appropriate Institutional Review Board (IRB) or Ethics Committee (EC) registered with OHRP. Any amendments to the protocol or consent materials must also be approved before implementation. Select one of the two statements below:*

(1) [The trial will be carried out in accordance with International Conference on Harmonisation Good Clinical Practice (ICH GCP) and the following:

- United States (US) Code of Federal Regulations (CFR) applicable to clinical studies (45 CFR Part 46, 21 CFR Part 50, 21 CFR Part 56, 21 CFR Part 312, and/or 21 CFR Part 812)

National Institutes of Health (NIH)-funded investigators and clinical trial site staff who are responsible for the conduct, management, or oversight of NIH-funded clinical trials have completed Human Subjects Protection and ICH GCP Training.

The protocol, informed consent form(s), recruitment materials, and all participant materials will be submitted to the Institutional Review Board (IRB) for review and approval. Approval of both the protocol and the consent form must be obtained before any participant is enrolled. Any amendment to the protocol will require review and approval by the IRB before the changes are implemented to the study. In addition, all changes to the consent form will be IRB-approved; a determination will be made regarding whether a new consent needs to be obtained from participants who provided consent, using a previously approved consent form.]

*OR*

(2) [The trial will be conducted in accordance with International Conference on Harmonisation Good Clinical Practice (ICH GCP), applicable United States (US) Code of Federal Regulations (CFR), and the <specify NIH Institute or Center (IC) > Terms and Conditions of Award. The Principal Investigator will assure that no deviation from, or changes to the protocol will take place without prior agreement from the Investigational New Drug (IND) or Investigational Device Exemption (IDE) sponsor, funding agency and documented approval from the Institutional Review Board (IRB), except where necessary to eliminate an immediate hazard(s) to the trial participants. All personnel involved in the conduct of this study have completed Human Subjects Protection and ICH GCP Training.

The protocol, informed consent form(s), recruitment materials, and all participant materials will be submitted to the IRB for review and approval. Approval of both the protocol and the consent form must be obtained before any participant is enrolled. Any amendment to the protocol will require review and approval by the IRB before the changes are implemented to the study. All changes to the consent form will be IRB approved; a determination will be made regarding whether a new consent needs to be obtained from participants who provided consent, using a previously approved consent form.]

# 1 PROTOCOL SUMMARY

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

## 1.1 Synopsis

| Field | Description |
|-------|-------------|
| **Title:** | <Full title> |
| **Study Description:** | *Provide a short description of the protocol, including a brief statement of the study hypothesis. This should be only a few sentences in length. A detailed schematic describing all visits and a schedule of assessments should be included in the Schema and Schedule of Activities, Sections 1.2 and 1.3, respectively.* |
| **Objectives:** | *Include the primary and secondary objectives. These objectives should be the same as the objectives contained in the body of the protocol. These align with Primary Purpose in clinicaltrials.gov[^1].* |
| | <Primary Objective: |
| | Secondary Objectives: > |
| **Endpoints:** | *Include the primary endpoint and secondary endpoints. These endpoints should be the same as the endpoints contained in the body of the protocol. These align with Outcome Measures in clinicaltrials.gov.* |
| | <Primary Endpoint: |
| | Secondary Endpoints: > |
| **Study Population:** | *Specify the sample size, gender, age, demographic group, general health status, and geographic location.* |
| **Phase:** | <2 or 3 or N/A> *Phase applies to drugs and biologics[^2].* |
| **Description of Sites/Facilities Enrolling Participants:** | *Provide a brief description of planned facilities/participating sites enrolling participants. Indicate general number (quantity) of sites only and if the study is intended to include sites outside of the United States.* |
| **Description of Study Intervention:** | *Describe the study intervention. If the study intervention is a drug or biologic, include dose and route of administration. For devices, provide a description of each important component, ingredient, property and the principle of operation of the device.* |
| **Study Duration:** | *Estimated time (in months) from when the study opens to enrollment until completion of data analyses.* |
| **Participant Duration:** | *Time (e.g., in months) it will take for each individual participant to complete all participant visits.* |

## 1.2 Schema

*This section should include a diagram that provides a quick "snapshot" of the study and ideally be limited to 1 page. Below are examples of schematics that show the level of detail needed to convey an overview of the study design. Depending on the nature of your study, one example may be more appropriate than another. Regardless, the examples included here are intended to guide the development of a schematic that is appropriate to the planned study design and will need to be customized for the protocol. Revise with study-specific information and adapt the diagram to illustrate your study design (e.g., changing method of assignment to study group, adding study arms, visits, etc.). The time point(s) indicated in the schematic should correspond to the time point(s) in **Section 1.3, Schedule of Activities**, e.g., Visit 1, Day 0; Visit 2, Day 30 ± 7; etc.*

***Example #1 Flow diagram** (e.g., randomized controlled trial)*

Prior to

Enrollment

Randomize

Visit 1

Time Point

Visit 2

Time Point

Visit 3

Time Point

Visit 4

Time Point

**Final Assessments**

<list analyses to be performed OR refer to **Section 1.3, Schedule of Activities**>

Visit X

Time Point

***Example #2*** ***provided as a guide, customize as needed: Process diagram** (e.g., randomized controlled trial)*

***Example #3*** ***provided as a guide, customize as needed: Timeline diagram** (e.g., randomized controlled trial)*

## 1.3 Schedule of Activities (SoA)

***The schedule below is provided as an example and should be modified as appropriate.***

*The schedule of activities must capture the procedures that will be accomplished at each study visit, and all contact, with study participants e.g., telephone contacts. This includes any tests that are used for eligibility, participant randomization or stratification, or decisions on study intervention discontinuation. Only include procedures that contribute to participant eligibility and study objectives and endpoints. Other procedures should be done sparingly and with consideration, as they may add unnecessary complexity and detract from recruitment.*

*Allowable windows should be stated for all visits. To determine the appropriate windows, consider feasibility and relevance of the visit time points to study endpoints (e.g., pharmacokinetic (PK) studies may allow little or no variation, with required time points measured in minutes or hours, whereas a 6-month follow-up visit might have a window of several weeks).*

| Procedures | Screening (Day -7 to -1) | Visit 1 Day 1 | Visit 2 Day 7 ±1 | Visit 3 Day 14 ±1 | Visit 4 Day 21 ±1 | Visit 5 Day 28 ±1 | Visit 6 Day 35 ±1 | Visit 7 Day 42 ±1 | Visit 8 Day 49 ±1 | Visit 9 Day 56 ±1 | Visit 10 Day 63 ±1 | Visit 11 Day 70 ±1 | Visit 12 Day 77 ±1 | Visit 13 Day 84 ±1 (Final) |
|---|:---:|:---:|:---:|:---:|:---:|:---:|:---:|:---:|:---:|:---:|:---:|:---:|:---:|:---:|
| Informed consent | X | | | | | | | | | | | | | |
| Demographics | X | | | | | | | | | | | | | |
| Medical history | X | | | | | | | | | | | | | |
| Randomization | | X | | | | | | | | | | | | |
| Administer study intervention | | X | | | X | | | X | | | X | | | |
| Concomitant medication review | X | X | X | X | X | X | X | X | X | X | X | X | X | X |
| Physical exam (including height and weight) | X | X | | | X | | | X | | | X | | | X |
| Vital signs | X | X | | | X | | | X | | | X | | | X |
| Height | X | | | | | | | | | | | | | |
| Weight | X | X | X | X | X | X | X | X | | | | | | |
| Performance status | X | X | X | X | X | X | X | X | | | | | | |
| Hematology | X | X | X | X | X | X | X | X | X | X | X | X | X | X |
| Serum chemistry^a^ | X | X | X | X | X | X | X | X | X | X | X | X | X | X |
| Pregnancy test^b^ | X | | | | | | | | | | | | | |
| EKG (as indicated) | X | | | | | | | | | | | | | |
| Adverse event review and evaluation | X | X | X | X | X | X | X | X | X | X | X | X | X | X |
| Radiologic/Imaging assessment | X | | | X | | | X | | | | | | | X |
| Other assessments (e.g., immunology assays, pharmacokinetic) | X | X | X | X | X | X | X | X | X | X | X | X | X | X |
| Complete Case Report Forms (CRFs) | X | X | X | X | X | X | X | X | X | X | X | X | X | X |

**Footnotes:**

^a^ Serum chemistry includes: Albumin, alkaline phosphatase, total bilirubin, bicarbonate, BUN, calcium, chloride, creatinine, glucose, LDH, phosphorus, potassium, total protein, AST, ALT, sodium.

^b^ Serum pregnancy test (women of childbearing potential).

<Insert table>

# 2 INTRODUCTION

*No text is to be entered in this section; rather, it should be included under the relevant subheadings below.*

*The following subsections should include relevant background information and rationale for the clinical trial. This should be a brief overview (e.g., approximately 3-7 pages). Referring to the Investigator's Brochure (IB) for more detail is also appropriate.*

## 2.1 Study Rationale

*State the problem or question (e.g., describe the population, disease, current standard of care, if one exists, and limitations of knowledge or available therapy) and the reason for conducting the clinical trial*

<Insert text>

## 2.2 Background

*This section should include:*

- *A summary of findings from nonclinical in vitro or in vivo studies that have potential clinical significance*

- *A summary of relevant clinical research and any history of human use or exposure to the study intervention, including use in other countries, and clinical pharmacology studies*

- *Discussion of important literature and data that are relevant to the trial and that provide background for the trial (reference citations should be listed in **Section 11, References**)*

- *Applicable clinical, epidemiological, or public health background or context of the clinical trial*

- *Importance of the clinical trial and any relevant treatment issues or controversies*

<Insert text>

## 2.3 Risk/Benefit Assessment

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

*The following subsections should include a discussion of known risks and benefits, if any, to human participants.*

### 2.3.1 Known Potential Risks

*Include a discussion of known potential risks from either clinical or nonclinical studies. If a package insert or device labeling from a licensed or approved product is available, it should be used as the primary source of risk information. If the product is investigational, the IB should be the primary source of the risk information. In addition, relevant published literature can also provide relevant risk information. If the risk profile cannot be described from the package insert, device labeling, or the IB, the risk information discussion will result from published literature and should be included and referenced appropriately.*

*Describe any physical, psychological, social, legal, economic, or any other risks to participants by participating in the study that the Principal Investigator (PI) foresees, addressing each of the following:*

- *Immediate risks*

- *Long-range risks*

- *If risk is related to proposed procedures included in the protocol, describe alternative procedures that have been considered and explain why alternative procedures are not included*

<Insert text>

### 2.3.2 Known Potential Benefits

*Include a discussion of known potential benefits from either clinical or nonclinical studies. If a package insert or device labeling from a licensed or approved product is available, it should be used as the primary source of potential benefit information. If the product is investigational, the IB should be the primary source of the potential benefit information. In addition, relevant published literature can also provide potential relevant benefit information. If the potential benefit cannot be described from the package insert, device labeling, or the IB, the potential benefit information discussion will result from published literature and should be included and referenced appropriately.*

*Describe any physical, psychological, social, legal, or any other potential benefits to individual participants or society in general, as a result of participating in the study, addressing each of the following:*

- *Immediate potential benefits*

- *Long-range potential benefits*

*Note that payment to participants, whether as an inducement to participate or as compensation for time and inconvenience, is not considered a "benefit." Provision of incidental care is also not to be considered a benefit.*

<Insert text>

### 2.3.3 Assessment of Potential Risks and Benefits

Include an assessment of known potential risks and benefits, addressing each of the following:

- *Rationale for the necessity of exposing participants to risks and a summary of the ways that risks to participants were minimized in the study design*

- *Justification as to why the risks of participation in the study outweigh the value of the information to be gained*

<Insert text>

# 3 OBJECTIVES AND ENDPOINTS

*For purposes of registration and reporting to ClinicalTrials.gov, the terms Objectives and Endpoints as used in this template align with the terms Primary Purpose and Outcome Measures in ClinicalTrials.gov, respectively. Provide a description of the study objectives and endpoints, as well as a justification for selecting the particular endpoints, in the table format included below*. *This will provide clear articulation of how the selected primary and secondary endpoint(s) are linked to achieving the primary and secondary objectives and an explanation of why endpoint(s) were chosen.* *Data points collected in the study should support an objective or have a regulatory purpose. Therefore, careful consideration should be given prospectively to the amount of data needed to support the study's objectives.*

An objective is the purpose for performing the study in terms of the scientific question to be answered. Express each objective as a statement of purpose (e.g., to assess, to determine, to compare, to evaluate) and include the general purpose (e.g., efficacy, effectiveness, safety) and/or specific purpose (e.g., dose-response, superiority to placebo, effect of an intervention on disease incidence, disease severity, or health behavior).

*A study endpoint is a specific measurement or observation to assess the effect of the study variable (study intervention). Study endpoints should be prioritized and should correspond to the study objectives and hypotheses being tested. Give succinct, but precise definitions of the study endpoints used to address the study's primary objective and secondary objectives (e.g., specific laboratory tests that define safety or efficacy, clinical assessments of disease status, assessments of psychological characteristics, patient reported outcomes, behaviors or health outcomes). Include the study visits or time points at which data will be recorded or samples will be obtained. Describe how endpoint(s) will be adjudicated, if applicable.*

*Primary and secondary endpoints should be adjusted for multiplicity. If a claim is sought for the secondary endpoints, the statistical plan for adjustment for multiplicity should be aligned with those objectives.*


| OBJECTIVES | ENDPOINTS | JUSTIFICATION FOR ENDPOINTS |
|------------|-----------|----------------------------|
| **Primary** | | |
| *The primary objective is the main question. This objective generally drives statistical planning for the trial (e.g., calculation of the sample size to provide the appropriate power for statistical testing).* | *The primary endpoint(s) should be clearly specified and its importance and role in the analysis and interpretation of study results should be defined. The primary endpoint(s) is the basis for concluding that the study met its objective (e.g., "the study wins"). Often Phase 2 and 3 trials include primary objectives, and therefore primary endpoints, to demonstrate effectiveness. Generally, there should be just one primary endpoint that will provide a clinically relevant, valid, and reliable measure of the primary objective. Additional primary endpoints may require an adjustment to the sample size calculations and p-value threshold. However, this is not always the case. For example, in many trials of medical devices there are primary endpoints for both safety and effectiveness.* | *Briefly explain why the endpoint(s) were chosen. In a trial designed to establish efficacy, a primary endpoint should measure a clinically meaningful therapeutic effect or should have demonstrated ability to predict clinical benefit.* |
| **Secondary** | | |
| *The secondary objective(s) are goals that will provide further information on the use of the intervention.* | *Secondary endpoints should be clearly specified and may include, for example, endpoints related to efficacy, safety, or both. Secondary endpoints are those that may provide supportive information about the study intervention's effect on the primary endpoint or demonstrate additional effects on the disease or condition. It is recommended that the list of secondary endpoints be short, because the chance of demonstrating an effect on any secondary endpoint after appropriate correction for multiplicity becomes increasingly small as the number of endpoints increases.* | *Briefly explain why the endpoint(s) were chosen.* |
| **Tertiary/Exploratory** | | |
| *Tertiary/exploratory objective(s) serve as a basis for explaining or supporting findings of primary analyses and for suggesting further hypotheses for later research.* | *Exploratory endpoints should be specified. Exploratory endpoints may include clinically important events that are expected to occur too infrequently to show a treatment effect or endpoints that for other reasons are thought to be less likely to show an effect but are included to explore new hypotheses.* | *Briefly explain why the endpoint(s) were chosen.* |

*Endpoints that are not listed in an alpha conserving plan will be considered exploratory.*


# 4 STUDY DESIGN

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

## 4.1 Overall Design

*The scientific integrity of the trial and the credibility of the data from the trial depend substantially on the trial design. A description of the trial design should be consistent with the **Protocol Synopsis (section 1.1) and Protocol Schema (section 1.2)** and include:*

- *A statement of the hypothesis*

- *Phase of the trial*

- *A description of the type/design of trial to be conducted (e.g., randomized, placebo-controlled, double-blinded, parallel design, open-label, dose escalation, dose-ranging, adaptive, cluster randomized, group sequential, multi-regional, superiority or non-inferiority design)*

- *A description of methods to be used to minimize bias*

- *Dose escalation or dose-ranging details should be contained in **Section 6.1.2, Dosing and Administration***

- *The number of study groups/arms and study intervention duration*

- *Indicate if single site or multi-site*

- *Name of study intervention(s)*

- *Note if interim analysis is planned and refer to details in **Section 9.4.6, Planned Interim Analysis***

- *Note if the study includes any stratifications and if so, identify the stratification planned (e.g. sex, race/ethnicity, age, dose) and refer to details **in Section 9.4.7, Sub-Group Analyses***

- *Name of sub-studies, if any, included in this protocol*

<Insert text>

## 4.2 Scientific Rationale for Study Design

*Describe the rationale for the type and selection of control (e.g. placebo, active drug, dose-response, historical) and study design (e.g., non-inferiority as opposed to superiority). Discuss known or potential problems associated with the control group chosen in light of the specific disease and intervention(s) being studied.*

<Insert text>

## 4.3 Justification for Dose

*Provide a justification for the route of administration, planned maximum dosage, and dosing regimen, including starting dose, of the study intervention(s) and control product(s).*

<Insert text>

## 4.4 End of Study Definition

*A clinical trial is considered completed when participants are no longer being examined or the last participant's last study visit has occurred.*

Example text provided as a guide, customize as needed:

[A participant is considered to have completed the study if he or she has completed all phases of the study including the last visit or the last scheduled procedure shown in the Schedule of Activities (SoA), Section 1.3.

The end of the study is defined as completion of the last visit or procedure shown in the SoA in the trial globally.]

<Insert text>

# 5 STUDY POPULATION

No text is to be entered in this section; rather it should be included under the relevant subheadings below.

The following subsections should include a description of the study population and participant recruitment. The study population should be appropriate for clinical trial phase and the development stage of the study intervention. Given the continuing challenges in achieving clinically relevant demographic inclusion in clinical trials, it is important to focus on clinically relevant potential participants at the earliest stages of protocol development. Therefore, it is essential that the population's characteristics be considered during the trial planning phase to ensure the trial can adequately meet its objectives and provide evidence for the total population that will potentially utilize the study intervention under evaluation (e.g., elderly and pediatric populations, women, and minorities).

Use the following guidelines when developing participant eligibility criteria to be listed in **Sections 5.1 Inclusion Criteria and 5.2 Exclusion Criteria**:

- The eligibility criteria should provide a definition of participant characteristics required for study entry/enrollment.

- If participants require screening, distinguish between screening participants vs enrolling participants. Determine if screening procedures will be performed under a separate screening consent form.

- The risks of the study intervention should be considered in the development of the inclusion/exclusion criteria so that risks are minimized.

- The same criterion should not be listed as both an inclusion and exclusion criterion (e.g., do not state age >18 years old as an inclusion criterion and age ≤18 years old as an exclusion criterion).

- Identify specific laboratory tests or clinical characteristics that will be used as criteria for enrollment or exclusion.

- If reproductive status (e.g., pregnancy, lactation, reproductive potential) is an eligibility criterion, provide specific contraception requirements (e.g., licensed hormonal or barrier methods).

- If you have more than one study population, please define the common inclusion and exclusion criteria followed by the specific inclusion and exclusion criteria for each subpopulation.

## 5.1 Inclusion Criteria

Inclusion criteria are characteristics that define the population under study, e.g., those criteria that every potential participant must satisfy, to qualify for study entry. Provide a statement that individuals must meet all of the inclusion criteria in order to be eligible to participate in the study and then list each criterion. Women and members of minority groups must be included in accordance with the NIH Policy on Inclusion of Women and Minorities as Participants In Research Involving Human Subjects.

Some criteria to consider for inclusion are: provision of appropriate consent and assent, willingness and ability to participate in study procedures, age range, health status, specific clinical diagnosis or symptoms, background medical treatment, laboratory ranges, and use of appropriate contraception. Additional criteria should be included as appropriate for the study design and risk.

Example text provided as a guide, customize as needed:

[In order to be eligible to participate in this study, an individual must meet all of the following criteria:

1.  Provision of signed and dated informed consent form

2.  Stated willingness to comply with all study procedures and availability for the duration of the study

3.  Male or female, aged <specify range>

4.  In good general health as evidenced by medical history or diagnosed with <specify condition/disease> or exhibiting <specify clinical signs or symptoms or physical/oral examination findings>

5.  <Specify laboratory test> results between <specify range>

6.  Ability to take oral medication and be willing to adhere to the <study intervention> regimen

7.  For females of reproductive potential: use of highly effective contraception for at least 1 month prior to screening and agreement to use such a method during study participation and for an additional <specify duration> weeks after the end of <study intervention> administration

8.  For males of reproductive potential: use of condoms or other methods to ensure effective contraception with partner

9.  Agreement to adhere to Lifestyle Considerations (see section 5.3) throughout study duration]

<Insert text>

## 5.2 Exclusion Criteria

Exclusion criteria are characteristics that make an individual ineligible for study participation. Provide a statement that all individuals meeting any of the exclusion criteria at baseline will be excluded from study participation and then list each criterion. If specific populations are excluded (e.g., elderly or pediatric populations, women or minorities), provide a clear and compelling rationale and justification, to establish that inclusion is inappropriate with respect to the health of the participants or the purpose of the research. Limited English proficiency cannot be an exclusion criterion.

Some criteria to consider for exclusion are: pre-existing conditions or concurrent diagnoses, concomitant use of other medication(s) or devices, known allergies, other factors that would cause harm or increased risk to the participant or close contacts, or preclude the participant's full adherence with or completion of the study. Additional criteria should be included as appropriate for the study design and risk.

*Include a statement regarding equitable selection or justification for excluding a specific population.*

Example text provided as a guide, customize as needed (including adding a statement about equitable selection):

[An individual who meets any of the following criteria will be excluded from participation in this study:

1.  Current use of < specify disallowed concomitant medications*>*

2.  Presence of <specific devices (e.g., cardiac pacemaker)>

3.  Pregnancy or lactation

4.  Known allergic reactions to components of the <study intervention>, <specify components/allergens>

5.  Febrile illness within <specify time frame*>*

6.  Treatment with another investigational drug or other intervention within *<*specify time frame*>*

7.  Current smoker or tobacco use within *<*specify timeframe*>*

8.  < Specify any condition(s) or diagnosis, both physical or psychological, or physical exam finding that precludes participation>]

<Insert text>

## 5.3 Lifestyle Considerations

Include content in this section if applicable, otherwise note as not-applicable.

*Describe any restrictions during any parts of the study pertaining to lifestyle and/or diet (e.g., food and drink restrictions, timing of meals relative to dosing, intake of caffeine, alcohol, or tobacco, or limits on activity), and considerations for household contacts. Describe what action will be taken if prohibited medications, treatments or procedures are indicated for care (e.g., early withdrawal).*

*Example text provided as a guide, customize as needed:*

[During this study, participants are asked to:

- Refrain from consumption of red wine, Seville oranges, grapefruit or grapefruit juice, [pomelos, exotic citrus fruits, grapefruit hybrids, or fruit juices] from [X days] before the start of <study intervention> until after the final dose.

<!-- -->

- Abstain from caffeine- or xanthine-containing products (e.g., coffee, tea, cola drinks, and chocolate) for [x hours] before the start of each dosing session until after collection of the final pharmacokinetic (PK) and/or pharmacodynamic sample.

- Abstain from alcohol for 24 hours before the start of each dosing session until after collection of the final PK and/or pharmacodynamic sample.

- Participants who use tobacco products will be instructed that use of nicotine-containing products (including nicotine patches) will not be permitted while they are in the clinical unit.

- Abstain from strenuous exercise for [x hours] before each blood collection for clinical laboratory tests. Participants may participate in light recreational activities during studies (e.g., watching television, reading).

- Minimize interactions with household contacts who may be immunocompromised.]

<Insert text>

## 5.4 Screen Failures

Participants who are consented to participate in the clinical trial, who do not meet one or more criteria required for participation in the trial during the screening procedures, are considered screen failures. Indicate how screen failures will be handled in the trial, including conditions and criteria upon which re-screening is acceptable, when applicable.

Example text provided as a guide, customize as needed:

[Screen failures are defined as participants who consent to participate in the clinical trial but are not subsequently randomly assigned to the study intervention or entered in the study. A minimal set of screen failure information is required to ensure transparent reporting of screen failure participants, to meet the Consolidated Standards of Reporting Trials (CONSORT) publishing requirements and to respond to queries from regulatory authorities. Minimal information includes demography, screen failure details, eligibility criteria, and any serious adverse event (SAE).

Individuals who do not meet the criteria for participation in this trial (screen failure) because of a <specify modifiable factor> may be rescreened. Rescreened participants should be assigned the same participant number as for the initial screening.]

<Insert text>

## 5.5 Strategies for Recruitment and Retention

Identify general strategies for participant recruitment and retention. This section may refer to a separate detailed recruitment and retention plan in the manual of procedures (MOP) and site specific plans could be included in a site-specific standard operating procedure (SOP). Consider inclusion of the information below either in this section or the MOP.

- *Target study sample size by gender, race and ethnicity, and age; identify anticipated number to be screened including women and minorities in order to reach the target enrollment* (should be consistent with information contained in **Section 9.2, Sample Size Determination**)

- Anticipated accrual rate

- Anticipated number of sites and participants to be enrolled from the U.S. and outside the U.S.

- Source of participants *(e.g., inpatient hospital setting, outpatient clinics, student health service, or general public)*

- Recruitment venues

- How potential participants will be identified and approached

- Types of recruitment strategies planned (e.g. patient advocacy groups, national newspaper, local flyers; social media, specific names of where advertisements may be planned are not needed)

<!-- -->

- If the study requires long-term participation, describe procedures that will be used to enhance participant retention (e.g., multiple methods for contacting participants, visit reminders, incentives for visit attendance).

- *Specific strategies that will be used to recruit and retain historically under-represented populations in order to meet target sample size and* conform with the NIH Policy on Inclusion of Women and Minorities as Participants In Research Involving Human Subjects. Include the number of women and minorities expected to be recruited, or provide justification on those rare occasions where women and/or minorities will not be recruited.

  In addition, this section should address:

- If appropriate, include justification for inclusion of vulnerable participants and recruitment strategy. Vulnerable participants include, but are not limited to pregnant women, those who lack consent capacity, including the mentally ill, prisoners, cognitively impaired participants, children, and employee volunteers. Include safeguards for protecting vulnerable populations. Please refer to OHRP guidelines when choosing the study population. Note that these regulations apply if any participants are members of the designated population, even if it is not the target population (e.g., if a participant becomes a prisoner during the study).

- *If participants will be compensated or provided any incentives* (e.g. vouchers, gift cards,) *for study participation, describe amount, form and timing of such compensation in relation to study activities (include financial and non-financial incentives). Describe who will receive incentives (if not the participant). For example, if minors, state whether the minor or the parent/guardian will receive the incentive. If incapacitated adults, state if payment will be provided to the participant or to a legally authorized representative or guardian.*

<Insert text>

# 6 STUDY INTERVENTION

No text is to be entered in this section; rather it should be included under the relevant subheadings below.

*The following subsections should describe the study intervention that is being tested for safety and effectiveness in the clinical trial, and any control product being used in the trial. The study intervention may be a drug (including a biological product), imaging intervention, or device subject to regulation under the Federal Food, Drug, and Cosmetic Act that is intended for administration to humans or use in humans, and that has been or has not yet been approved by the Food and Drug Administration (FDA). This also includes a product with a marketing authorization when used or assembled (formulated or packaged) in a way different from the approved form, when used for an unapproved indication or when used to gain further information about an approved use.*

*If multiple study interventions are to be evaluated in the trial, **Section 6.1*** ***Study Intervention(s) Administration** and **Section 6.2 Preparation/Handling/Storage/Accountability** and their accompanying subsections, should clearly differentiate between each product. Address placebo or control product within each part of **Section 6.1** and **Section 6.2**. If the control product is handled differently than the study intervention, be sure to state how they are each handled, separately. If the control product is handled the same as the study intervention, state as such. **In addition, all sections may not be relevant for the trial. If not relevant, note as not applicable in that section.***

## 6.1 Study Intervention(s) Administration

No text is to be entered in this section; rather it should be included under the relevant subheadings below.

### 6.1.1 Study Intervention Description

*Describe the study intervention(s) and control product. Product information can usually be obtained from the:*

- *IB for an investigational drug or biologic*

- *Package insert for a licensed or approved drug or biologic or device labeling for a licensed device*

- *Proposed labeling and/or material safety data sheet (MSDS) for an investigational device*

- *Final labeling for a marketed device*

*In addition:*

- If a device study is being conducted under an IDE, and is determined to be non-significant risk, such that only abbreviated IDE requirements apply, provide justification here.

- *Indicate if the study intervention is commercially available and is being used in accordance with approved labeling. For a device, note if any modifications have been performed for the study.*

- *If conducting a study with a device, the following information should be included:*

  - *Device size(s)*

  - *Device model(s)*

  - *Description of each component*

  - *Device settings and programming (if applicable)*

  - *Duration of implant or exposure (if applicable)*

  - *Frequency of exposure (if applicable)*

  - *If a device has not been approved or cleared for the indications the protocol is designed to investigate, then a summary/report of test validation studies should accompany this protocol*

<Insert text>

### 6.1.2 Dosing and Administration

*Describe the procedures for selecting each participant's dose of study intervention and control product. For drugs, that includes the timing of dosing (e.g., time of day, interval), the duration (e.g., the length of time study participants will be administered the study intervention), the planned route of administration (e.g., oral, nasal, intramuscular), and the relation of dosing to meals.*

*State the starting dose and schedule of the study intervention and control product, including the maximum and minimum duration for those participants who continue in the study.* *For example, in some oncology trials for participants with no available therapeutic alternatives, intervention continues even after disease progression. In this instance, consider alternative designs that enable participants to rollover to a continued treatment arm and include appropriate instructions to guide this implementation.*

*If applicable, describe the dose escalation scheme and dose regimen (using exact dose, rather than percentages). State any minimum period required before a participant's dose might be raised to the next higher dose or dose range. If applicable, the protocol should state the conditions under which a dose change will be made, particularly in regard to failure to respond or to toxic or untoward changes in stipulated indicators (e.g., white blood cell count in cancer chemotherapy). Address dose modifications for specific abnormal laboratory values of concern or other adverse events (AEs) that are known to be associated with the planned study intervention. The protocol must state explicitly the dose-limiting effects that are anticipated. Provide criteria that will be used to determine dose escalations. If a participant is responding positively to the intervention, the protocol should specify whether study intervention administration would progress to still higher doses. If appropriate, provide a dose de-escalation schema with intervention modifications. Do not restate reasons for withdrawal of participants. Cross-reference relevant sections, as appropriate.*

*Any specific instructions to study participants about when or how to prepare and take the dose(s) should be described, including how delayed or missed doses should be handled. Include any specific instructions or safety precautions for administration of the study intervention. Discuss the maximum hold time once thawed/mixed, if appropriate, before administration.*

*While much of the above section is specific to drugs, similar considerations apply to certain devices. For example, some devices have adjustable settings including those related to energy delivery to participants. Other devices must be sized correctly for individual participants. Similar to the discussion above for dosage of drugs, such considerations should be described for devices, as applicable.*

<Insert text>

## 6.2 Preparation/Handling/Storage/Accountability

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

### 6.2.1 Acquisition and accountability

*State how the study intervention and control product will be provided to the investigator. Describe plans about how and by whom the study intervention will be distributed, including participation of a drug repository or pharmacy, and plans for disposal of expired or return of unused product. Detailed information may be provided in a MOP or a separate SOP.*

<Insert text>

### 6.2.2 Formulation, Appearance, Packaging, and Labeling

*Describe the formulation, appearance, packaging, and labeling of the study intervention and control product, as supplied. Information in this section can usually be obtained from the IB or the package insert, or device labeling. This section should include the name of the manufacturer of the study intervention and control product.*

<Insert text>

### 6.2.3 Product Storage and Stability

*Describe storage and stability requirements (e.g., protection from light, temperature, humidity) for the study intervention and control product. For studies in which multi-dose vials are utilized, provide additional information regarding stability and expiration time after initial use (e.g., the seal is broken).*

<Insert text>

### 6.2.4 Preparation

*Describe the preparation of the study intervention and control product, including any preparation required by study staff and/or study participants. Include thawing, diluting, mixing, and reconstitution/preparation instructions in this section, as appropriate, or within a MOP or SOP. For devices, include any relevant assembly or use instructions.*

<Insert text>

## 6.3 Measures to Minimize Bias: Randomization and Blinding

*This section should contain a description of randomization and blinding procedures (if applicable to the study design). It should include a description or a table that describes how study participants will be assigned to study groups, without being so specific that blinding or randomization might be compromised (e.g., the ratio between intervention and placebo groups may be stated). If adaptive randomization or other methods of covariate balancing/minimization are employed, include a cross link to the methods of analysis in **Section 9, Statistical Considerations**. In addition, details regarding the implementation of procedures to minimize bias should be included in this section. DO NOT include details that might compromise these strategies. Design techniques to avoid bias can be found in the ICH Guidance for Industry E9 Statistical Principles for Clinical Trials.*

*Plans for the maintenance of trial randomization codes and appropriate blinding for the study should be discussed. The timing and procedures for planned and unplanned breaking of randomization codes should be included. Include a statement regarding when unblinding may occur and who may unblind. Provide the criteria for breaking the study blind or participant code. Discuss the circumstances in which the blind would be broken for an individual or for all participants (e.g., for serious adverse evets (SAEs)). Indicate to whom the intentional and unintentional breaking of the blind should be reported.*

*Sometimes blinding is attempted but is known to be imperfect because of obvious effects related to study intervention or control product in some participants (e.g., dry mouth, bradycardia, fever, injection site reactions, and changes in laboratory data). Such problems or potential problems should be identified and, if there are plans to assess the magnitude of the problem or manage it, these should be described (e.g., having endpoint measurements carried out by study staff shielded from information that might reveal study group assignment).*

*If the study allows for some investigators to remain unblinded (e.g., to allow them to adjust medication), the means of shielding other investigators should be explained. Describe efforts to ensure that the study intervention and control/placebo are as indistinguishable as possible. Measures to prevent unblinding by laboratory measurements, if used, should be described.*

*Include a description of your plans to manage and report inadvertent unblinding. If blinding is considered unnecessary to reduce bias for some or all of the observations, this should be explained (e.g., use of a random-zero sphygmomanometer eliminates possible observer bias in reading blood pressure and Holter tapes are often read by automated systems that are presumably immune to observer bias). If blinding is considered desirable but not feasible, the reasons and implications should be discussed.*

<Insert text>

## 6.4 Study Intervention Compliance

*Define how adherence to the protocol (e.g., administration of study intervention, use of device,) will be assessed, and verified (if applicable, e.g., plasma assays, electronic monitoring devices, daily diaries). Include a discussion of what documents are mandatory to complete (e.g., participant drug log) and what source documents/records will be used to calculate study intervention compliance.*

<Insert text>

## 6.5 Concomitant Therapy

Include content in this section if applicable, otherwise note as not-applicable.

*This section should be consistent with the medication restrictions in the inclusion/exclusion criteria previously listed. Describe the data that will be recorded related to permitted concomitant medications, supplements, complementary and alternative therapies, treatments, and/or procedures. Include details about when the information will be collected (e.g., screening, all study visits). Describe how allowed concomitant therapy might affect the outcome (e.g., drug-drug interaction, direct effects on the study endpoints) and how the independent effects of concomitant and study interventions could be ascertained.*

*Example text provided as a guide, customize as needed:*

[For this protocol, a prescription medication is defined as a medication that can be prescribed only by a properly authorized/licensed clinician. Medications to be reported in the Case Report Form (CRF) are concomitant prescription medications, over-the-counter medications and supplements.]

<Insert text>

### 6.5.1 Rescue Medicine

*Include content in this section if applicable, otherwise note as not-applicable.*

*List all medications, treatments, and/or procedures that may be provided during the study for "rescue therapy" and relevant instructions about administration of rescue medications.*

*Example text provided as a guide, customize as needed:*

[The study site <will/will not> supply <specify type> rescue medication that will be <provided by the sponsor/obtained locally>. The following rescue medications may be used <specify name(s)>.

Although the use of rescue medications is allowable <at any time during the study>, the use of rescue medications should be delayed, if possible, for at least <insert timeframe> following the administration of <study intervention>. The date and time of rescue medication administration as well as the name and dosage regimen of the rescue medication must be recorded.]

<Insert text>

# 7 STUDY INTERVENTION DISCONTINUATION AND PARTICIPANT DISCONTINUATION/WITHDRAWAL

No text is to be entered in this section; rather it should be included under the relevant subheadings below.

Participants may withdraw voluntarily from the study or the PI may discontinue a participant from the study. This section should state which adverse events would result in discontinuation of study intervention or participant discontinuation/withdrawal. In addition, participants may discontinue the study intervention, but remain in the study for follow-up, especially for safety and efficacy study endpoints (if applicable). Consider requiring separate documentation for study intervention discontinuation and participant discontinuation/withdrawal from the study. In addition, a dedicated Case Report Form (CRF) page should capture the date and the specific underlying reason for discontinuation of study intervention or participant discontinuation/withdrawal.

## 7.1 Discontinuation of Study Intervention

Describe the criteria for discontinuing the study intervention (e.g., halting rules), including any monitoring test(s) and associated clinical decision point(s). Include reasons for temporary discontinuation of the study intervention (e.g., type and quantity of adverse events), clearly stating the length of time, if applicable, and describe the data to be collected at the time of study intervention discontinuation and approaches for restarting administration of or rechallenging with study intervention.

Describe efforts that will be made to continue follow-up of participants who discontinue the study intervention, but remain in the study for follow-up, especially for safety and efficacy study endpoints (if applicable). Reasonable efforts must be made to undertake protocol-specified safety follow-up procedures to capture adverse events (AE), serious adverse events (SAE), and unanticipated problems (UPs).

Example text provided as a guide, customize as needed:

[Discontinuation from <study intervention> does not mean discontinuation from the study, and remaining study procedures should be completed as indicated by the study protocol. If a clinically significant finding is identified (including, but not limited to changes from baseline) after enrollment, the investigator or qualified designee will determine if any change in participant management is needed. Any new clinically relevant finding will be reported as an adverse event (AE).

The data to be collected at the time of study intervention discontinuation will include the following:

- <Describe the procedures and data to be collected, as well as any follow-up evaluations>]

<Insert text>

## 7.2 Participant Discontinuation/Withdrawal from the Study

Provide a list of reasons participation may be discontinued. It may be appropriate to provide distinct discontinuation criteria for participants and cohorts. If so, both sets of criteria should be listed separately and the distinction between the two must be stated clearly. Also, note that participants may withdraw voluntarily from the study or discontinue the study intervention at any time. But, investigators should seek to minimize participant discontinuation/withdrawal from study except for safety reasons.

In studies of implantable devices, a discussion should be included of any pertinent information that will be provided to withdrawn or discontinued participants (e.g., whether and how the device can be removed, how to replace batteries, how to obtain replacement parts, who to contact). In addition, it is important to capture the reason for withdrawal or discontinuation, as this may impact inclusion of participant data in the analysis of results (see **Section 9, Statistical Analyses**).

This section should include a discussion of replacement of participants who withdraw or discontinue early, if replacement is allowed. This section should not include a discussion of how these participants will be handled in the analysis of study data. This should be captured in the **Section 9, Statistical Analyses.**

Example text provided as a guide, customize as needed:

[Participants are free to withdraw from participation in the study at any time upon request.

An investigator may discontinue or withdraw a participant from the study for the following reasons:

- Pregnancy

- Significant study intervention non-compliance

- If any clinical adverse event (AE), laboratory abnormality, or other medical condition or situation occurs such that continued participation in the study would not be in the best interest of the participant

- Disease progression which requires discontinuation of the study intervention

- If the participant meets an exclusion criterion (either newly developed or not previously recognized) that precludes further study participation

- Participant unable to receive <study intervention> for [x] days/weeks.]

The reason for participant discontinuation or withdrawal from the study will be recorded on the <specify> Case Report Form (CRF). Subjects who sign the informed consent form and are randomized but do not receive the study intervention may be replaced. Subjects who sign the informed consent form, and are randomized and receive the study intervention, and subsequently withdraw, or are withdrawn or discontinued from the study, <will> *or* <will not> be replaced.]

<Insert text>

## 7.3 Lost to Follow-Up

The protocol should describe the nature and duration of study follow-up. Validity of the study is a potential issue when participants are lost to follow-up, as information that is important to the endpoint evaluation is then lost. Participants are considered lost to follow-up when they stop reporting to scheduled study visits and cannot be reached to complete all protocol-required study procedures. Describe the plans to minimize loss to follow-up and missing data.

Example text provided as a guide, customize as needed:

[A participant will be considered lost to follow-up if he or she fails to return for <specify number of visits> scheduled visits and is unable to be contacted by the study site staff.

The following actions must be taken if a participant fails to return to the clinic for a required study visit:

- The site will attempt to contact the participant and reschedule the missed visit <specify time frame> and counsel the participant on the importance of maintaining the assigned visit schedule and ascertain if the participant wishes to and/or should continue in the study.

- Before a participant is deemed lost to follow-up, the investigator or designee will make every effort to regain contact with the participant (where possible, 3 telephone calls and, if necessary, a certified letter to the participant's last known mailing address or local equivalent methods). These contact attempts should be documented in the participant's medical record or study file.

- Should the participant continue to be unreachable, he or she will be considered to have withdrawn from the study with a primary reason of lost to follow-up.]

<Insert text>

# 8 STUDY ASSESSMENTS AND PROCEDURES

No text is to be entered in this section; rather it should be included under the relevant subheadings below.

## 8.1 Efficacy Assessments

*List and describe all study procedures and evaluations to be done as part of the study to support the determination of efficacy, as per the primary and secondary objectives outlined in this protocol. Discuss the sequence of events that should occur during the screening process and any decision points regarding participant eligibility. Include the time frame prior to enrollment within which screening procedures/ evaluations must be performed (e.g., within 28 days prior to enrollment). If a separate screening protocol is developed, describe how the screening protocol will be used to identify participants for this study. In addition, discuss any special conditions that must be achieved during the enrollment and/or initial administration of study intervention. Include the procedures for administering the study intervention and follow-up procedures after administration (e.g., assessment of vital signs), as well as any specifics about subsequent follow-up visits, and unscheduled visits. Also, note if a specifically qualified person (e.g., physician, psychologist) should be performing any of the assessments. Include any definitions used to characterize outcomes (e.g., criteria for determining occurrence of acute myocardial infarction, characterization of a stroke as thrombotic or hemorrhagic, distinction between transient ischemic attack and stroke), should be explained fully.*

*For participants that may discontinue or withdraw early, it is important to capture the rationale during the final visit. See **Section 7, Study Intervention Discontinuation and Participant Discontinuation/Withdrawal**, for details.*

*Note that the protocol should provide a high-level discussion of all procedures and detailed information can be further provided in a MOP or SOP. Provide justification for any sensitive procedures (e.g., provocative testing, deception). In addition, note where approaches to decrease variability, such as centralized laboratory assessments, are being employed. The specific timing of procedures/evaluations to be done at each study visit are captured in **Section 1.3, Schedule of Activities (**SoA) and the time points of these procedures do not need to be included here. In addition, indicate where appropriate, that procedures/evaluations will be performed by qualified personnel.*

*This section may include a list and description of the following procedures/evaluations, as applicable:*

- ***Physical examination** (e.g., height and weight, organ systems, motor or vision assessment, or other functional abilities). If appropriate, discuss what constitutes a targeted physical examination.*

- ***Radiographic or other imaging assessments**. State the specific imaging required and, as appropriate, provide description of what is needed to perform the specialized imaging. Details describing how to perform the imaging in a standard fashion and equipment specifications may be described in the study's MOP or a separate SOP.*

- ***Biological specimen collection and laboratory evaluations**. Include specific test components and estimated volume and type of specimens needed for each test. Specify laboratory methods to provide for appropriate longitudinal and cross-sectional comparison (e.g., use of consistent laboratory method throughout study, use of single, central laboratory for multi-site studies). If more than one laboratory will be used, specify which evaluations will be done by each laboratory. In addition, compliance with Clinical Laboratory Improvement Amendments (CLIA) of 1988 should be addressed. If such compliance is not required, a brief discussion should be included explaining why this is the case. In addition, discussion should include whether any laboratory tests (e.g., diagnostics) that will be used are being developed concurrently or are commercially available. Special instructions for the preparation, handling, storage, and shipment of specimens should be briefly explained in this section with detailed discussion in the study's MOP.*

- ***Special assays or procedures required** (e.g., immunology assays, pharmacokinetic studies, flow cytometry assays, microarray, DNA sequencing). For research laboratory assays, include specific assays, estimated volume and type of specimen needed for each test. If more than one laboratory will be used, specify which assays will be done by each laboratory. Special instructions for the preparation, handling, storage, and shipment of specimens should be briefly explained in this section with detailed discussion in the study's MOP.*

- ***Administration of questionnaires or other instruments** for patient-reported outcomes, such as a daily diary.*

<!-- -->

- ***Procedures that will be completed during the study as part of regular standard of clinical care**.*

*Include in this section a discussion of the results of any study specific procedures that will be provided to participant (e.g., radiographic or other imaging or laboratory evaluations).* *Address when endpoints will be assessed with respect to dosing of rescue medication, if applicable.*

*If an individual's medical chart or results of diagnostic tests performed as part of an individual's regular medical care are going to be used for screening or as a part of collection of trial data, Health Insurance Portability and Accountability Act (HIPAA) rules, other relevant federal or state laws, and local institutional requirements should be followed, as applicable. If this is the case, this section should note which information is to be obtained through review of existing data.*

<Insert text>

## 8.2 Safety and Other Assessments

*List and describe all study procedures and evaluations to be done as part of the study to monitor safety and support the understanding of the study intervention's safety or that are done for other purposes (e.g., screening, eligibility, enrollment).*

*Discuss the sequence of events that should occur during the screening process and any decision points regarding participant eligibility. Include the time frame prior to enrollment within which screening procedures/ evaluations must be performed (e.g., within 28 days prior to enrollment). If a separate screening protocol is developed, describe how the screening protocol will be used to identify participants for this study. In addition, discuss any special conditions that must be achieved during the enrollment and/or initial administration of study intervention.*

*Note that the protocol should provide a high-level discussion of all procedures and detailed information can be further provided in a MOP or SOP. In addition, note where approaches to decrease variability, such as centralized laboratory assessments, are being employed. The specific timing of procedures/evaluations to be done at each study visit are captured in **Section 1.3, Schedule of Activities (SoA)** and the time points of these procedures do not need to be included here.* *In addition, indicate where appropriate, that procedures/evaluations will be performed by qualified personnel.*

*This section may include a list and description of the following procedures/evaluations, as applicable:*

- ***Physical examination** (e.g., height and weight, organ systems, motor or vision assessment, or other functional abilities). If appropriate, discuss what constitutes a targeted physical examination.*

- ***Vital signs** (e.g., temperature, pulse, respirations, blood pressure). Carefully consider which vital signs (if any) should be measured to ensure that only essential data are collected. Include any specific instructions with respect to the collection and interpretation of vital signs.*

- ***Electrocardiograms (EKGs)**: specify if the EKG is for screening purposes only. Include any specific instructions for the collection and interpretation of the EKG (e.g., time points relative to dosing with study intervention or other evaluations). If EKGs will be analyzed at a central laboratory, instructions for the collection (e.g., equipment), transmission and archiving of the EKG data should be summarized in this protocol, and further outlined in the MOP. If the EKG will be read locally, indicate how these will be handled and in what format (e.g., digital or paper), as well as instructions with respect to local review.*

- ***Radiographic or other imaging assessments.** State the specific imaging required and, as appropriate, provide description of what is needed to perform the specialized imaging. Details describing how to perform the imaging in a standard fashion and equipment specifications may be described in the study's MOP or a separate SOP.*

- ***Biological specimen collection and laboratory evaluations**. Include specific test components and estimated volume and type of specimens needed for each test. Specify laboratory methods to provide for appropriate longitudinal and cross-sectional comparison (e.g., use of consistent laboratory method throughout study, use of single, central laboratory for multi-site studies). If more than one laboratory will be used, specify which evaluations will be done by each laboratory. In addition, compliance with Clinical Laboratory Improvement Amendments (CLIA) of 1988 should be addressed. If such compliance is not required, a brief discussion should be included explaining why this is the case. In addition, discussion should include whether any laboratory tests (e.g., diagnostics) that will be used are being developed concurrently or are commercially available. Special instructions for the preparation, handling, storage, and shipment of specimens may be briefly explained in this section; detailed discussion should be included in the study's MOP.*

- ***Special assays or procedures required** (e.g., immunology assays, pharmacokinetic studies, flow cytometry assays, microarray, DNA sequencing). For research laboratory assays, include specific assays, estimated volume and type of specimen needed for each test. If more than one laboratory will be used, specify which assays will be done by each laboratory. Special instructions for the preparation, handling, storage, and shipment of specimens should be briefly explained in this section with detailed discussion in the study's MOP.*

- ***Counseling procedures, including any dietary or activity considerations** that need to be adhered to during study participation.*

- ***Assessment of study intervention adherence** or see Study Intervention Compliance, section 6.4*

- ***Administration of questionnaires or other instruments** for patient-reported outcomes, such as a daily diary.*

- ***Assessment of adverse events.** Describe provisions for follow-up of ongoing AEs/SAEs.*

*Include in this section a discussion of the results of any study specific procedures that will be provided to participant (e.g., radiographic or other imaging or laboratory evaluations).*

*As previously noted, if an individual's medical chart or results of diagnostic tests performed as part of an individual's regular medical care are going to be used for screening or as a part of collection of trial data, Health Insurance Portability and Accountability Act (HIPAA) rules, other relevant federal or state laws, and local institutional requirements should be followed, as applicable. If this is the case, this section should note which information is to be obtained through review of existing data.*

<Insert text>

## 8.3 Adverse Events and Serious Adverse Events

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

*The following subsections are intended to highlight the specific assessments related to safety and the aspects of the study which are proposed to ensure the safety of trial participants. Consider developing this section in consultation with the study Medical Monitor. Consider the risks of the study intervention and other study procedures and the characteristics of the study population (e.g., vulnerable populations such as children). This section should be tailored for specific study characteristics, including but not limited to the following:*

- *The study involves an investigational new drug or investigational device*

- *The study involves washout from current medication regimen*

- *The study involves the use of placebo in a population with a diagnosed disease*

- *The study requires selection of an appropriate toxicity grading scale*

- *The study involves risks to individuals other than research participants (e.g., household or intimate contacts or communities, study clinicians, pharmacists or interventionists, etc.)*

- *Reporting of certain events (e.g., suspected child abuse or substance abuse) is mandatory because of the study population or study design characteristics*

- *The study is conducted at multiple sites, and will require centralized safety oversight*

*In developing this section, consider the risks of the study intervention. Review and reference the applicable sources of information, such as the IB, package insert, device labeling, literature and other sources that describe the study intervention.*

### 8.3.1 Definition of Adverse Events (AE)

*Provide the definition of an AE being used for the clinical trial. The FDA definition of an AE is used in this template since this template is for phase 2 or 3 IND and IDE studies. For some studies, definitions from the OHRP Guidance on Reviewing and Reporting Unanticipated Problems Involving Risks to Subjects or Others and Adverse Events; or ICH GCP definition may be more appropriate. However, it is important to note that FDA regulations require reporting based on the definition included in 21 CFR 312.32 (a) for studies performed under an IND, regardless of the definition of AE used in the protocol.*

*Example text provided as a guide, customize as needed:*

[Adverse event means any untoward medical occurrence associated with the use of an intervention in humans, whether or not considered intervention-related (21 CFR 312.32 (a)).]

<Insert text>

### 8.3.2 Definition of Serious Adverse Events (SAE)

*Provide the definition of an SAE being used for the clinical trial. The FDA definition of an SAE is used in this template since this template is for phase 2 or 3 IND and IDE studies. It is important to note that FDA regulations require reporting based on the definition included in 21 CFR 312.32 (a) for studies performed under an IND, regardless of the definition of SAE used in the protocol. Note that the example text provided is from the drug regulations (21 CFR 312.32 (a)). There is no definition for SAE in the device regulations. Therefore, investigators should develop an appropriate definition for their study. This definition could include an unanticipated adverse device effect, but an SAE is broader than that definition. According to 21 CFR 812.3(s), an "unanticipated adverse device effect means any serious adverse effect on health or safety or any life-threatening problem or death caused by, or associated with, a device, if that effect, problem, or death was not previously identified in nature, severity, or degree of incidence in the investigational plan or application (including a supplementary plan or application), or any other unanticipated serious problem associated with a device that relates to the rights, safety, or welfare of subjects."*

*Example text provided as a guide, customize as needed:*

[An adverse event (AE) or suspected adverse reaction is considered "serious" if, in the view of either the investigator or sponsor, it results in any of the following outcomes: death, a life-threatening adverse event, inpatient hospitalization or prolongation of existing hospitalization, a persistent or significant incapacity or substantial disruption of the ability to conduct normal life functions, or a congenital anomaly/birth defect. Important medical events that may not result in death, be life-threatening, or require hospitalization may be considered serious when, based upon appropriate medical judgment, they may jeopardize the participant and may require medical or surgical intervention to prevent one of the outcomes listed in this definition. Examples of such medical events include allergic bronchospasm requiring intensive treatment in an emergency room or at home, blood dyscrasias or convulsions that do not result in inpatient hospitalization, or the development of drug dependency or drug abuse.]

<Insert text>

### 8.3.3 Classification of an Adverse Event

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

*The following subsections will include a discussion of how AEs will be classified.*

#### 8.3.3.1 Severity of Event

*All AEs will be assessed by the study clinician using a protocol defined grading system. Describe the method of grading an AE for severity. For example, many toxicity tables are available for use and are adaptable to various study designs. Selection of a toxicity table or severity scale should be made in consultation with the study Medical Monitor.*

*Example text provided as a guide, customize as needed:*

[For adverse events (AEs) not included in the protocol defined grading system, the following guidelines will be used to describe severity.

- **Mild** -- Events require minimal or no treatment and do not interfere with the participant's daily activities.

- **Moderate** -- Events result in a low level of inconvenience or concern with the therapeutic measures. Moderate events may cause some interference with functioning.

- **Severe** -- Events interrupt a participant's usual daily activity and may require systemic drug therapy or other treatment. Severe events are usually potentially life-threatening or incapacitating. Of note, the term "severe" does not necessarily equate to "serious".]

<Insert text>

#### 8.3.3.2 Relationship to Study INTERVENTION

*All AEs will have their relationship to study intervention or study participation assessed with a level of specificity appropriate to the study design. The clinician's assessment of an AE's relationship to study intervention (drug, biologic, device) is part of the documentation process, but it is not a factor in determining what is or is not reported in the study. Describe the method of determining the relationship of an AE to a study intervention. If there is any doubt as to whether a clinical observation is an AE, the event should be reported. Some protocols may use a binary assessment (related/not related); others may have a scale of relatedness. Evaluation of relatedness must consider etiologies such as natural history of the underlying disease, concurrent illness, concomitant therapy, study-related procedures, accidents, and other external factors. In a clinical trial, the study intervention must always be suspect.*

*Example text provided as a guide, customize as needed:*

[All adverse events (AEs) must have their relationship to study intervention assessed by the clinician who examines and evaluates the participant based on temporal relationship and his/her clinical judgment. The degree of certainty about causality will be graded using the categories below. In a clinical trial, the study product must always be suspect.

- **Related** -- The AE is known to occur with the study intervention, there is a reasonable possibility that the study intervention caused the AE, or there is a temporal relationship between the study intervention and event. Reasonable possibility means that there is evidence to suggest a causal relationship between the study intervention and the AE.

- **Not Related** -- There is not a reasonable possibility that the administration of the study intervention caused the event, there is no temporal relationship between the study intervention and event onset, or an alternate etiology has been established.

*OR*

- **Definitely Related** -- There is clear evidence to suggest a causal relationship, and other possible contributing factors can be ruled out. The clinical event, including an abnormal laboratory test result, occurs in a plausible time relationship to study intervention administration and cannot be explained by concurrent disease or other drugs or chemicals. The response to withdrawal of the study intervention (dechallenge) should be clinically plausible. The event must be pharmacologically or phenomenologically definitive, with use of a satisfactory rechallenge procedure if necessary.

- **Probably Related** -- There is evidence to suggest a causal relationship, and the influence of other factors is unlikely. The clinical event, including an abnormal laboratory test result, occurs within a reasonable time after administration of the study intervention, is unlikely to be attributed to concurrent disease or other drugs or chemicals, and follows a clinically reasonable response on withdrawal (dechallenge). Rechallenge information is not required to fulfill this definition.

- **Potentially Related** -- There is some evidence to suggest a causal relationship (e.g., the event occurred within a reasonable time after administration of the trial medication). However, other factors may have contributed to the event (e.g., the participant's clinical condition, other concomitant events). Although an AE may rate only as "possibly related" soon after discovery, it can be flagged as requiring more information and later be upgraded to "probably related" or "definitely related", as appropriate.

- **Unlikely to be related** -- A clinical event, including an abnormal laboratory test result, whose temporal relationship to study intervention administration makes a causal relationship improbable (e.g., the event did not occur within a reasonable time after administration of the study intervention) and in which other drugs or chemicals or underlying disease provides plausible explanations (e.g., the participant's clinical condition, other concomitant treatments).

- **Not Related** -- The AE is completely independent of study intervention administration, and/or evidence exists that the event is definitely related to another etiology. There must be an alternative, definitive etiology documented by the clinician.]

<Insert text>

#### 8.3.3.3 Expectedness

*Expected adverse reactions are AEs that are known to occur for the study intervention being studied and should be collected in a standard, systematic format using a grading scale based on functional assessment or magnitude of reaction. Identify the source of the reference safety information used to determine the expectedness of the AE (e.g., IB, approved labeling). Expectedness is assessed based on the awareness of AEs previously observed, not on the basis of what might be anticipated from the properties of the study intervention.*

*An AE or suspected adverse reaction is considered "unexpected" if it is not listed in the IB, package insert, or device labeling or is not listed at the specificity or severity that has been observed; or, if an IB is not required or available, is not consistent with the risk information described in the protocol, as amended. For example, under this definition, hepatic necrosis would be unexpected (by virtue of greater severity) if the IB or package insert referred only to elevated hepatic enzymes or hepatitis. Similarly, cerebral thromboembolism and cerebral vasculitis would be unexpected (by virtue of greater specificity) if the IB or package insert listed only cerebral vascular accidents. "Unexpected," as used in this definition, also refers to AEs or suspected adverse reactions that are mentioned in the IB, package insert, or device labeling as occurring with a class of drugs (or other medical products) or as anticipated from the pharmacological properties or other characteristics of the study intervention, but are not specifically mentioned as occurring with the particular study intervention under investigation.*

*Example text provided as a guide, customize as needed:*

[<Insert role> will be responsible for determining whether an adverse event (AE) is expected or unexpected. An AE will be considered unexpected if the nature, severity, or frequency of the event is not consistent with the risk information previously described for the study intervention.]

<Insert text>

### 8.3.4 Time Period and Frequency for Event Assessment and Follow-Up

*Describe how AEs and SAEs will be identified and followed until resolved or considered stable. Specify procedures for recording and follow-up of AEs and SAEs that are consistent with the information contained within **Section 8.2, Safety and Other Assessments** including what assessment tools will be used to monitor AEs. Include duration of follow-up after appearance of events (e.g., 1 week, 2 months).*

*An unsolicited AE would occur without any prompting or in response to a general question such as "Have you noticed anything different since you started the study; began the study intervention, etc." A solicited AE is one that is specifically solicited such as "Have you noticed any dry mouth since you started the study medication?"*

- *Describe which AEs will be collected as solicited events. Plan the reporting and data collection system to avoid double capture (captured both as an unsolicited and a solicited AE).*

- *Describe how unsolicited events will be captured.*

- *Include time period of collection (e.g., Days 0 -28) and note how long SAEs are collected -- usually collected through entire study.*

*Example text provided as a guide, customize as needed:*

[The occurrence of an adverse event (AE) or serious adverse event (SAE) may come to the attention of study personnel during study visits and interviews of a study participant presenting for medical care, or upon review by a study monitor.

All AEs including local and systemic reactions not meeting the criteria for SAEs will be captured on the appropriate case report form (CRF). Information to be collected includes event description, time of onset, clinician's assessment of severity, relationship to study product (assessed only by those with the training and authority to make a diagnosis), and time of resolution/stabilization of the event. All AEs occurring while on study must be documented appropriately regardless of relationship. All AEs will be followed to adequate resolution.

Any medical condition that is present at the time that the participant is screened will be considered as baseline and not reported as an AE. However, if the study participant's condition deteriorates at any time during the study, it will be recorded as an AE.

Changes in the severity of an AE will be documented to allow an assessment of the duration of the event at each level of severity to be performed. AEs characterized as intermittent require documentation of onset and duration of each episode.

<Insert role or name> will record all reportable events with start dates occurring any time after informed consent is obtained until 7 (for non-serious AEs) or 30 days (for SAEs) after the last day of study participation. At each study visit, the investigator will inquire about the occurrence of AE/SAEs since the last visit. Events will be followed for outcome information until resolution or stabilization.]

<Insert text>

### 8.3.5 Adverse Event Reporting

*This section addresses responsibilities of investigators for reporting of AEs. However, it is important to recognize that sponsors have additional responsibilities under regulations that are not described in this template and should be incorporated into relevant SOPs.*

*Describe the AE reporting procedures, including timeframes. Further details should be included in a MOP or SOP including a description and a flow chart of when events are reported to various oversight (e.g., Data and Safety Monitoring Board (DSMB), safety monitoring committee, independent safety monitor) and regulatory groups, and what study staff are responsible for completing and signing off on the AE reports, and who will receive notification of AEs. According to 21 CFR 312.64(b), "...The investigator must record nonserious adverse events and report them to the sponsor according to the timetable for reporting specified in the protocol".*

*In addition, list any disease-related events (DREs) common in the study population (e.g., expected), which will not be reported per the standard process for reporting, as applicable. Describe how these events will be recorded and monitored.*

<Insert text>

### 8.3.6 Serious Adverse Event Reporting

*This section addresses responsibilities of investigators for reporting of SAEs. However, it is important to recognize that sponsors have additional responsibilities under regulations that are not described in this template and should be incorporated into relevant SOPs.*

*Describe the SAE reporting procedures, including timeframes. Further details should be included in a MOP or SOP including a description and a flow chart of when events are reported to various oversight and regulatory groups, and what study staff are responsible for completing and signing off on the SAE reports, and who will receive notification of SAEs.*

*Generally, any AE considered serious by the PI or Sub-investigator or which meets the definition of an SAE included in **Section 8.3.2, Definition of Serious Adverse Events** must be submitted on an SAE form to the Data Coordinating Center (DCC) if one exists for the study. Studies overseen by a DSMB or other independent oversight body (e.g., safety monitoring committee, independent safety monitor), may be required to submit expedited notification of all SAEs or only SAEs thought to be related to study intervention.*

*According to 21 CFR 312.64(b), "An investigator must immediately report to the sponsor any serious adverse event, whether or not considered drug related, including those listed in the protocol or investigator brochure and must include an assessment of whether there is a reasonable possibility that the drug caused the event. Study endpoints that are serious adverse events (e.g., all-cause mortality) must be reported in accordance with the protocol unless there is evidence suggesting a causal relationship between the drug and the event (e.g., death from anaphylaxis). In that case, the investigator must immediately report the event to the sponsor..."*

*According to 21 CFR 312.32(c)(1), "the sponsor must notify FDA and all participating investigators...in an IND safety report of potential serious risks, from clinical trials or any other source, as soon as possible, but in no case later than 15 calendar days after the sponsor determines that the information qualifies for reporting... In each IND safety report, the sponsor must identify all IND safety reports previously submitted to FDA concerning a similar suspected adverse reaction, and must analyze the significance of the suspected adverse reaction in light of previous, similar reports or any other relevant information. The sponsor must report any suspected adverse reaction that is both serious and unexpected. The sponsor must report an adverse event as a suspected adverse reaction only if there is evidence to suggest a causal relationship between the drug and the adverse event, such as:*

*(A) A single occurrence of an event that is uncommon and known to be strongly associated with drug exposure (e.g., angioedema, hepatic injury, Stevens-Johnson Syndrome);*

*(B) One or more occurrences of an event that is not commonly associated with drug exposure, but is otherwise uncommon in the population exposed to the drug (e.g., tendon rupture);*

*(C) An aggregate analysis of specific events observed in a clinical trial (such as known consequences of the underlying disease or condition under investigation or other events that commonly occur in the study population independent of drug therapy) that indicates those events occur more frequently in the drug treatment group than in a concurrent or historical control group."*

*Furthermore, according to 21 CFR 312.32(c)(2), "the sponsor must also notify FDA of any unexpected fatal or life-threatening suspected adverse reaction as soon as possible but in no case later than 7 calendar days after the sponsor's initial receipt of the information."*

*As noted previously, an unanticipated adverse device effect could be considered an SAE (**Section 8.3.2, Definition of Serious Adverse Events).** For IDE studies, according to 21 CFR 812.150(a)(1), "an investigator shall submit to the sponsor and to the reviewing IRB a report of any unanticipated adverse device effect occurring during an investigation as soon as possible, but in no event later than 10 working days after the investigator first learns of the effect." In addition, according to 21 CFR 812.150(b)(1), "A sponsor who conducts an evaluation of an unanticipated adverse device effect under 812.46(b) shall report the results of such evaluation to FDA and to all reviewing IRB's and participating investigators within 10 working days after the sponsor first receives notice of the effect. Thereafter the sponsor shall submit such additional reports concerning the effect as FDA requests."*

*Example text provided as a guide, customize as needed:*

*Example 1, applicable for a drug or biologic protocol:*

[The study clinician will immediately report to the sponsor any serious adverse event, whether or not considered study intervention related, including those listed in the protocol or investigator brochure and must include an assessment of whether there is a reasonable possibility that the study intervention caused the event. Study endpoints that are serious adverse events (e.g., all-cause mortality) must be reported in accordance with the protocol unless there is evidence suggesting a causal relationship between the study intervention and the event (e.g., death from anaphylaxis). In that case, the investigator must immediately report the event to the sponsor.

All serious adverse events (SAEs) will be followed until satisfactory resolution or until the site investigator deems the event to be chronic or the participant is stable. Other supporting documentation of the event may be requested by the Data Coordinating Center (DCC)/study sponsor and should be provided as soon as possible.

The study sponsor will be responsible for notifying the Food and Drug Administration (FDA) of any unexpected fatal or life-threatening suspected adverse reaction as soon as possible, but in no case later than 7 calendar days after the sponsor's initial receipt of the information. In addition, the sponsor must notify FDA and all participating investigators in an Investigational New Drug (IND) safety report of potential serious risks, from clinical trials or any other source, as soon as possible, but in no case later than 15 calendar days after the sponsor determines that the information qualifies for reporting.]

*OR*

*Example 2, applicable for device protocol:*

[The study investigator shall complete an Unanticipated Adverse Device Effect Form and submit to the study sponsor and to the reviewing Institutional Review Board (IRB) as soon as possible, but in no event later than 10 working days after the investigator first learns of the effect. The study sponsor is responsible for conducting an evaluation of an unanticipated adverse device effect and shall report the results of such evaluation to the Food and Drug Administration (FDA) and to all reviewing IRBs and participating investigators within 10 working days after the sponsor first receives notice of the effect. Thereafter, the sponsor shall submit such additional reports concerning the effect as FDA requests.]

<Insert text>

### 8.3.7 Reporting Events to Participants

*Include content in this section if applicable, otherwise note as not-applicable.*

*Describe how participants will be informed about AEs and SAEs, and study-related results on an individual or aggregate level. In addition, describe plans for detecting and managing incidental findings associated with study procedures.*

<Insert text>

### 8.3.8 Events of Special Interest

*Include content in this section if applicable, otherwise note as not-applicable.*

*Describe any other events that merit reporting to the sponsor, study leadership, IRB, and regulatory agencies. For example, in oncology trials, secondary malignancies are often captured.*

*Include any other reportable events not already included in the previous sections, such as cardiovascular and death events, medical device incidents (including malfunctions), laboratory test abnormalities, and study intervention overdose.*

<Insert text>

### 8.3.9 Reporting of Pregnancy

*Include content in this section if applicable, otherwise note as not-applicable. Pregnancy is not an adverse event, but some studies will require unique considerations if pregnancy was to occur during the study.*

*State the study's pregnancy-related policy and procedure. Include appropriate mechanisms for reporting to the DCC or NIH, the IND or IDE sponsor, study leadership, IRB, and regulatory agencies. Provide appropriate modifications to study procedures (e.g., discontinuation of study intervention, while continuing safety follow-up, requesting permission to follow pregnant women to pregnancy outcome).*

<Insert text>

## 8.4 Unanticipated Problems

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

### 8.4.1 Definition of Unanticipated Problems (UP)

*The reporting of UPs applies to non-exempt human subjects research conducted or supported by HHS. Provide the definition of an UP being used for this clinical trial. An incident, experience, or outcome that meets the definition of an UP generally will warrant consideration of changes to the protocol or consent in order to protect the safety, welfare, or rights of participants or others. Other UPs may warrant corrective actions at a specific study site. Examples of corrective actions or changes that might need to be considered in response to an UP include:*

- *Modification of inclusion or exclusion criteria to mitigate the newly identified risks*

- *Implementation of additional safety monitoring procedures*

- *Suspension of enrollment of new participants or halting of study procedures for enrolled participants*

- *Modification of informed consent documents to include a description of newly recognized risks*

- *Provision of additional information about newly recognized risks to previously enrolled participants*.

*Example text provided as a guide, customize as needed:*

[The Office for Human Research Protections (OHRP) considers unanticipated problems involving risks to participants or others to include, in general, any incident, experience, or outcome that meets **[all]{.underline}** of the following criteria:

- Unexpected in terms of nature, severity, or frequency given (a) the research procedures that are described in the protocol-related documents, such as the Institutional Review Board (IRB)-approved research protocol and informed consent document; and (b) the characteristics of the participant population being studied;

- Related or possibly related to participation in the research ("possibly related" means there is a reasonable possibility that the incident, experience, or outcome may have been caused by the procedures involved in the research); and

- Suggests that the research places participants or others at a greater risk of harm (including physical, psychological, economic, or social harm) than was previously known or recognized.

*Additional example text, applicable for device protocols:*

[This definition could include an unanticipated adverse device effect, any serious adverse effect on health or safety or any life-threatening problem or death caused by, or associated with, a device, if that effect, problem, or death was not previously identified in nature, severity, or degree of incidence in the investigational plan or application (including a supplementary plan or application), or any other unanticipated serious problem associated with a device that relates to the rights, safety, or welfare of subjects (21 CFR 812.3(s)).]

<Insert text>

### 8.4.2 Unanticipated Problem Reporting

*This section addresses responsibilities of investigators for reporting of UPs. Describe the UP reporting procedures, including timeframes. Further details should be included in a MOP or SOP including a description and a flow chart of when events are reported to various oversight (e.g., DSMB, safety monitoring committee, independent safety monitor) and regulatory groups, and what study staff are responsible for completing and signing off on the UP report forms.*

*Institutions engaged in human subjects research conducted or supported by Department of Health and Human Services (DHHS) must have written procedures for ensuring prompt reporting to the IRB, appropriate institutional officials, and any supporting department or agency head of any unanticipated problem involving risks to subjects or others (45 CFR 46.103(b)(5)). Furthermore, for research covered by an assurance approved for federal wide use by OHRP, DHHS regulations at 45 CFR 46.103(a) require that institutions promptly report any unanticipated problems to OHRP.*

*Example text provided as a guide, customize as needed:*

[The investigator will report unanticipated problems (UPs) to the reviewing Institutional Review Board (IRB) and to the Data Coordinating Center (DCC)/lead principal investigator (PI). The UP report will include the following information:

- Protocol identifying information: protocol title and number, PI's name, and the IRB project number;

- A detailed description of the event, incident, experience, or outcome;

- An explanation of the basis for determining that the event, incident, experience, or outcome represents an UP;

- A description of any changes to the protocol or other corrective actions that have been taken or are proposed in response to the UP.

To satisfy the requirement for prompt reporting, UPs will be reported using the following timeline:

- UPs that are serious adverse events (SAEs) will be reported to the IRB and to the DCC/study sponsor within <insert timeline in accordance with policy> of the investigator becoming aware of the event.

- Any other UP will be reported to the IRB and to the DCC/study sponsor within <insert timeline in accordance with policy> of the investigator becoming aware of the problem.

- All UPs should be reported to appropriate institutional officials (as required by an institution's written reporting procedures), the supporting agency head (or designee), and the Office for Human Research Protections (OHRP) within <insert timeline in accordance with policy> of the IRB's receipt of the report of the problem from the investigator.]

*Additional example text, applicable for device protocol:*

[An investigator shall submit to the sponsor and to the reviewing Institutional Review Board (IRB) a report of any unanticipated adverse device effect occurring during an investigation as soon as possible, but in no event later than 10 working days after the investigator first learns of the effect (21 CFR 812.150(a)(1)), A sponsor who conducts an evaluation of an unanticipated adverse device effect under 812.46(b) shall report the results of such evaluation to the Food and Drug Administration (FDA) and to all reviewing IRB's and participating investigators within 10 working days after the sponsor first receives notice of the effect. Thereafter the sponsor shall submit such additional reports concerning the effect as FDA requests (21 CFR 812.150(b)(1)).

<Insert text>

### 8.4.3 Reporting Unanticipated Problems to Participants

*Include content in this section if applicable, otherwise note as not-applicable.*

*Describe how participants will be informed about UPs on an individual or aggregate level.*

<Insert text>

# 9 STATISTICAL CONSIDERATIONS

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

*The following subsections should describe the statistical tests and analysis plans for the protocol. They should indicate how the study will answer the most important questions with precision and a minimum of bias, while remaining feasible. Many elements below can be found in ICH Guidance for Industry E9 Statistical Principles for Clinical Trials and the CONSORT statement which describes standards for improving the quality of reporting randomized controlled trials.*

*State whether there will be a formal Statistical Analysis Plan (SAP). A formal SAP should be completed prior to database lock and unblinding of the study data. The SAP generally includes additional statistical analysis detail (e.g., more detail of analysis populations, summary of statistical strategies). If a separate SAP will be developed, subsections below can be summarized.*

## 9.1 Statistical Hypotheses

*State the formal and testable null and alternative hypotheses for primary and key secondary endpoints, specifying the type of comparison (e.g., superiority, equivalence or non-inferiority, dose response) and time period for which each endpoint will be analyzed.*

- Primary Efficacy Endpoint(s):

<Insert text>

- Secondary Efficacy Endpoint(s):

<Insert text>

## 9.2 Sample Size Determination

*Include number of participants to recruit, screen, and enroll to have adequate power to test the key hypotheses for the study. Provide all information needed to validate your calculations and judge the feasibility of enrolling and following the necessary number of participants. In particular, specify all of the following:*

- *Outcome measure used for calculations (almost always the primary variable)*

- *Test statistic*

- *Null and alternative hypotheses*

- *Type I error rate (alpha)*

- *Power level (e.g., 80% power)*

<!-- -->

- *Assumed event rate for dichotomous outcome (or mean and variance of continuous outcome) for each study arm, justified and referenced by historical data as much as possible*

- *Statistical method used to calculate the sample size, with a reference for it and for any software utilized*

- *Anticipated impact of dropout rates, withdrawal, cross-over to other study arms, missing data, etc. on study power (see also **9.4.2 Analysis of the Primary Efficacy Endpoint(s) and 9.4.3 Analysis of the Secondary Endpoint(s)**)*

- *Method for adjusting calculations for planned interim analyses, if any (**Section 9.4.6, Planned Interim Analyses**).*

*Further, present calculations from a suitable range of assumptions to gauge the robustness of the proposed sample size.*

*Discuss whether the sample size provides sufficient power for addressing secondary endpoints or exploratory analyses (e.g., subgroup analyses or moderator analyses involving an interaction term, **Section 9.4.9, Exploratory Analyses**).*

<Insert text>

## 9.3 Populations for Analyses

*Clearly identify and describe the analysis datasets (e.g., which participants will be included in each). As a guide, this may include, but is not limited to, any or all of the following:*

- *Intention-to-Treat (ITT) Analysis Dataset (i.e., all randomized participants)*

- *Modified Intention-to-Treat Analysis Dataset (e.g., participants who took at least one dose of study intervention and/or have some particular amount of follow-up outcome data)*

- *Safety Analysis Dataset: defines the subset of participants for whom safety analyses will be conducted (e.g., participants who took at least one dose of study intervention)*

- *Per-Protocol Analysis Dataset: defines a subset of the participants in the full analysis (ITT) set who complied with the protocol sufficiently to ensure that these data would be likely to represent the effects of study intervention according to the underlying scientific model (e.g., participants who took at least 80% of study intervention for 80% of the days within the maintenance period)*

- *Other Datasets that may be used for sensitivity analyses*

<Insert text>

## 9.4 Statistical Analyses

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

*The following subsections should include a description of the planned statistical methods.*

### 9.4.1 General Approach

*As a guide, the following should be addressed, as appropriate:*

- *For descriptive statistics, describe how categorical and continuous data will be presented (e.g., percentages, means with standard deviations, median, range).*

- *For inferential tests, indicate the p-value and confidence intervals for statistical significance (Type I error) and whether one or two-tailed.*

- *Indicate whether covariates will be pre-specified in the sections below or later in a SAP.*

- *State whether checks of assumptions (e.g., normality) underlying statistical procedures will be performed and whether any corrective procedures will be applied (e.g., transformation or nonparametric tests).*

<Insert text>

### 9.4.2 Analysis of the Primary Efficacy Endpoint(s)

*For each primary endpoint:*

- *Define the measurement or observation and describe how it is calculated, if not readily apparent*

- *Describe the scale (nominal/binary/categorical, ordinal, interval); state if it is measured as a single endpoint/summary measure or repeated measure*

- *Describe the statistical procedure(s) that will be used to analyze the primary endpoint (e.g., multiple regression, repeated measures mixed models, logistic regression, Analysis of Covariance (ANCOVA)). Describe the covariates and factors in the model. Provide your rationale for covariates and how they will be selected to achieve a parsimonious model. If the decision to specify covariates is deferred for the SAP, indicate here.*

- *Describe how results of statistical procedure(s) will be presented (e.g., adjusted means (Least-squares means (LSMEANS)) with standard errors, odds ratios with 95% confidence intervals, prevalence rates, number-needed-to-treat)*

- *Describe details to check assumptions required for certain types of analyses (e.g., proportional hazards, transformations or, when appropriate, nonparametric tests)*

- *Describe the Populations for which the analysis will be conducted, as discussed in **Section 9.3, Populations for Analyses***

- *Describe how missing data will be handled (e.g., type of imputation technique, if any, and provide justification), and approach to handling outliers, nonadherence and lost to follow-up*

- *If there is more than one primary endpoint or more than one analysis of a particular endpoint, state the statistical adjustment used for Type I error criteria or give reasons why it was considered unnecessary.*

*Note if more than one endpoint: the statistical approach for endpoints with the same analytic issues can be described as a group.*

<Insert text>

### 9.4.3 Analysis of the Secondary Endpoint(s)

*For each secondary endpoint:*

- *Note if analysis of secondary endpoint(s) are dependent on findings of primary endpoint*

- *Define the measurement or observation and describe how it is calculated, if not readily apparent*

- *Describe the scale (nominal/binary/categorical, ordinal, and interval); state if it is measured as a single endpoint/summary measure or repeated measure.*

- *Describe the statistical procedure(s) that will be used to analyze the secondary endpoint (e.g., multiple regression, repeated measures mixed models, logistic regression, ANCOVA). Describe the covariates and factors in the model. Provide rationale for covariates and how they will be selected to achieve a parsimonious model. If decision to specify covariates is deferred for the SAP, indicate here.*

- *Describe how results of statistical procedure(s) will be presented (e.g., adjusted means (LSMEANS) with standard errors, odds ratios with 95% confidence intervals, prevalence rates, and number-needed-to-treat).*

- *Describe details to check assumptions required for certain types of analyses (e.g., proportional hazards, transformations or, when appropriate, nonparametric tests).*

- *Describe the Populations for which the analysis will be conducted as discussed in **Section 9.3, Populations for Analyses.***

- *Describe how missing data will be handled (e.g., type of imputation technique, if any, and provide justification), and approach to handling outliers, nonadherence and lost to follow-up.*

- *If there is more than one primary endpoint or more than one analysis of a particular endpoint, state the statistical adjustment used for Type I error criteria or give reasons why it was considered unnecessary.*

*Note if more than one endpoint: the statistical approach for endpoints with the same analytic issues can be described as a group.*

<Insert text>

### 9.4.4 Safety Analyses

*Describe how safety endpoints will be analyzed (e.g., as summary statistics during treatment and/or as change scores from baselines such as shift tables). If your study is evaluating a formal safety endpoint, all of the factors to be included in **Section 9.4.2, Analysis of the Primary Efficacy Endpoint(s)** should be included here. Describe how AEs will be coded (e.g., Medical Dictionary for Regulatory Activities (MedDRA)), calculated (e.g., each AE will be counted once only for a given participant), presented (e.g., severity, frequency, and relationship of AEs to study intervention will be presented by System Organ Class (SOC) and preferred term groupings) and what information will be reported about each AE (e.g., start date, stop date, severity, relationship, expectedness, outcome, and duration). Adverse events leading to premature discontinuation from the study intervention and serious treatment-emergent AEs should be presented either in a table or a listing. The information included here should be consistent with the information contained within **Section 8.2, Safety and Other Assessments**.*

<Insert text>

### 9.4.5 Baseline Descriptive Statistics

*Include content in this section if applicable, otherwise note as not-applicable.*

*Intervention groups should be compared on baseline characteristics, including demographics and laboratory measurements, using descriptive statistics. Discuss planned baseline descriptive statistics, indicate whether inferential statistics will be used.*

<Insert text>

### 9.4.6 Planned Interim Analyses

*Include content in this section if applicable, otherwise note as not-applicable.*

*This section should describe the types of statistical interim analyses and halting guidelines (if any) that are proposed, including their timing and who reviews the interim analyses. In addition, if the interim analyses could result in an adjusted sample size, discuss the statistical algorithm to be used when evaluating results. Pre-specify, to the extent possible, the criteria that would prompt an interim review of safety and efficacy data and trial futility. Describe who performs the statistical analysis and who reviews the analysis. In addition, discuss whether they are unblinded and how the blinding will be preserved.*

*If statistical rules will be used to halt enrollment into all or a portion of the study (e.g., for safety or futility), describe the statistical techniques and their operating characteristics. If formal interim analyses will be performed, provide unambiguous and complete instructions so that an independent statistician could perform the analyses.*

*Describe safety findings that would prompt temporary suspension of enrollment and/or study intervention use until a safety review is convened (either routine or ad hoc). Provide details of the proposed rules for halting study enrollment or study intervention/administration of study product for safety, including whether they pertain to the entire study, specific study arms or participant subgroups, or other components of the study.*

*State how endpoints will be monitored, the frequency of monitoring, and the specific definitions of proposed halting guidelines. Examples of findings that might trigger a safety review are the number of SAEs overall, the number of occurrences of a particular type of SAE, severe AEs/reactions, or increased frequency of events.*

*Also, discuss the impact of the interim analysis (if being done) on the final efficacy analyses, particularly on Type I error.*

*This section should be consistent with **Section 7, Study Intervention Discontinuation and Participant Discontinuation/Withdrawal.***

<Insert text>

### 9.4.7 Sub-Group Analyses

*Describe how the primary endpoint will be analyzed based on age, sex, race/ethnicity or other demographic characteristic(s) or provide justification for why such analyses are not warranted (e.g., study intervention only for use in men or children).*

*Describe how the secondary endpoint(s) will be analyzed based on age, sex, race/ethnicity or other demographic characteristic(s) or provide justification for why such analyses are not warranted (e.g., study intervention only for use in men or children).*

<Insert text>

### 9.4.8 Tabulation of Individual participant Data

*State whether individual participant data will be listed by measure and time point.*

<Insert text>

### 9.4.9 Exploratory Analyses

*Exploratory analyses cannot be used as confirmatory proof for registration trials. All planned exploratory analyses should be specified in the protocol.*

<Insert text>

# 10 SUPPORTING DOCUMENTATION AND OPERATIONAL CONSIDERATIONS

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

## 10.1 Regulatory, Ethical, and Study Oversight Considerations

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

*The following subsections should include a description of the regulatory and ethical considerations, and context for the conduct of the trial. Of note, the guiding ethical principles being followed by this study are included in the **Statement of Compliance** at the beginning of this protocol. For NIH Intramural Research Program studies only: A statement referencing compliance with NIH Human Research Protections Program policies and procedures is adequate for **Subsection 10.1.1, Informed Consent Process.***

### 10.1.1 Informed Consent Process

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

*The following subsections should describe the procedures for obtaining and documenting informed consent of study participants. State if a separate screening consent will be used. If a separate screening consent will not be used, the study consent must be signed prior to conducting study screening procedures.*

*In obtaining and documenting informed consent, the investigator must comply with applicable regulatory requirements (e.g., 45 CFR Part 46, 21 CFR Part 50, 21 CFR Part 56) and should adhere to ICH GCP. Prior to the beginning of the trial, the investigator should have the IRB's written approval for the protocol and the written informed consent form(s) and any other written information to be provided to the participants.*

#### 10.1.1.1 Consent/assent and Other Informational Documents Provided to participants

*This section should demonstrate that the consent form contains all required regulatory elements.* *List all consent and/or assent documents and materials submitted with this protocol. Include consent and/or assent forms, printed or web-based materials, phone scripts and any other related material.*

*If needed, describe special documents or materials (e.g., Braille, another language, audio recording)*

*Example text* *provided as a guide, customize as needed:*

[Consent forms describing in detail the study intervention, study procedures, and risks are given to the participant and written documentation of informed consent is required prior to starting intervention/administering study intervention. The following consent materials are submitted with this protocol <insert list>.]

<Insert text>

#### 10.1.1.2 Consent Procedures and Documentation

*Describe how informed consent will be administered. Describe any proposed waivers or alterations to informed consent. Describe any special circumstances regarding obtaining consent. Describe plans for obtaining consent from speakers of language other than English. Describe procedures for obtaining surrogate consent for those unable to consent on their own behalf. This section should be consistent with **Section 5.5, Strategies for Recruitment and Retention** when describing consent plans and special considerations for children or other vulnerable participants. Address re-consent processes for children who become adults or emancipated during a study.*

*Example text provided as a guide, customize as needed:*

[Informed consent is a process that is initiated prior to the individual's agreeing to participate in the study and continues throughout the individual's study participation. Consent forms will be Institutional Review Board (IRB)-approved and the participant will be asked to read and review the document. The investigator will explain the research study to the participant and answer any questions that may arise. A verbal explanation will be provided in terms suited to the participant's comprehension of the purposes, procedures, and potential risks of the study and of their rights as research participants. Participants will have the opportunity to carefully review the written consent form and ask questions prior to signing. The participants should have the opportunity to discuss the study with their family or surrogates or think about it prior to agreeing to participate. The participant will sign the informed consent document prior to any procedures being done specifically for the study. Participants must be informed that participation is voluntary and that they may withdraw from the study at any time, without prejudice. A copy of the informed consent document will be given to the participants for their records. The informed consent process will be conducted and documented in the source document (including the date), and the form signed, before the participant undergoes any study-specific procedures. The rights and welfare of the participants will be protected by emphasizing to them that the quality of their medical care will not be adversely affected if they decline to participate in this study.]

<Insert text>

### 10.1.2 Study Discontinuation and Closure

*List possible reasons for termination or temporary suspension of the study (e.g., study closure based on PI decision, sponsor/funder decision, regulatory or other oversight bodies; review of serious, unexpected, and related AEs; noncompliance; futility). For any study that is prematurely terminated or temporarily suspended, the PI will promptly inform study participants, the IRB, and sponsor and provide the reason(s) for the termination or temporary suspension.*

*When a study is prematurely terminated, refer to Section **7, Study Intervention Discontinuation and Participant Discontinuation/Withdrawal**, for handling of enrolled study participants.*

*Example text provided as a guide, customize as needed:*

[This study may be temporarily suspended or prematurely terminated if there is sufficient reasonable cause. Written notification, documenting the reason for study suspension or termination, will be provided by the suspending or terminating party to <study participants, investigator, funding agency, the Investigational New Drug (IND) or Investigational Device Exemption (IDE) sponsor and regulatory authorities>. If the study is prematurely terminated or suspended, the Principal Investigator (PI) will promptly inform study participants, the Institutional Review Board (IRB), and sponsor and will provide the reason(s) for the termination or suspension. Study participants will be contacted, as applicable, and be informed of changes to study visit schedule.

Circumstances that may warrant termination or suspension include, but are not limited to:

- Determination of unexpected, significant, or unacceptable risk to participants

- Demonstration of efficacy that would warrant stopping

- Insufficient compliance to protocol requirements

- Data that are not sufficiently complete and/or evaluable

- Determination that the primary endpoint has been met

- Determination of futility

Study may resume once concerns about safety, protocol compliance, and data quality are addressed, and satisfy the sponsor, IRB and/or Food and Drug Administration (FDA).]

<Insert text>

### 10.1.3 Confidentiality and Privacy

*This section will describe protections for maintaining confidentiality of participant data, including, but not limited to forms, records and samples and participant privacy.*

*Include procedures for maintaining participant confidentiality, privacy protections, any special data security requirements, and record retention per the sponsor's requirements. Describe who would have access to records, including the investigator and other study staff, the clinical monitor, funding institutions, representatives of the NIH Institute or Center (IC), IND/IDE sponsor, representatives from the IRB, regulatory agencies, and representatives of the pharmaceutical company supplying product to be tested. In addition, consider inclusion of the following information:*

- Describe whether identifiers will be attached to data/samples, or whether data will be coded or unlinked.

- If unlinked or coded, and additional information (e.g., age, ethnicity, sex, diagnosis) is available, discuss whether this might make specific individuals or families identifiable.

- If research data/samples will be coded, describe how access to the "key" for the code will be limited. Include description of security measures (password-protected database, locked drawer, other). List names or positions of persons with access to the key.

- *Include a discussion of the circumstances in which data or samples will be shared with other researchers.*

- *Include a discussion of plans to publish participant's family pedigrees, with a description of measures to minimize the chance of identifying specific families.*

- *Describe any situations in which personally identifiable information will be released to third parties.*

- *State who has access to records, data, and samples. Consider if monitors or auditors outside of study investigators will need access.*

- *Discuss any additional features to protect confidentiality (e.g., use of a certificate of confidentiality).*

- *Approaches to ensure privacy of study participants*

*For some studies, a Certificate of Confidentiality (CoC) may be necessary. A CoC provides protection to researchers and research institutions from being forced to provide identifying information on study participants to any federal, state or local authority. Authorization comes from NIH through section 301 (d) of the Public Health Service Act (42 U.S.C. 241 (d)) which provides the Secretary of Health and Human Services the authority to protect the privacy of study participants. Refer to the NIH Certificate of Confidentiality Kiosk, for more details.*

*Example text provided as a guide, customization will be required to address all aspects that should be included in this section:*

[Participant confidentiality and privacy is strictly held in trust by the participating investigators, their staff, and the sponsor(s) and their interventions. This confidentiality is extended to cover testing of biological samples and genetic tests in addition to the clinical information relating to participants. Therefore, the study protocol, documentation, data, and all other information generated will be held in strict confidence. No information concerning the study or the data will be released to any unauthorized third party without prior written approval of the sponsor.

All research activities will be conducted in as private a setting as possible.

The study monitor, other authorized representatives of the sponsor, representatives of the Institutional Review Board (IRB), regulatory agencies or pharmaceutical company supplying study product may inspect all documents and records required to be maintained by the investigator, including but not limited to, medical records (office, clinic, or hospital) and pharmacy records for the participants in this study. The clinical study site will permit access to such records.

The study participant's contact information will be securely stored at each clinical site for internal use during the study. At the end of the study, all records will continue to be kept in a secure location for as long a period as dictated by the reviewing IRB, Institutional policies, or sponsor requirements.

Study participant research data, which is for purposes of statistical analysis and scientific reporting, will be transmitted to and stored at the <specify name of Data Coordinating Center>. This will not include the participant's contact or identifying information. Rather, individual participants and their research data will be identified by a unique study identification number. The study data entry and study management systems used by clinical sites and by <specify name of Data Coordinating Center> research staff will be secured and password protected. At the end of the study, all study databases will be de-identified and archived at the <specify name of Data Coordinating Center>.

Certificate of Confidentiality (if applicable)

To further protect the privacy of study participants, a Certificate of Confidentiality will be issued by the National Institutes of Health (NIH). This certificate protects identifiable research information from forced disclosure. It allows the investigator and others who have access to research records to refuse to disclose identifying information on research participation in any civil, criminal, administrative, legislative, or other proceeding, whether at the federal, state, or local level. By protecting researchers and institutions from being compelled to disclose information that would identify research participants, Certificates of Confidentiality help achieve the research objectives and promote participation in studies by helping assure confidentiality and privacy to participants.]

<Insert text>

### 10.1.4 Future Use of Stored Specimens and Data

*If intended specimens or residual specimens are retained after the study is complete, include the provisions for consent and the options that are available for the participant to agree to the future use of his/her specimens, images, audio or video recordings. Specify the location(s), if other than the clinical site, where specimens or other data will be maintained, how long specimens or other data will be stored, if the site's IRB will review future studies, and protections of confidentiality for any future studies with the stored specimens or data (e.g., specimens will be coded, bar-coded, de-identified, identifying information will be redacted from audio recording transcripts). Include a statement that genetic testing will or will not be performed.*

*See also **Section 10.1.3, Confidentiality** **and Privacy** and **Section 10.1.9, Data Handling and Record Keeping**, for further information on future use of study records.*

*Example text provided as a guide, customize as needed:*

[Data collected for this study will be analyzed and stored at the <specify name of Data Coordinating Center >. After the study is completed, the de-identified, archived data will be transmitted to and stored at the <specify name of Data Repository>, for use by other researchers including those outside of the study. Permission to transmit data to the <specify name of Data Repository> will be included in the informed consent.

With the participant's approval and as approved by local Institutional Review Boards (IRBs), de-identified biological samples will be stored at the <specify name of Biosample Repository> with the same goal as the sharing of data with the <specify name of Data Repository>. These samples could be used to research the causes of <specify condition(s)>, its complications and other conditions for which individuals with < specify condition(s)> are at increased risk, and to improve treatment. The <specify name of Repository> will also be provided with a code-link that will allow linking the biological specimens with the phenotypic data from each participant, maintaining the blinding of the identity of the participant.

During the conduct of the study, an individual participant can choose to withdraw consent to have biological specimens stored for future research. However, withdrawal of consent with regard to biosample storage may not be possible after the study is completed.

When the study is completed, access to study data and/or samples will be provided through the <specify name of Repository>.]

<Insert text>

### 10.1.5 Key Roles and Study Governance

*Provide the name and contact information of the Principal Investigator and the Medical Monitor.*


  **Principal Investigator**   **Medical Monitor**

  *Name, degree, title*        *Name, degree, title*

  *Institution Name*           *Institution Name*

  *Address*                    *Address*

  *Phone Number*               *Phone Number*

  *Email*                      *Email*


*In addition, briefly describe any study leadership committees (e.g.: Steering Committee, Executive Committee, Subcommittee) and their roles. Note that it is not necessary to list specific members. Also, describe country-specific administrative requirements or functions that materially affect the conduct of the study. The MOP should include a list of study team roles and responsibilities of those involved in the conduct, management, or oversight of the trial.*

<Insert text>

### 10.1.6 Safety Oversight

*Appropriate safety oversight should be used for each trial. This could include a Safety Monitoring Committee (SMC)*[^3]*, Data Safety Monitoring Board (DSMB)*[^4]*, Safety Assessment Committee*[^5]*, and/or an Independent Safety Monitor (ISM)*[^6]*. Independent oversight is an important component to ensure human subjects' protection and data integrity and should be considered for each study. In this section, the type of safety oversight should be clearly identified along with any known responsibilities for the oversight of safety and data integrity in the study. Describe the composition of the SMC or DSMB, frequency of interim data review, final data analysis and method of reviews. A separate DSMB Charter will provide further detail of DSMB membership, responsibilities and administration of the DSMB.*

*Example text provided as a guide, customize as needed:*

[Safety oversight will be under the direction of a Data and Safety Monitoring Board (DSMB) composed of individuals with the appropriate expertise, including <list expertise>. Members of the DSMB should be independent from the study conduct and free of conflict of interest, or measures should be in place to minimize perceived conflict of interest. The DSMB will meet at least semiannually to assess safety and efficacy data on each arm of the study. The DMSB will operate under the rules of an approved charter that will be written and reviewed at the organizational meeting of the DSMB. At this time, each data element that the DSMB needs to assess will be clearly defined. The DSMB will provide its input to <specify the study sponsor/National Institutes of Health staff/other>.]

<Insert text>

### 10.1.7 Clinical Monitoring

*Site monitoring is conducted to ensure that the rights and well-being of trial participants are protected, that the reported trial data are accurate, complete, and verifiable, and that the conduct of the trial is in compliance with the currently approved protocol/amendment(s), with ICH GCP, and with applicable regulatory requirement(s).*

*This section should give a general description of how monitoring of the conduct and progress of the clinical investigation will be conducted (i.e., who will conduct the monitoring, the type, frequency, and extent of monitoring, who will be provided reports of monitoring, if independent audits of the monitoring will be conducted). This section may refer to a separate detailed clinical monitoring plan.*

*A separate clinical monitoring plan (CMP) should describe in detail who will conduct the monitoring, at what frequency monitoring will be done, at what level of detail monitoring will be performed, and the distribution of monitoring reports.* *A CMP ordinarily should focus on preventing or mitigating important and likely risks, identified by a risk assessment, to critical data and processes. The types (e.g., on-site, centralized), frequency (e.g., early, for initial assessment and training versus throughout the study), and extent (e.g., comprehensive (100% data verification) versus targeted or random review of certain data (less than 100% data verification)) of monitoring activities will depend on a range of factors, considered during the risk assessment, including the complexity of the study design, types of study endpoints, clinical complexity of the study population, geography, relative experience of the PI and of the sponsor with the PI, electronic data capture, relative safety of the study intervention, stage of the study, and quantity of data.*

*If a separate CMP is not used, include all the details noted above in this section of the protocol.*

*Example text when a **separate CMP is being used is provided as a guide, customize as needed**:*

[Clinical site monitoring is conducted to ensure that the rights and well-being of trial participants are protected, that the reported trial data are accurate, complete, and verifiable, and that the conduct of the trial is in compliance with the currently approved protocol/amendment(s), with International Conference on Harmonisation Good Clinical Practice (ICH GCP), and with applicable regulatory requirement(s).

- Monitoring for this study will be performed by <insert text>.

- *<*Insert brief description of type of monitoring (e.g., on-site, centralized), frequency (e.g., early, for initial assessment and training versus throughout the study), and extent (e.g., comprehensive (100% data verification) versus targeted or random review of certain data (less than 100% data verification or targeted data verification of endpoint, safety and other key data variables)>.

- <Insert text> will be provided copies of monitoring reports within <x> days of visit.

- Details of clinical site monitoring are documented in a Clinical Monitoring Plan (CMP). The CMP describes in detail who will conduct the monitoring, at what frequency monitoring will be done, at what level of detail monitoring will be performed, and the distribution of monitoring reports.

- Independent audits <will/will not> be conducted by <insert text> to ensure monitoring practices are performed consistently across all participating sites and that monitors are following the CMP.]

OR

*Example text when a **separate CMP is [not]{.underline} being used is provided as a guide, customize as needed**:*

[Clinical site monitoring is conducted to ensure that the rights and well-being of trial participants are protected, that the reported trial data are accurate, complete, and verifiable, and that the conduct of the trial is in compliance with the currently approved protocol/amendment(s), with International Conference on Harmonisation Good Clinical Practice (ICH GCP), and with applicable regulatory requirement(s).

- <Insert detailed description of who will conduct the monitoring, the type of monitoring (e.g., on-site, centralized), frequency (e.g., early, for initial assessment and training versus throughout the study), and extent (e.g., comprehensive (100% data verification) versus targeted or random review of certain data (less than 100% data verification or targeted data verification of endpoint, safety and other key data variables)), and the distribution of monitoring reports>

- Independent audits <will/will not> be conducted by <insert text> to ensure monitoring practices are performed consistently across all participating sites.]

<Insert text>

### 10.1.8 Quality Assurance and Quality Control

*This section will briefly describe the plans for quality management, the system for assessing the quality of processes within a system. Quality management encompasses quality assurance (QA)*[^7] *and quality control (QC)*[^8]*.*

*Each site, both clinical and laboratory, should have SOPs for quality management that describe:*

- *How data and biological specimens (when applicable) will be evaluated for compliance with the protocol, ethical standards, regulatory compliance, and accuracy in relation to source documents.*

- *The documents to be reviewed (e.g., CRFs, clinic notes, product accountability records, specimen tracking logs, questionnaires, audio or video recordings), who is responsible, and the frequency for reviews.*

- *Who will be responsible for addressing QA issues (e.g., correcting procedures that are not in compliance with protocol) and QC issues (e.g., correcting errors in data entry).*

- *Staff training methods and how such training will be tracked.*

- *If applicable, calibration exercises conducted prior to and during the study to train examiners and maintain acceptable intra- and inter-examiner agreement.*

*Regular monitoring and an independent audit, if conducted, must be performed according to ICH GCP. See also **Section 10.1.7, Clinical Monitoring**.*

*Example text provided as a guide, customize as needed:*

[Each clinical site will perform internal quality management of study conduct, data and biological specimen collection, documentation and completion. An individualized quality management plan will be developed to describe a site's quality management.]

Quality control (QC) procedures will be implemented beginning with the data entry system and data QC checks that will be run on the database will be generated. Any missing data or data anomalies will be communicated to the site(s) for clarification/resolution.

Following written Standard Operating Procedures (SOPs), the monitors will verify that the clinical trial is conducted and data are generated and biological specimens are collected, documented (recorded), and reported in compliance with the protocol, International Conference on Harmonisation Good Clinical Practice (ICH GCP), and applicable regulatory requirements (e.g., Good Laboratory Practices (GLP), Good Manufacturing Practices (GMP)).

The investigational site will provide direct access to all trial related sites, source data/documents, and reports for the purpose of monitoring and auditing by the sponsor, and inspection by local and regulatory authorities.]

<Insert text>

### 10.1.9 Data Handling and Record Keeping

*No text is to be entered in this section; rather it should be included under the relevant subheadings below.*

*Each participating site will maintain appropriate medical and research records for this trial, in compliance with ICH GCP and regulatory and institutional requirements for the protection of confidentiality of participants. As part of participating in a NIH-sponsored or NIH-affiliated study, each site will permit authorized representatives of the NIH, sponsor, and regulatory agencies to examine (and when permitted by applicable law, to copy) clinical records for the purposes of quality assurance reviews, audits, and evaluation of the study safety, progress, and data validity. Describe in this section who will have access to records.*

*The following subsections should include a description of the data handling and record keeping for the conduct of the trial.*

#### 10.1.9.1 Data Collection and Management Responsibilities

*Provide details regarding the type(s) of data capture that will be used for the study and any relevant data standards or common data elements that are being utilized as a part of the trial. Specify whether it will be paper or electronic, distributed or central, batched or ongoing processing, and any related requirements. Indicate expectations for time for submission of CRFs. Further details should be provided in the MOP or the data management plan, including detailed descriptions of source documentation, CRFs, instructions for completing forms, data handling procedures, and procedures for data monitoring.*

*Source data are all information, original records of clinical findings, observations, or other activities in a clinical trial necessary for the reconstruction and evaluation of the trial. Electronic source data are data initially recorded in electronic form. Examples of source data include, but are not limited to, hospital records, clinical and office charts, laboratory notes, memoranda, participants' memory aids or evaluation checklists, pharmacy dispensing records, audio recordings of counseling sessions, recorded data from automated instruments, copies or transcriptions certified after verification as being accurate and complete, microfiches, photographic negatives, microfilm or magnetic media, x-rays, and participant files and records kept at the pharmacy, at the laboratories, and medico-technical departments involved in the clinical trial. It is acceptable to use CRFs as source documents. If this is the case, it should be stated in this section what data will be collected on CRFs and what data will be collected from other sources.*

*It is not acceptable for the CRF to be the only record of a participant's inclusion in the study. Study participation should be captured in a participant's medical record. This is to ensure that anyone who would access the patient medical record has adequate knowledge that the patient is participating in a clinical trial.*

*Describe responsibilities for data handling and record keeping as they specifically relate to the IND/IDE sponsor (if applicable), the award site, clinical site(s), laboratory(ies), and DCC. Information should include the role in data collection, review of data, trial materials, and reports, as well as retention of source documents, files, and records. Describe coding dictionaries to be used and reconciliation processes (if applicable).*

*If data are to be generated in one location and transferred to another group, describe the responsibilities of each party.*

*Provide a list of planned data standards, formats, terminologies and their versions, used for the collection, tabulation, analysis of study data. Refer to the FDA Guidance for Industry, Providing Regulatory Submissions in Electronic Format --- Standardized Study Data, Study Data Technical Conformance Guide and FDA Guidance for Industry, Providing Regulatory Submissions in Electronic Format - Human Pharmaceutical Product Applications and Related Submissions Using the eCTD Specifications.*

*Example text provided as a guide, customize as needed:*

[Data collection is the responsibility of the clinical trial staff at the site under the supervision of the site investigator. The investigator is responsible for ensuring the accuracy, completeness, legibility, and timeliness of the data reported.

All source documents should be completed in a neat, legible manner to ensure accurate interpretation of data.

Hardcopies of the study visit worksheets will be provided for use as source document worksheets for recording data for each participant enrolled in the study. Data recorded in the electronic case report form (eCRF) derived from source documents should be consistent with the data recorded on the source documents.

Clinical data (including adverse events (AEs), concomitant medications, and expected adverse reactions data) and clinical laboratory data will be entered into <specify name of data capture system>, a 21 CFR Part 11-compliant data capture system provided by the <specify Data Coordinating Center>. The data system includes password protection and internal quality checks, such as automatic range checks, to identify data that appear inconsistent, incomplete, or inaccurate. Clinical data will be entered directly from the source documents.]

<Insert text>

#### 10.1.9.2 Study Records Retention

*Specify the length of time for the investigator to maintain all records pertaining to this study. The investigator should use the most conservative rule for document retention -- i.e., retention should follow the rule that has the longest period. For NIH, grantees must retain records for a period of three years from the date of Federal Financial Report (FFR) submission.*

*Indicate whether permission is required (and from whom) prior to destruction of records. If under an IND/IDE, records should not be destroyed without the IND/IDE sponsor's agreement. Pharmaceutical companies who supply unapproved products should be consulted.*

*Study intervention records may be described here if not addressed elsewhere in the protocol.*

*Example text provided as a guide, customize as needed:*

[Study documents should be retained for a minimum of 2 years after the last approval of a marketing application in an International Conference on Harminosation (ICH) region and until there are no pending or contemplated marketing applications in an ICH region or until at least 2 years have elapsed since the formal discontinuation of clinical development of the study intervention. These documents should be retained for a longer period, however, if required by local regulations. No records will be destroyed without the written consent of the sponsor, if applicable. It is the responsibility of the sponsor to inform the investigator when these documents no longer need to be retained.]

<Insert text>

### 10.1.10 Protocol Deviations

*Plans for detecting, reviewing, and reporting deviations from the protocol should be described. A statement should be included to indicate that deviations are not allowed, unless a statement is included in the investigator agreement. Provisions for approval of deviations can be described.*

*Example text* *provided as a guide, customize as needed:*

[A protocol deviation is any noncompliance with the clinical trial protocol, International Conference on Harmonisation Good Clinical Practice (ICH GCP), or Manual of Procedures (MOP) requirements. The noncompliance may be either on the part of the participant, the investigator, or the study site staff. As a result of deviations, corrective actions are to be developed by the site and implemented promptly.

These practices are consistent with ICH GCP:

- 4.5 Compliance with Protocol, sections 4.5.1, 4.5.2, and 4.5.3

- 5.1 Quality Assurance and Quality Control, section 5.1.1

- 5.20 Noncompliance, sections 5.20.1, and 5.20.2.

It is the responsibility of the site investigator to use continuous vigilance to identify and report deviations within <specify number> working days of identification of the protocol deviation, or within <specify number> working days of the scheduled protocol-required activity. All deviations must be addressed in study source documents, reported to <specify NIH Institute or Center (IC)> Program Official and <specify Data Coordinating Center or sponsor>. Protocol deviations must be sent to the reviewing Institutional Review Board (IRB) per their policies. The site investigator is responsible for knowing and adhering to the reviewing IRB requirements. Further details about the handling of protocol deviations will be included in the MOP.]

<Insert text>

### 10.1.11 Publication and Data Sharing Policy

*The publication and authorship policies should be described in this section. For example, for a study with multiple investigators, this section might state that an Executive Committee will be responsible for developing publication procedures and resolving authorship issues. Please refer to your specific contract, grant, and/or Clinical Trials Agreements. If details of the publication policy will be described in the study's MOP, refer to it here. The study must comply with:*

- *The NIH Public Access Policy, the NIH Policy on the Dissemination of NIH-Funded Clinical Trial Information, The Food and Drug Administration Amendments Act of 2007 (FDAAA), Clinical Trials Registration and Results Information Submission rule,*

- *The NIH Data Sharing Policy (if applicable),*

- *The NIH Genomic Data Sharing Policy, (if applicable), and*

- *The NIH Data Sharing Policy and Implementation Guidance,*

- *Any other relevant policies (e.g., NIH IC-specific data sharing or publication policy)*

*Example text* *provided as a guide, customize as needed:*

[This study will be conducted in accordance with the following publication and data sharing policies and regulations:

National Institutes of Health (NIH) Public Access Policy, which ensures that the public has access to the published results of NIH funded research. It requires scientists to submit final peer-reviewed journal manuscripts that arise from NIH funds to the digital archive [PubMed Central]{.underline} upon acceptance for publication.

This study will comply with the NIH Data Sharing Policy and Policy on the Dissemination of NIH-Funded Clinical Trial Information and the Clinical Trials Registration and Results Information Submission rule. As such, this trial will be registered at ClinicalTrials.gov, and results information from this trial will be submitted to ClinicalTrials.gov. In addition, every attempt will be made to publish results in peer-reviewed journals. Data from this study may be requested from other researchers x years after the completion of the primary endpoint by contacting <specify person or awardee institution, or name of data repository>.

In addition, this study will comply with the NIH Genomic Data Sharing Policy, which applies to all NIH-funded research that generates large-scale human or non-human genomic data, as well as the use of these data for subsequent research. Large-scale data include genome-wide association studies (GWAS), single nucleotide polymorphisms (SNP) arrays, and genome sequence, transcriptomic, epigenomic, and gene expression data.]

<Insert text>

### 10.1.12 Conflict of Interest Policy

*This section should include a description of how the study will manage actual or perceived conflicts of interest.*

*Example text* *provided as a guide, customize as needed:*

[The independence of this study from any actual or perceived influence, such as by the pharmaceutical industry, is critical. Therefore, any actual conflict of interest of persons who have a role in the design, conduct, analysis, publication, or any aspect of this trial will be disclosed and managed. Furthermore, persons who have a perceived conflict of interest will be required to have such conflicts managed in a way that is appropriate to their participation in the design and conduct of this trial. The study leadership in conjunction with the <specify NIH Institute or Center (IC)> has established policies and procedures for all study group members to disclose all conflicts of interest and will establish a mechanism for the management of all reported dualities of interest.]

<Insert text>

## 10.2 Additional Considerations

*This section should include a description of any additional considerations not currently covered in this protocol template, such as particular institutional or IRB-related requirements.*

<Insert text>

**

## 10.3 Abbreviations

*The list below includes abbreviations utilized in this template. However, this list should be customized for each protocol (i.e., abbreviations not used should be removed and new abbreviations used should be added to this list).*


  AE        Adverse Event
  ---------
  ANCOVA    Analysis of Covariance

  CFR       Code of Federal Regulations

  CLIA      Clinical Laboratory Improvement Amendments

  CMP       Clinical Monitoring Plan

  COC       Certificate of Confidentiality

  CONSORT   Consolidated Standards of Reporting Trials

  CRF       Case Report Form

  DCC       Data Coordinating Center

  DHHS      Department of Health and Human Services

  DSMB      Data Safety Monitoring Board

  DRE       Disease-Related Event

  EC        Ethics Committee

  eCRF      Electronic Case Report Forms

  FDA       Food and Drug Administration

  FDAAA     Food and Drug Administration Amendments Act of 2007

  FFR       Federal Financial Report

  GCP       Good Clinical Practice

  GLP       Good Laboratory Practices

  GMP       Good Manufacturing Practices

  GWAS      Genome-Wide Association Studies

  HIPAA     Health Insurance Portability and Accountability Act

  IB        Investigator's Brochure

  ICH       International Conference on Harmonisation

  ICMJE     International Committee of Medical Journal Editors

  IDE       Investigational Device Exemption

  IND       Investigational New Drug Application

  IRB       Institutional Review Board

  ISM       Independent Safety Monitor

  ISO       International Organization for Standardization

  ITT       Intention-To-Treat

  LSMEANS   Least-squares Means

  MedDRA    Medical Dictionary for Regulatory Activities

  MOP       Manual of Procedures

  MSDS      Material Safety Data Sheet

  NCT       National Clinical Trial

  NIH       National Institutes of Health

  NIH IC    NIH Institute or Center

  OHRP      Office for Human Research Protections

  PI        Principal Investigator

  QA        Quality Assurance

  QC        Quality Control

  SAE       Serious Adverse Event

  SAP       Statistical Analysis Plan

  SMC       Safety Monitoring Committee

  SOA       Schedule of Activities

  SOC       System Organ Class

  SOP       Standard Operating Procedure

  UP        Unanticipated Problem

  US        United States


**

## 10.4 Protocol Amendment History

*The table below is intended to capture changes of IRB-approved versions of the protocol, including a description of the change and rationale. A Summary of Changes table for the current amendment is located in the Protocol Title Page.*


  **Version**   **Date**   **Description of Change**   **Brief Rationale**
  ------------- ----------


# 11 REFERENCES

*Include a list of relevant literature and citations for all publications referenced in the text of the protocol. Use a consistent, standard, modern format, which might be dependent upon the required format for the anticipated journal for publication (e.g., N Engl J Med, JAMA, etc.). The preferred format is International Committee of Medical Journal Editors (ICMJE). Include citations to product information such as manufacturer's IB, package insert, and device labeling.*

*Examples:*

- ***Journal citation**
  Veronesi U, Maisonneuve P, Decensi A. Tamoxifen: an enduring star. J Natl Cancer Inst. 2007 Feb 21;99(4):258-60.*

- ***Whole book citation**
  Belitz HD, Grosch W, Schieberle P. Food chemistry. 3rd rev. ed. Burghagen MM, translator. Berlin: Springer; 2004. 1070 p.*

- ***Chapter in a book citation**
  Riffenburgh RH. Statistics in medicine. 2nd ed. Amsterdam (Netherlands): Elsevier Academic Press; c2006. Chapter 24, Regression and correlation methods; p. 447-86.*

- ***Web Site citation**
  Complementary/Integrative Medicine [Internet]. Houston: University of Texas, M.D. Anderson Cancer Center; c2007 [cited 2007 Feb 21]. Available from: http://www.manderson.org/departments/CIMER/.*

- ***Electronic Mail citation***

*Backus, Joyce. Physician Internet search behavior: detailed study [Internet]. Message to: Karen Patrias. 2007 Mar 27 [cited 2007 Mar 28]. [2 paragraphs]*

- ***References to package insert, device labeling or investigational brochure***

*Cite date accessed, version number, and source of product information.*

[^1]: From ClinicalTrials.gov Protocol Data Element Definitions available at: <https://prsinfo.clinicaltrials.gov/definitions.html>. Accessed March 2017.

[^2]: From 21 CFR 312.21 "Phase 2 includes the controlled clinical studies conducted to evaluate the effectiveness of the drug for a particular indication or indications in patients with the disease or condition under study and to determine the common short-term side effects and risks associated with the drug. Phase 2 studies are typically well controlled, closely monitored, and conducted in a relatively small number of patients, usually involving no more than several hundred subjects... Phase 3 studies are expanded controlled and uncontrolled trials. They are performed after preliminary evidence suggesting effectiveness of the drug has been obtained, and are intended to gather the additional information about effectiveness and safety that is needed to evaluate the overall benefit-risk relationship of the drug and to provide an adequate basis for physician labeling. Phase 3 studies usually include from several hundred to several thousand subjects."

[^3]: A Safety Monitoring Committee (SMC) is a small group of experts with at least two members who are independent of the protocol who review data from a particular study. Generally, independent investigators and biostatisticians should be included. The primary responsibility of the SMC is to monitor participant safety. The SMC considers study-specific data as well as relevant background information about the disease, intervention, and target population under study.

[^4]: A Data and Safety Monitoring Board (DSMB) is an independent group of experts that advises funding IC(s) and the study investigators. The members of the DSMB provide their expertise and recommendations. The primary responsibilities of the DSMB are to 1) periodically review and evaluate the accumulated study data for participant safety, study conduct and progress, and, when appropriate, efficacy, and 2) make recommendations concerning the continuation, modification, or termination of the trial. The DSMB considers study-specific data as well as relevant background knowledge about the disease, intervention, or target population under study.

[^5]: As noted on page 4 of the FDA Draft Guidance for Industry: Safety Assessment for IND Safety Reporting, "A group of individuals chosen by the sponsor to review safety information in a development program (i.e., across trials, INDs, and other sources) for IND safety reporting purposes...The safety assessment committee should oversee the evolving safety profile of the investigational drug by evaluating, at appropriate intervals, the cumulative serious adverse events from all of the trials in the development program, as well as other available important safety information (e.g., findings from epidemiological studies and from animal or in vitro testing) and performing unblended comparisons of event rates in investigational and control groups, as needed, so the sponsor may meet its obligations under § 312.32(b) and (c). The safety assessment committee's primary role should be to review important safety information on a regular basis, with additional reviews as needed, and make a recommendation to the sponsor to help the sponsor determine whether an event or group of events meets the criteria for IND safety reporting. The safety assessment committee, possibly together with other parties (e.g., steering committees, data monitoring committees [DMCs]), can also participate in decisions about whether the conduct of the study should be revised (e.g., change ineligibility criteria, revision of informed consent).

[^6]: An Independent Safety Monitor (ISM) is a physician, nurse, or other individual with relevant expertise whose primary responsibility is to provide independent safety monitoring in a timely fashion. This is accomplished by review of adverse events, immediately after they occur or are reported, with follow-up through resolution. The ISM evaluates individual and cumulative participant data when making recommendations regarding the safe continuation of the study.

[^7]: All those planned and systematic actions that are established to ensure that the trial is performed and the data are generated, documented (recorded), and reported in compliance with ICH GCP and the applicable regulatory requirement(s) (ICH E6 Section 1.46).

[^8]: The operational techniques and activities undertaken within the quality assurance system to verify that the requirements for quality of the trial-related activities have been fulfilled (ICH E6 Section 1.47).
