# SKILL 7: Problem Inversion Strategies ("Turn It On Its Head")

## Overview
This skill provides three concrete strategies for navigating around obstacles by reframing problems. When stuck, instead of pushing harder on the current approach, try inverting the problem.

## Core Principle
**"Turn a problem on its head"**

Three powerful strategies:
1. **Unfix parameters** (covered in Skill 4, applied here in crisis)
2. **Don't achieve goal A? Achieve comparable goal B**
3. **"I have the answer; what is the question?"**

## Strategy 1: Unfix Parameters (In Crisis Mode)

**When to Use:** Run-of-the-mill issues in project execution

**Approach:** Let a "sacred" fixed parameter float

**Example from Lecture:**
- **Stuck:** Spatial transcriptomics of APC-T cell interactions in tumor microenvironment
- **All fixed:** Technique, cell types, context
- **Inversion:**
  - Unfix technique → What else could measure these interactions?
  - Unfix cell types → What other interactions matter in tumors?
  - Unfix context → Where else do APC-T interactions matter?

**Your Application:**
For each fixed parameter in your project:
- What if this floated?
- What alternatives exist?
- Which would be easier/faster/more informative?

## Strategy 2: Comparable Goal Substitution

**When to Use:** Existential threats to project (can't achieve original goal)

**Approach:** Achieve a different but equally valuable goal

**Mindset Shift:**
- **Wrong:** "I failed to do X"
- **Right:** "The world needs Y instead, which I CAN do"

**Example from Lectures: PROTAC Story**
- **Goal A (Failed):** Degrade specific therapeutic target
- **Goal B (Achieved):** Map which kinases ARE degradable
- **Value:** B is more impactful (general principle + method validation)
- **Learning:** Target engagement ≠ degradation (important discovery)

**Framework:**
1. **Original goal:** [What you wanted]
2. **Why it failed:** [Specific reason]
3. **What CAN you do with current data/tools:** [Capabilities]
4. **Comparable goals:**
   - Option 1: [Different but related goal]
   - Option 2: [Another alternative]
   - Option 3: [Yet another]
5. **Which is most valuable:** [Analysis]
6. **How to frame it:** [Communication strategy]

## Strategy 3: Answer Seeking Question

**When to Use:** End-of-project challenges (interpretation, framing, application)

**Approach:** You got an answer, but not to your original question. What question DOES your data answer?

**Mindset Shift:**
- **Wrong:** "This doesn't answer my question"
- **Right:** "What interesting question does this answer?"

**Example from Lectures: Steroid Receptor**
- **Original Question:** What is THE receptor for this steroid?
- **Answer Obtained:** Binds multiple receptors at different affinities
- **Problem:** Can't answer original question (no single receptor)
- **Inversion:** "What question does this answer?"
- **New Question:** How does finite receptor pool sense infinite lipids?
- **Answer:** Combinatorial sensing (pattern = unique "chord")
- **Impact:** More interesting than intended finding

**Framework:**
1. **Original question:** [What you asked]
2. **Data obtained:** [What you actually found]
3. **Why it doesn't answer:** [The mismatch]
4. **What DOES the data show clearly:** [Solid findings]
5. **What questions could these answer:**
   - Question 1: [Option]
   - Question 2: [Option]
   - Question 3: [Option]
6. **Which is most interesting:** [Assessment]
7. **How to reframe paper/project:** [New framing]

## Workflow

### Phase 1: Identify Your Obstacle
- **Type:** Technical / Biological / Competitive / Interpretive
- **Severity:** Run-of-mill / Existential / End-stage
- **Description:** [What's blocking you]

### Phase 2: Select Strategy

| Obstacle Type | Recommended Strategy |
|--------------|---------------------|
| Technical barrier, mid-project | Strategy 1 (Unfix parameters) |
| Can't achieve original goal | Strategy 2 (Comparable goal) |
| Have data, unclear what it means | Strategy 3 (Answer seeking question) |

### Phase 3: Apply Strategy

Work through the relevant framework above with your specific situation.

### Phase 4: Evaluate Alternatives

For each alternative generated:
- **Scientific value:** How interesting is this?
- **Feasibility:** How hard to execute?
- **Timeline:** How long will it take?
- **Impact:** How does this compare to original plan?
- **Your advantage:** Do you still have edge here?

## Output: Problem Inversion Analysis

**Page 1: Current Situation**
- **Obstacle:** [Clear description]
- **Why you're stuck:** [Root cause]
- **Original plan:** [What you intended]
- **Current capability:** [What you CAN do]

**Page 2: Strategy Applications**

**Strategy 1 (Unfix Parameters):**
| Fixed Parameter | If This Floated | Alternative Approaches | Assessment |
|----------------|-----------------|----------------------|------------|
| [Param 1] | [Consequences] | [Options] | [Value] |

**Strategy 2 (Comparable Goals):**
| Original Goal | Why It Failed | Comparable Goal | Value Assessment |
|--------------|---------------|----------------|------------------|
| [Goal A] | [Reason] | [Goal B] | [Compare impact] |

**Strategy 3 (Answer → Question):**
- **Data obtained:** [What you have]
- **Question 1 it could answer:** [Option 1]
- **Question 2 it could answer:** [Option 2]
- **Question 3 it could answer:** [Option 3]
- **Most interesting:** [Selection + reasoning]

**Page 3: Recommended Path**
- **Selected strategy:** [1, 2, or 3]
- **New direction:** [Specific plan]
- **Why this is better:** [Not just "it works" but "it's more interesting"]
- **Communication approach:** [How to frame this pivot]
- **Timeline:** [New schedule]
