# VS Code Documentation Resources

## Official Documentation URLs

### Release Notes
- **Latest release**: https://code.visualstudio.com/updates
- **Version-specific**: https://code.visualstudio.com/updates/v{version} (e.g., v1_107 for v1.107.0)

### GitHub Repository
- **Docs source**: https://github.com/microsoft/vscode-docs/
- **TOC JSON**: https://github.com/microsoft/vscode-docs/blob/main/docs/toc.json

## Documentation Structure

The VS Code documentation is organized into these main categories:

### Getting Started
- Setup and installation
- User interface overview
- Basic configuration

### Core Features
- Editor and editing features
- Languages and frameworks
- Debugging and testing
- Terminal integration
- Source control (Git)
- Extensions marketplace

### Advanced Topics
- Remote development (SSH, Containers, WSL)
- Dev containers
- Multi-root workspaces
- Tasks and launch configurations
- Settings and preferences

### GitHub Copilot
- Chat functionality
- Inline suggestions
- Custom instructions
- Prompt engineering
- Agents and tools
- Security and privacy

## Content Types

- **Guides**: Step-by-step tutorials
- **Reference**: API documentation and configuration options
- **Tips**: Best practices and productivity hacks
- **Troubleshooting**: Common issues and solutions