# Tutorial Template

**Purpose**: Teach a skill through guided, hands-on practice. User learns by doing, building confidence and familiarity.

**Key Characteristics**:
- Concrete, step-by-step activities
- Visible results at every step
- Meaningful, achievable goal
- Minimal explanation (link instead)
- Perfect reliability (every step works)

## Structure

```markdown
# [Getting Started | Your First] [Topic]

[One sentence: what you'll accomplish]

## What you'll build

[Clear description of end result, with context if helpful]

Example: "You'll create and deploy a containerized web application 
that responds to HTTP requests in under 5 minutes."

## Before you start

[Minimal prerequisites, 2-4 items]
- [Prerequisite 1] installed
- [Prerequisite 2] configured
- Basic familiarity with [Prerequisite 3]

## Step 1: [Concrete action]

[Detailed instructions. Be directive: "do X", not "you might want to".]

```
[Exact command or action]
```

The output should look something like:

```
[Show expected output]
```

Notice that [something important to observe].

## Step 2: [Next concrete action]

[Follow same structure]

## What you've built

[Acknowledge what they've accomplished]

Example: "You've created a [thing], configured [thing], and deployed it 
successfully. You now understand [skill]."

## Next steps

- Learn more: [Link to Explanation for "why"]
- Customize it: [Link to How-to Guide for the next real problem]
- Explore options: [Link to Reference]
```

## Language Patterns

Use these patterns consistently throughout your tutorial:

| Pattern | Example |
|---------|---------|
| **We will…** | "In this tutorial, we will create a secure login form." |
| **First… Now… After…** | "First, open the terminal. Now, type the command. After it finishes, you should see…" |
| **Notice that…** | "Notice that the prompt changed from $ to #. This means you're in the right mode." |
| **The output should look like…** | "The server should respond with a 200 status code, like this: `HTTP/1.1 200 OK`" |
| **You have now…** | "You have now created a database, connected to it, and inserted your first record." |

## Key Principles to Remember

✓ **Show the destination upfront** — "By the end, you'll have X"

✓ **Deliver visible results early and often** — Users see progress quickly

✓ **Maintain narrative of expectations** — "You will notice that…", "You should see…"

✓ **Point out what learners should observe** — Guide attention to important details

✓ **Focus on the concrete, not abstract** — Use specific, tangible examples

✓ **Ruthlessly minimize explanation** — Link to it, don't embed it

✓ **Encourage and permit repetition** — Let users practice multiple times

✓ **Ignore options and alternatives** — Teach one way; link to alternatives elsewhere

✓ **Aspire to perfect reliability** — Every step must work as described

## Example

See [examples.md](examples.md#example-1-tutorial) for a complete working example: "Your First Django App"
