# Task Grounding Validation - Visual Guide
**Version**: 1.0.0 | **Purpose**: Flowcharts and diagrams for understanding the process

---

## 🎯 Overall Process Flow

```
┌─────────────────────────────────────────────────────────────┐
│                  tasks.md Generated                         │
│                    (by speckit.tasks)                       │
└────────────────────────────┬────────────────────────────────┘
                             ↓
┌─────────────────────────────────────────────────────────────┐
│          🚪 VALIDATION GATE (15-25 minutes)                 │
│                    ← NEW STEP                               │
│                                                              │
│  1. Extract tasks from tasks.md                             │
│  2. Index planning artifacts                                │
│  3. Map each task to artifact evidence                      │
│  4. Score grounding level (0-100%)                          │
│  5. Identify gaps and risks                                 │
│  6. Generate TASK_GROUNDING_ANALYSIS.md                     │
└────────────────────────────┬────────────────────────────────┘
                             ↓
                    ┌────────────────┐
                    │  Decision Gate │
                    └────────┬───────┘
             ┌──────────────┼──────────────┐
             ↓              ↓              ↓
        ✅ APPROVED    ⚠️ CLARIFY    🔴 BLOCKED
             ↓              ↓              ↓
        PROCEED TO      UPDATE           RETURN TO
        IMPLEMENTATION  ARTIFACTS        PLANNING
             ↓              ↓              ↓
        [Implementation] [Regenerate    [Resolve gaps,
                         tasks.md]      revise spec/plan]
                              ↓              ↓
                          [Revalidate]  [Retry validation]
```

---

## 📊 Decision Matrix (Simple)

```
                    Phase 1/2 Grounding Level
                ┌─────────────┬─────────────┬──────────┐
                │   ≥80%      │   70-79%    │   <70%   │
        ┌───────┼─────────────┼─────────────┼──────────┤
        │ Low   │   ✅ OK     │  ⚠️  REVIEW │ 🔴 BLOCK │
    Gap │ Gaps  │             │             │          │
        ├───────┼─────────────┼─────────────┼──────────┤
        │ Med   │  ⚠️  REVIEW │  🔴 BLOCK   │ 🔴 BLOCK │
        │ Gaps  │             │             │          │
        ├───────┼─────────────┼─────────────┼──────────┤
        │ High  │ 🔴 BLOCK    │  🔴 BLOCK   │ 🔴 BLOCK │
        │ Gaps  │             │             │          │
        └───────┴─────────────┴─────────────┴──────────┘
```

---

## 🔍 Task Grounding Scoring Process

```
┌──────────────────────────────────────────────────────────┐
│ For Each Task in tasks.md                                │
└──────────────────────────────────────┬───────────────────┘
                                       ↓
                    ┌──────────────────────────────────┐
                    │ Step 1: Find Evidence            │
                    │ Search planning artifacts for    │
                    │ requirement statement            │
                    └──────────┬───────────────────────┘
                               ↓
                    ┌──────────────────────────────────┐
                    │ Step 2: Count Sources            │
                    │ How many artifacts mention this? │
                    │ - 1 source: 60%                  │
                    │ - 2 sources: 75%                 │
                    │ - 3+ sources: 85%+              │
                    └──────────┬───────────────────────┘
                               ↓
                    ┌──────────────────────────────────┐
                    │ Step 3: Rate Evidence Quality    │
                    │ Explicit = 100%                  │
                    │ Detailed = 90%                   │
                    │ Reference = 70%                  │
                    │ Implicit = 50%                   │
                    │ Assumed = 20%                    │
                    └──────────┬───────────────────────┘
                               ↓
                    ┌──────────────────────────────────┐
                    │ Step 4: Calculate Score          │
                    │ Average quality × source count   │
                    │ = Grounding Level (0-100%)       │
                    └──────────┬───────────────────────┘
                               ↓
                    ┌──────────────────────────────────┐
                    │ Step 5: Assign Risk              │
                    │ 100% = 🟢 Low                    │
                    │ 80-90% = 🟢 Low                  │
                    │ 70-79% = 🟡 Medium               │
                    │ 60-69% = 🟡 Medium               │
                    │ <60% = 🔴 High                   │
                    └──────────┬───────────────────────┘
                               ↓
                    ┌──────────────────────────────────┐
                    │ Result: Task Score Card          │
                    │ ├─ ID: T###                      │
                    │ ├─ Grounding: ##%                │
                    │ ├─ Risk: 🟢/🟡/🔴                 │
                    │ ├─ Primary Artifact: ____        │
                    │ └─ Gaps: [list]                  │
                    └──────────────────────────────────┘
```

---

## 📈 Artifact Coverage Visualization

```
Ideal Coverage (All 7 artifacts):

    spec.md ━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━
                          ║
    plan.md ━━━━━━━━━━━━━━┫━━━━━━━━━━━━━━━
                          ║
    data-model.md ━━━━━━━━╋━━━━━━━━━━━━━━━
                          ║
    api-contracts.md ━━━━━╋━━━━━━━━━━━━━━━
                          ║
    research.md ━━━━━━━━━━╋━━━━━━━━━━━━━━━
                          ║
    quickstart.md ━━━━━━━━╋━━━━━━━━━━━━━━━
                          ║
    Other docs ━━━━━━━━━━━╋━━━━━━━━━━━━━━━
                          ║
                    ┌─────╨──────┐
                    │ Task ∑ = 6  │
                    │ Avg: 75%    │
                    └─────────────┘

Minimum Coverage (spec.md + plan.md):

    spec.md ━━━━━━━━━━┳━━━━━━━━━
                      ║
    plan.md ━━━━━━━━━━╋━━━━━━━━━
                      ║
    (other) ━━━━━━━━━━┫
                      ║
                  ┌───╨────┐
                  │Task ∑=2 │
                  │ Avg: 70%│
                  └────────┘
```

---

## 🎓 Grounding Level Scale (Visual)

```
                            GROUNDING LEVEL
                                  ↓
        ┌──────────────────────────┴──────────────────────────┐
        ↓                                                      ↓
    STRONG (80-100%)                               WEAK (<80%)
        ↓                                                      ↓
    ┌───────────┐                                  ┌──────────────┐
    │ EXPLICIT  │                                  │ INFERRED     │
    │ 100%      │                                  │ 60-70%       │
    │           │                                  │              │
    │ "Add X to │                                  │ Pattern from │
    │ Y file"   │                                  │ other tasks, │
    │ ✅ SAFE   │                                  │ not explicit │
    └───────────┘                                  └──────────────┘
        ↓                                                      ↓
    ┌───────────┐                                  ┌──────────────┐
    │ DETAILED  │                                  │ ASSUMED      │
    │ 90%       │                                  │ <50%         │
    │           │                                  │              │
    │ Example   │                                  │ Task        │
    │ code      │                                  │ invented w/o │
    │ provided  │                                  │ evidence     │
    │ ✅ SAFE   │                                  │ 🔴 RISKY     │
    └───────────┘                                  └──────────────┘
        ↓                                                      ↓
    ┌───────────┐                                  ┌──────────────┐
    │ REFERENCE │                                  │ EXTERNAL     │
    │ 80%       │                                  │ 50-60%       │
    │           │                                  │              │
    │ "See      │                                  │ Needs spec.md│
    │ Section X"│                                  │ FR-###       │
    │ ✅ SAFE   │                                  │ ⚠️ NEEDS VER │
    └───────────┘                                  └──────────────┘
```

---

## 📋 Review Checklist Flow

```
START REVIEW
    ↓
[Check 1: Artifacts exist?]
├─ NO  → Get missing artifacts
└─ YES → Continue
    ↓
[Check 2: All tasks listed?]
├─ NO  → List missing tasks
└─ YES → Continue
    ↓
[Check 3: Each task scored?]
├─ NO  → Score remaining tasks
└─ YES → Continue
    ↓
[Check 4: Grounding ≥50%?]
├─ NO  → Remove or justify low-score tasks
└─ YES → Continue
    ↓
[Check 5: Consistency OK?]
├─ NO  → Document artifact conflicts
└─ YES → Continue
    ↓
[Check 6: Gaps identified?]
├─ NO  → Find and list gaps
└─ YES → Continue
    ↓
[Check 7: Risks documented?]
├─ NO  → Add risk assessment
└─ YES → Continue
    ↓
[Check 8: Decision clear?]
├─ NO  → State decision (Approve/Clarify/Block)
└─ YES → Continue
    ↓
APPROVAL DECISION
├─ ✅ APPROVED (all 8 checks pass)
├─ ⚠️ NEEDS CLARIFICATION (6-7 checks pass)
└─ 🔴 BLOCKED (<6 checks pass)
    ↓
END REVIEW
```

---

## 🏆 Success Criteria Pyramid

```
                        ┌─────────────────┐
                        │   APPROVED ✅   │
                        │ Confidence≥80%  │
                        └────────┬────────┘
                                 ↑
                    ┌────────────┼────────────┐
                    │                         │
            ┌───────────────┐        ┌──────────────┐
            │ Gaps <3       │        │ Risks <3 High│
            │ documented    │        │ with mitigation
            └───────────────┘        └──────────────┘
                    │                         │
                    └────────────┬────────────┘
                                 ↑
                    ┌────────────┼────────────┐
                    │                         │
            ┌────────────────┐      ┌─────────────────┐
            │Phase 1: ≥90%   │      │Phase 2: ≥80%    │
            │tasks @ 80%+    │      │tasks @ 70%+     │
            └────────────────┘      └─────────────────┘
                    │                         │
                    └────────────┬────────────┘
                                 ↑
                    ┌────────────┼────────────┐
                    │                         │
            ┌─────────────────────┐  ┌───────────────┐
            │ All artifacts       │  │ No contradictions
            │ exist & indexed     │  │ between artifacts
            └─────────────────────┘  └───────────────┘
```

---

## ⚖️ Risk Assessment Matrix

```
                    Grounding Level
                  ┌─────┬─────┬─────┐
                  │ 100 │ 80  │ 60  │ <60
        ┌─────────┼─────┼─────┼─────┼─────┐
        │ 0-1     │ 🟢  │ 🟢  │ 🟡  │ 🟡  │
    Gap │ Gaps    │ Low │ Low │ Med │ Med │
        ├─────────┼─────┼─────┼─────┼─────┤
        │ 2-3     │ 🟢  │ 🟡  │ 🟡  │ 🔴  │
    Count│ Gaps    │ Low │ Med │ Med │High │
        ├─────────┼─────┼─────┼─────┼─────┤
        │ 4-5     │ 🟡  │ 🟡  │ 🔴  │ 🔴  │
        │ Gaps    │ Med │ Med │High │High │
        ├─────────┼─────┼─────┼─────┼─────┤
        │ >5      │ 🔴  │ 🔴  │ 🔴  │ 🔴  │
        │ Gaps    │High │High │High │High │
        └─────────┴─────┴─────┴─────┴─────┘

Legend:
🟢 = Safe to approve
🟡 = Needs review/clarification
🔴 = Block, return to planning
```

---

## 🔄 Feedback Loop (If Blocked)

```
BLOCKED ✋
   ↓
   └─→ [Return to Planning Phase]
           ↓
       [Identify root causes]
       ├─ Incomplete artifacts
       ├─ Vague requirements
       ├─ Task assumptions
       ├─ Scope creep
       └─ Unresolved decisions
           ↓
       [Update spec.md / plan.md]
       ├─ Clarify requirements
       ├─ Document assumptions
       ├─ Remove invented tasks
       └─ Resolve gaps
           ↓
       [Regenerate tasks.md]
       ├─ Remove problematic tasks
       ├─ Add missing tasks
       └─ Reorder if needed
           ↓
       [Revalidate with this framework]
           ↓
       ├─ Now APPROVED? → Proceed ✅
       ├─ Now CLARIFY? → Update artifacts
       └─ Still BLOCKED? → Repeat above
```

---

## 📊 Phase Metrics Dashboard

```
FEATURE: 007-lifeline-invitation-auto-role-mvp

┌─────────────┬────────────┬──────────────┬──────────┐
│ Phase       │ Task Count │ Avg Grounding│ Risk     │
├─────────────┼────────────┼──────────────┼──────────┤
│ Phase 1     │ 3          │ 90%          │ 🟢 Low   │
│ Phase 2     │ 2          │ 55%          │ 🔴 High  │
│ Phase 3     │ 3          │ 75%          │ 🟡 Med   │
│ Phase 4     │ 3          │ 70%          │ 🟡 Med   │
│ Phase 5+    │ 5          │ 65%          │ 🟡 Med   │
├─────────────┼────────────┼──────────────┼──────────┤
│ TOTAL       │ 16         │ 71%          │ 🟡 Med   │
└─────────────┴────────────┴──────────────┴──────────┘

Decision: ⚠️ NEEDS CLARIFICATION

Why: Phase 2 avg 55% < 70% threshold
Action: Verify spec.md FR-001, regenerate Phase 2 tasks
```

---

## 🎯 Task Lifecycle with Validation

```
TRADITIONAL (Before Validation)          WITH VALIDATION (NEW)

tasks.md                                 tasks.md (initial)
  ↓                                         ↓
(No validation)                          [Validation Gate]
  ↓                                         ↓
Implementation                          Decision
  ├─ ❓ Task purpose unclear              ├─ ✅ Approved
  ├─ ❓ Contradictions found              ├─ ⚠️ Clarify
  ├─ ❓ Scope questions                   └─ 🔴 Block
  └─ ⚠️ Rework mid-sprint                    ↓
                                          Implementation
                                          ├─ ✅ Clear purpose
                                          ├─ ✅ Consistent
                                          ├─ ✅ No surprises
                                          └─ 🎯 On track

Result: Validation saves 5-15%
of implementation time through
clearer requirements
```

---

## 🚀 Integration Timeline

```
WEEK 1: SETUP
┌────────────────────────┐
│ Day 1: Read docs       │
│ Day 2-3: Customize     │
│ Day 4: Create template │
│ Day 5: Test script     │
└────────────────────────┘
         ↓
WEEK 2: PILOT
┌────────────────────────┐
│ Day 1-2: Apply to 007  │
│ Day 3: Generate report │
│ Day 4-5: Team feedback │
└────────────────────────┘
         ↓
WEEK 3: REFINE
┌────────────────────────┐
│ Day 1-2: Adjust process│
│ Day 3-4: Update docs   │
│ Day 5: Lessons learned │
└────────────────────────┘
         ↓
WEEK 4: DEPLOY
┌────────────────────────┐
│ Day 1: Add to workflow │
│ Day 2-3: Train team    │
│ Day 4-5: Full rollout  │
└────────────────────────┘
         ↓
✅ DEPLOYED & OPERATIONAL
```

---

## 🎓 Training Paths

```
QUICK LEARNING (5 min)
  ↓
Read: QUICK_REFERENCE.md
Learn: Grounding level basics
Do: Score 1 sample task
Result: Can use DECISION_MATRIX.md
  ↓
STANDARD LEARNING (20 min)
  ↓
Read: README.md + VALIDATION_CHECKLIST.md
Learn: Full review process
Do: Review 1 sample report
Result: Can review tasks independently
  ↓
DEEP LEARNING (1-2 hours)
  ↓
Read: All documents
Learn: Framework design, integration
Do: Customize for your project
Result: Can design/deploy your own version
```

---

## ✨ Summary: Why This Matters

```
WITHOUT VALIDATION:
tasks.md
  ├─ Some tasks grounded ✅
  ├─ Some tasks assumed ❓
  └─ Some tasks invented ❌

  Result: Scope surprises mid-implementation
  Impact: +10-15% rework, team confusion

WITH VALIDATION:
tasks.md
  ├─ All tasks verified against artifacts ✅
  ├─ Evidence clear for each task ✅
  ├─ Gaps identified before implementation ✅
  └─ Decision gate: Approve/Clarify/Block ✅

  Result: Clear scope from start
  Impact: -10-15% rework, confident execution
```

---

**All diagrams are ASCII-based for easy copying into documentation**
