# VS Code Documentation TOC

## Setup
- [Overview](https://code.visualstudio.com/docs/setup/setup-overview)
- [Linux](https://code.visualstudio.com/docs/setup/linux)
- [macOS](https://code.visualstudio.com/docs/setup/mac)
- [Windows](https://code.visualstudio.com/docs/setup/windows)
- [VS Code for the Web](https://code.visualstudio.com/docs/setup/vscode-web)
- [Raspberry Pi](https://code.visualstudio.com/docs/setup/raspberry-pi)
- [Network](https://code.visualstudio.com/docs/setup/network)
- [Additional Components](https://code.visualstudio.com/docs/setup/additional-components)
- [Enterprise](https://code.visualstudio.com/docs/setup/enterprise)
- [Uninstall](https://code.visualstudio.com/docs/setup/uninstall)

## Get Started
- [VS Code Tutorial](https://code.visualstudio.com/docs/getstarted/getting-started)
- [Copilot Quickstart](https://code.visualstudio.com/docs/getstarted/copilot-quickstart)
- [User Interface](https://code.visualstudio.com/docs/getstarted/userinterface)
- [Personalize VS Code](https://code.visualstudio.com/docs/getstarted/personalize-vscode)
- [Install Extensions](https://code.visualstudio.com/docs/getstarted/extensions)
- [Tips and Tricks](https://code.visualstudio.com/docs/getstarted/tips-and-tricks)
- [Intro Videos](https://code.visualstudio.com/docs/getstarted/introvideos)

## Configure
- [Display Language](https://code.visualstudio.com/docs/configure/locales)
- [Layout](https://code.visualstudio.com/docs/configure/custom-layout)
- [Keyboard Shortcuts](https://code.visualstudio.com/docs/configure/keybindings)
- [Settings](https://code.visualstudio.com/docs/configure/settings)
- [Settings Sync](https://code.visualstudio.com/docs/configure/settings-sync)
## Extensions
  - [Extension Marketplace](https://code.visualstudio.com/docs/configure/extensions/extension-marketplace)
  - [Extension Runtime Security](https://code.visualstudio.com/docs/configure/extensions/extension-runtime-security)
- [Themes](https://code.visualstudio.com/docs/configure/themes)
- [Profiles](https://code.visualstudio.com/docs/configure/profiles)
## Accessibility
  - [Overview](https://code.visualstudio.com/docs/configure/accessibility/accessibility)
  - [Voice Interactions](https://code.visualstudio.com/docs/configure/accessibility/voice)
- [Command Line Interface](https://code.visualstudio.com/docs/configure/command-line)
- [Telemetry](https://code.visualstudio.com/docs/configure/telemetry)

## Edit code
- [Basic Editing](https://code.visualstudio.com/docs/editing/codebasics)
- [IntelliSense](https://code.visualstudio.com/docs/editing/intellisense)
- [Code Navigation](https://code.visualstudio.com/docs/editing/editingevolved)
- [Refactoring](https://code.visualstudio.com/docs/editing/refactoring)
- [Snippets](https://code.visualstudio.com/docs/editing/userdefinedsnippets)
## Workspaces
  - [Overview](https://code.visualstudio.com/docs/editing/workspaces/workspaces)
  - [Multi-root Workspaces](https://code.visualstudio.com/docs/editing/workspaces/multi-root-workspaces)
  - [Workspace Trust](https://code.visualstudio.com/docs/editing/workspaces/workspace-trust)

## Build, Debug, Test
- [Tasks](https://code.visualstudio.com/docs/debugtest/tasks)
- [Debugging](https://code.visualstudio.com/docs/debugtest/debugging)
- [Debug Configuration](https://code.visualstudio.com/docs/debugtest/debugging-configuration)
- [Testing](https://code.visualstudio.com/docs/debugtest/testing)
- [Port Forwarding](https://code.visualstudio.com/docs/debugtest/port-forwarding)

## GitHub Copilot
- [Overview](https://code.visualstudio.com/docs/copilot/overview)
- [Setup](https://code.visualstudio.com/docs/copilot/setup)
- [Quickstart](https://code.visualstudio.com/docs/copilot/getting-started)
## Chat
  - [Overview](https://code.visualstudio.com/docs/copilot/chat/copilot-chat)
  - [Chat Sessions](https://code.visualstudio.com/docs/copilot/chat/chat-sessions)
  - [Add Context](https://code.visualstudio.com/docs/copilot/chat/copilot-chat-context)
  - [Review Edits](https://code.visualstudio.com/docs/copilot/chat/review-code-edits)
  - [Planning](https://code.visualstudio.com/docs/copilot/chat/chat-planning)
  - [Checkpoints](https://code.visualstudio.com/docs/copilot/chat/chat-checkpoints)
  - [Tools](https://code.visualstudio.com/docs/copilot/chat/chat-tools)
  - [Inline Chat](https://code.visualstudio.com/docs/copilot/chat/inline-chat)
  - [Prompt Examples](https://code.visualstudio.com/docs/copilot/chat/prompt-examples)
  - [Chat Debug View](https://code.visualstudio.com/docs/copilot/chat/chat-debug-view)
## Agents
  - [Overview](https://code.visualstudio.com/docs/copilot/agents/overview)
  - [Background Agents](https://code.visualstudio.com/docs/copilot/agents/background-agents)
  - [Cloud Agents](https://code.visualstudio.com/docs/copilot/agents/cloud-agents)
- [Inline Suggestions](https://code.visualstudio.com/docs/copilot/ai-powered-suggestions)
## Customization
  - [Overview](https://code.visualstudio.com/docs/copilot/customization/overview)
  - [Instructions](https://code.visualstudio.com/docs/copilot/customization/custom-instructions)
  - [Prompt Files](https://code.visualstudio.com/docs/copilot/customization/prompt-files)
  - [Custom Agents](https://code.visualstudio.com/docs/copilot/customization/custom-agents)
  - [Language Models](https://code.visualstudio.com/docs/copilot/customization/language-models)
  - [MCP](https://code.visualstudio.com/docs/copilot/customization/mcp-servers)
## Guides
  - [Prompt Engineering](https://code.visualstudio.com/docs/copilot/guides/prompt-engineering-guide)
  - [Context Engineering](https://code.visualstudio.com/docs/copilot/guides/context-engineering-guide)
  - [Edit Notebooks with AI](https://code.visualstudio.com/docs/copilot/guides/notebooks-with-ai)
  - [Test with AI](https://code.visualstudio.com/docs/copilot/guides/test-with-copilot)
  - [Debug with AI](https://code.visualstudio.com/docs/copilot/guides/debug-with-copilot)
  - [MCP Dev Guide](https://code.visualstudio.com/docs/copilot/guides/mcp-developer-guide)
- [Smart Actions](https://code.visualstudio.com/docs/copilot/copilot-smart-actions)
- [Tips and Tricks](https://code.visualstudio.com/docs/copilot/copilot-tips-and-tricks)
- [Security](https://code.visualstudio.com/docs/copilot/security)
- [FAQ](https://code.visualstudio.com/docs/copilot/faq)
## Reference
  - [Cheat Sheet](https://code.visualstudio.com/docs/copilot/reference/copilot-vscode-features)
  - [Settings Reference](https://code.visualstudio.com/docs/copilot/reference/copilot-settings)
  - [Workspace Context](https://code.visualstudio.com/docs/copilot/reference/workspace-context)

## Source Control
- [Overview](https://code.visualstudio.com/docs/sourcecontrol/overview)
- [Quickstart](https://code.visualstudio.com/docs/sourcecontrol/quickstart)
- [Staging & Committing](https://code.visualstudio.com/docs/sourcecontrol/staging-commits)
- [Branches & Worktrees](https://code.visualstudio.com/docs/sourcecontrol/branches-worktrees)
- [Repositories & Remotes](https://code.visualstudio.com/docs/sourcecontrol/repos-remotes)
- [Merge Conflicts](https://code.visualstudio.com/docs/sourcecontrol/merge-conflicts)
- [Collaborate on GitHub](https://code.visualstudio.com/docs/sourcecontrol/github)
- [Troubleshooting](https://code.visualstudio.com/docs/sourcecontrol/troubleshooting)
- [FAQ](https://code.visualstudio.com/docs/sourcecontrol/faq)

## Terminal
- [Getting Started Tutorial](https://code.visualstudio.com/docs/terminal/getting-started)
- [Terminal Basics](https://code.visualstudio.com/docs/terminal/basics)
- [Terminal Profiles](https://code.visualstudio.com/docs/terminal/profiles)
- [Shell Integration](https://code.visualstudio.com/docs/terminal/shell-integration)
- [Appearance](https://code.visualstudio.com/docs/terminal/appearance)
- [Advanced](https://code.visualstudio.com/docs/terminal/advanced)

## Languages
- [Overview](https://code.visualstudio.com/docs/languages/overview)
- [JavaScript](https://code.visualstudio.com/docs/languages/javascript)
- [JSON](https://code.visualstudio.com/docs/languages/json)
- [HTML](https://code.visualstudio.com/docs/languages/html)
- [Emmet](https://code.visualstudio.com/docs/languages/emmet)
- [CSS, SCSS and Less](https://code.visualstudio.com/docs/languages/css)
- [TypeScript](https://code.visualstudio.com/docs/languages/typescript)
- [Markdown](https://code.visualstudio.com/docs/languages/markdown)
- [PowerShell](https://code.visualstudio.com/docs/languages/powershell)
- [C++](https://code.visualstudio.com/docs/languages/cpp)
- [Java](https://code.visualstudio.com/docs/languages/java)
- [PHP](https://code.visualstudio.com/docs/languages/php)
- [Python](https://code.visualstudio.com/docs/languages/python)
- [Julia](https://code.visualstudio.com/docs/languages/julia)
- [R](https://code.visualstudio.com/docs/languages/r)
- [Ruby](https://code.visualstudio.com/docs/languages/ruby)
- [Rust](https://code.visualstudio.com/docs/languages/rust)
- [Go](https://code.visualstudio.com/docs/languages/go)
- [T-SQL](https://code.visualstudio.com/docs/languages/tsql)
- [C#](https://code.visualstudio.com/docs/languages/csharp)
- [.NET](https://code.visualstudio.com/docs/languages/dotnet)
- [Polyglot](https://code.visualstudio.com/docs/languages/polyglot)
- [Swift](https://code.visualstudio.com/docs/languages/swift)

## Node.js / JavaScript
- [Working with JavaScript](https://code.visualstudio.com/docs/nodejs/working-with-javascript)
- [Node.js Tutorial](https://code.visualstudio.com/docs/nodejs/nodejs-tutorial)
- [Node.js Debugging](https://code.visualstudio.com/docs/nodejs/nodejs-debugging)
- [Deploy Node.js Apps](https://code.visualstudio.com/docs/nodejs/nodejs-deployment)
- [Browser Debugging](https://code.visualstudio.com/docs/nodejs/browser-debugging)
- [Angular Tutorial](https://code.visualstudio.com/docs/nodejs/angular-tutorial)
- [React Tutorial](https://code.visualstudio.com/docs/nodejs/reactjs-tutorial)
- [Vue Tutorial](https://code.visualstudio.com/docs/nodejs/vuejs-tutorial)
- [Debugging Recipes](https://code.visualstudio.com/docs/nodejs/debugging-recipes)
- [Performance Profiling](https://code.visualstudio.com/docs/nodejs/profiling)
- [Extensions](https://code.visualstudio.com/docs/nodejs/extensions)

## TypeScript
- [Tutorial](https://code.visualstudio.com/docs/typescript/typescript-tutorial)
- [Compiling](https://code.visualstudio.com/docs/typescript/typescript-compiling)
- [Editing](https://code.visualstudio.com/docs/typescript/typescript-editing)
- [Refactoring](https://code.visualstudio.com/docs/typescript/typescript-refactoring)
- [Debugging](https://code.visualstudio.com/docs/typescript/typescript-debugging)

## Python
- [Quick Start](https://code.visualstudio.com/docs/python/python-quick-start)
- [Tutorial](https://code.visualstudio.com/docs/python/python-tutorial)
- [Run Python Code](https://code.visualstudio.com/docs/python/run)
- [Editing](https://code.visualstudio.com/docs/python/editing)
- [Linting](https://code.visualstudio.com/docs/python/linting)
- [Formatting](https://code.visualstudio.com/docs/python/formatting)
- [Debugging](https://code.visualstudio.com/docs/python/debugging)
- [Environments](https://code.visualstudio.com/docs/python/environments)
- [Testing](https://code.visualstudio.com/docs/python/testing)
- [Python Interactive](https://code.visualstudio.com/docs/python/jupyter-support-py)
- [Django Tutorial](https://code.visualstudio.com/docs/python/tutorial-django)
- [FastAPI Tutorial](https://code.visualstudio.com/docs/python/tutorial-fastapi)
- [Flask Tutorial](https://code.visualstudio.com/docs/python/tutorial-flask)
- [Create Containers](https://code.visualstudio.com/docs/python/tutorial-create-containers)
- [Deploy Python Apps](https://code.visualstudio.com/docs/python/python-on-azure)
- [Python in the Web](https://code.visualstudio.com/docs/python/python-web)
- [Settings Reference](https://code.visualstudio.com/docs/python/settings-reference)

## Java
- [Getting Started](https://code.visualstudio.com/docs/java/java-tutorial)
- [Navigate and Edit](https://code.visualstudio.com/docs/java/java-editing)
- [Refactoring](https://code.visualstudio.com/docs/java/java-refactoring)
- [Formatting and Linting](https://code.visualstudio.com/docs/java/java-linting)
- [Project Management](https://code.visualstudio.com/docs/java/java-project)
- [Build Tools](https://code.visualstudio.com/docs/java/java-build)
- [Run and Debug](https://code.visualstudio.com/docs/java/java-debugging)
- [Testing](https://code.visualstudio.com/docs/java/java-testing)
- [Spring Boot](https://code.visualstudio.com/docs/java/java-spring-boot)
- [Modernizing Java Apps](https://code.visualstudio.com/docs/java/java-app-mod)
- [Application Servers](https://code.visualstudio.com/docs/java/java-tomcat-jetty)
- [Deploy Java Apps](https://code.visualstudio.com/docs/java/java-on-azure)
- [GUI Applications](https://code.visualstudio.com/docs/java/java-gui)
- [Extensions](https://code.visualstudio.com/docs/java/extensions)
- [FAQ](https://code.visualstudio.com/docs/java/java-faq)

## C++
- [Intro Videos](https://code.visualstudio.com/docs/cpp/introvideos-cpp)
- [GCC on Linux](https://code.visualstudio.com/docs/cpp/config-linux)
- [GCC on Windows](https://code.visualstudio.com/docs/cpp/config-mingw)
- [GCC on Windows Subsystem for Linux](https://code.visualstudio.com/docs/cpp/config-wsl)
- [Clang on macOS](https://code.visualstudio.com/docs/cpp/config-clang-mac)
- [Microsoft C++ on Windows](https://code.visualstudio.com/docs/cpp/config-msvc)
- [Build with CMake](https://code.visualstudio.com/docs/cpp/build-with-cmake)
- [CMake Tools on Linux](https://code.visualstudio.com/docs/cpp/cmake-linux)
- [CMake Quick Start](https://code.visualstudio.com/docs/cpp/cmake-quickstart)
- [Editing and Navigating](https://code.visualstudio.com/docs/cpp/cpp-ide)
- [Debugging](https://code.visualstudio.com/docs/cpp/cpp-debug)
- [Configure Debugging](https://code.visualstudio.com/docs/cpp/launch-json-reference)
- [Refactoring](https://code.visualstudio.com/docs/cpp/cpp-refactoring)
- [Settings Reference](https://code.visualstudio.com/docs/cpp/customize-cpp-settings)
- [Configure IntelliSense](https://code.visualstudio.com/docs/cpp/configure-intellisense)
- [Configure IntelliSense for Cross-Compiling](https://code.visualstudio.com/docs/cpp/configure-intellisense-crosscompilation)
- [FAQ](https://code.visualstudio.com/docs/cpp/faq-cpp)

## C#
- [Intro Videos](https://code.visualstudio.com/docs/csharp/introvideos-csharp)
- [Get Started](https://code.visualstudio.com/docs/csharp/get-started)
- [Navigate and Edit](https://code.visualstudio.com/docs/csharp/navigate-edit)
- [IntelliCode](https://code.visualstudio.com/docs/csharp/intellicode)
- [Refactoring](https://code.visualstudio.com/docs/csharp/refactoring)
- [Formatting and Linting](https://code.visualstudio.com/docs/csharp/formatting-linting)
- [Project Management](https://code.visualstudio.com/docs/csharp/project-management)
- [Build Tools](https://code.visualstudio.com/docs/csharp/build-tools)
- [Package Management](https://code.visualstudio.com/docs/csharp/package-management)
- [Run and Debug](https://code.visualstudio.com/docs/csharp/debugging)
- [Testing](https://code.visualstudio.com/docs/csharp/testing)
- [FAQ](https://code.visualstudio.com/docs/csharp/cs-dev-kit-faq)

## Container Tools
- [Overview](https://code.visualstudio.com/docs/containers/overview)
- [Node.js](https://code.visualstudio.com/docs/containers/quickstart-node)
- [Python](https://code.visualstudio.com/docs/containers/quickstart-python)
- [ASP.NET Core](https://code.visualstudio.com/docs/containers/quickstart-aspnet-core)
- [Debug](https://code.visualstudio.com/docs/containers/debug-common)
- [Docker Compose](https://code.visualstudio.com/docs/containers/docker-compose)
- [Registries](https://code.visualstudio.com/docs/containers/quickstart-container-registries)
- [Deploy to Azure](https://code.visualstudio.com/docs/containers/app-service)
- [Choose a Dev Environment](https://code.visualstudio.com/docs/containers/choosing-dev-environment)
- [Customize](https://code.visualstudio.com/docs/containers/reference)
- [Develop with Kubernetes](https://code.visualstudio.com/docs/containers/bridge-to-kubernetes)
- [Tips and Tricks](https://code.visualstudio.com/docs/containers/troubleshooting)

## Data Science
- [Overview](https://code.visualstudio.com/docs/datascience/overview)
- [Jupyter Notebooks](https://code.visualstudio.com/docs/datascience/jupyter-notebooks)
- [Data Science Tutorial](https://code.visualstudio.com/docs/datascience/data-science-tutorial)
- [Python Interactive](https://code.visualstudio.com/docs/datascience/python-interactive)
- [Data Wrangler Quick Start](https://code.visualstudio.com/docs/datascience/data-wrangler-quick-start)
- [Data Wrangler](https://code.visualstudio.com/docs/datascience/data-wrangler)
- [PyTorch Support](https://code.visualstudio.com/docs/datascience/pytorch-support)
- [Azure Machine Learning](https://code.visualstudio.com/docs/datascience/azure-machine-learning)
- [Manage Jupyter Kernels](https://code.visualstudio.com/docs/datascience/jupyter-kernel-management)
- [Jupyter Notebooks on the Web](https://code.visualstudio.com/docs/datascience/notebooks-web)
- [Data science in Microsoft Fabric](https://code.visualstudio.com/docs/datascience/microsoft-fabric-quickstart)

## Intelligent Apps
- [AI Toolkit Overview](https://code.visualstudio.com/docs/intelligentapps/overview)
- [AI Toolkit Copilot tools](https://code.visualstudio.com/docs/intelligentapps/copilot-tools)
- [Models](https://code.visualstudio.com/docs/intelligentapps/models)
- [Playground](https://code.visualstudio.com/docs/intelligentapps/playground)
- [Agent Builder](https://code.visualstudio.com/docs/intelligentapps/agentbuilder)
- [Bulk Run](https://code.visualstudio.com/docs/intelligentapps/bulkrun)
- [Evaluation](https://code.visualstudio.com/docs/intelligentapps/evaluation)
- [Fine-tuning (Automated Setup)](https://code.visualstudio.com/docs/intelligentapps/finetune)
- [Fine-tuning (Project Template)](https://code.visualstudio.com/docs/intelligentapps/finetune-legacy)
- [Model Conversion](https://code.visualstudio.com/docs/intelligentapps/modelconversion)
- [Tracing](https://code.visualstudio.com/docs/intelligentapps/tracing)
- [FAQ](https://code.visualstudio.com/docs/intelligentapps/faq)
## Reference
  - [File Structure](https://code.visualstudio.com/docs/intelligentapps/reference/FileStructure)
  - [Manual Model Conversion](https://code.visualstudio.com/docs/intelligentapps/reference/ManualModelConversion)
  - [Manual Model Conversion On GPU](https://code.visualstudio.com/docs/intelligentapps/reference/ManualConversionOnGPU)
  - [Setup Environment Without AI Toolkit](https://code.visualstudio.com/docs/intelligentapps/reference/SetupWithoutAITK)
  - [Template Project](https://code.visualstudio.com/docs/intelligentapps/reference/TemplateProject)

## Azure
- [Overview](https://code.visualstudio.com/docs/azure/overview)
- [Getting Started](https://code.visualstudio.com/docs/azure/gettingstarted)
- [Resources View](https://code.visualstudio.com/docs/azure/resourcesextension)
- [Deployment](https://code.visualstudio.com/docs/azure/deployment)
- [VS Code for the Web - Azure](https://code.visualstudio.com/docs/azure/vscodeforweb)
- [Containers](https://code.visualstudio.com/docs/azure/containers)
- [Azure Kubernetes Service](https://code.visualstudio.com/docs/azure/aksextensions)
- [Kubernetes](https://code.visualstudio.com/docs/azure/kubernetes)
- [MongoDB](https://code.visualstudio.com/docs/azure/mongodb)
- [Remote Debugging for Node.js](https://code.visualstudio.com/docs/azure/remote-debugging)

## Remote
- [Overview](https://code.visualstudio.com/docs/remote/remote-overview)
- [SSH](https://code.visualstudio.com/docs/remote/ssh)
- [Dev Containers](https://code.visualstudio.com/docs/remote/dev-containers)
- [Windows Subsystem for Linux](https://code.visualstudio.com/docs/remote/wsl)
- [GitHub Codespaces](https://code.visualstudio.com/docs/remote/codespaces)
- [VS Code Server](https://code.visualstudio.com/docs/remote/vscode-server)
- [Tunnels](https://code.visualstudio.com/docs/remote/tunnels)
- [SSH Tutorial](https://code.visualstudio.com/docs/remote/ssh-tutorial)
- [WSL Tutorial](https://code.visualstudio.com/docs/remote/wsl-tutorial)
- [Tips and Tricks](https://code.visualstudio.com/docs/remote/troubleshooting)
- [FAQ](https://code.visualstudio.com/docs/remote/faq)

## Dev Containers
- [Overview](https://code.visualstudio.com/docs/devcontainers/containers)
- [Tutorial](https://code.visualstudio.com/docs/devcontainers/tutorial)
- [Attach to Container](https://code.visualstudio.com/docs/devcontainers/attach-container)
- [Create Dev Container](https://code.visualstudio.com/docs/devcontainers/create-dev-container)
- [Advanced Containers](https://code.visualstudio.com/docs/devcontainers/containers-advanced)
- [devcontainer.json](https://code.visualstudio.com/docs/devcontainers/devcontainerjson-reference)
- [Dev Container CLI](https://code.visualstudio.com/docs/devcontainers/devcontainer-cli)
- [Tips and Tricks](https://code.visualstudio.com/docs/devcontainers/tips-and-tricks)
- [FAQ](https://code.visualstudio.com/docs/devcontainers/faq)

## Reference
- [Default Keyboard Shortcuts](https://code.visualstudio.com/docs/reference/default-keybindings)
- [Default Settings](https://code.visualstudio.com/docs/reference/default-settings)
- [Substitution Variables](https://code.visualstudio.com/docs/reference/variables-reference)
- [Tasks Schema](https://code.visualstudio.com/docs/reference/tasks-appendix)
