# Clean Code Principles

Fundamental software design principles for writing maintainable, scalable code.

## Overview

This skill provides guidance for:
- SOLID principles
- Core principles (DRY, KISS, YAGNI)
- Design patterns
- Code organization
- Naming conventions
- Function design

## Categories

### 1. SOLID Principles (Critical)
Single Responsibility, Open/Closed, Liskov Substitution, Interface Segregation, Dependency Inversion.

### 2. Core Principles (Critical)
DRY, KISS, YAGNI, Separation of Concerns, Composition over Inheritance.

### 3. Design Patterns (High)
Factory, Strategy, Repository, Decorator, Observer, Adapter, Facade.

### 4. Code Organization (High)
Feature folders, module boundaries, layered architecture.

### 5. Naming & Readability (Medium)
Meaningful names, consistent conventions, no magic numbers.

### 6. Functions & Methods (Medium)
Small functions, single purpose, limited parameters.

## Usage

Ask Claude to:
- "Review architecture"
- "Check SOLID principles"
- "Suggest design patterns"
- "Review code quality"

## Key Principles

### SOLID
- **S**ingle Responsibility - One reason to change
- **O**pen/Closed - Open for extension, closed for modification
- **L**iskov Substitution - Subtypes must be substitutable
- **I**nterface Segregation - Small, focused interfaces
- **D**ependency Inversion - Depend on abstractions

### Core
- **DRY** - Don't Repeat Yourself
- **KISS** - Keep It Simple
- **YAGNI** - You Aren't Gonna Need It

## References

- Clean Code by Robert C. Martin
- Design Patterns by Gang of Four
- Refactoring by Martin Fowler
