# Git Workflow

Git best practices, commit conventions, and branching strategies for clean, maintainable repositories.

## Overview

This skill provides guidance for:
- Commit message conventions
- Branch naming and management
- Pull request workflows
- History management
- Team collaboration

## Categories

### 1. Commit Messages (Critical)
Conventional commits, atomic changes, meaningful messages.

### 2. Branching Strategy (High)
Branch naming, feature branches, protected main.

### 3. Pull Requests (High)
Small PRs, descriptions, reviews, CI.

### 4. History Management (Medium)
Rebase vs merge, clean history, tags.

### 5. Collaboration (Medium)
Code reviews, conflict resolution.

## Usage

Ask Claude to:
- "Review commit message"
- "Suggest branch name"
- "Check PR description"
- "Review git workflow"

## Quick Reference

### Commit Types
- `feat`: New feature
- `fix`: Bug fix
- `docs`: Documentation
- `refactor`: Code restructure
- `test`: Tests
- `chore`: Maintenance

### Branch Prefixes
- `feature/`: New features
- `fix/`: Bug fixes
- `hotfix/`: Production fixes
- `docs/`: Documentation
- `refactor/`: Refactoring

### Example Commits
```
feat(auth): add OAuth login
fix(cart): resolve total calculation
docs(api): update endpoint documentation
```

## References

- [Conventional Commits](https://www.conventionalcommits.org/)
- [Git Flow](https://nvie.com/posts/a-successful-git-branching-model/)
- [GitHub Flow](https://guides.github.com/introduction/flow/)
