# Sections

This file defines all sections, their ordering, impact levels, and descriptions.
The section ID (in parentheses) is the filename prefix used to group rules.

---

## 1. Type System (type)

**Impact:** CRITICAL
**Description:** Strict type enforcement is the foundation of reliable PHP code. Type declarations prevent bugs, enable static analysis, and provide self-documenting contracts. Essential for modern PHP 8.x development.

## 2. Modern Features (modern)

**Impact:** CRITICAL
**Description:** PHP 8.x features like constructor promotion, enums, readonly properties, and match expressions drastically reduce boilerplate and improve code clarity. These are not optional—they're the modern PHP standard.

## 3. PSR Standards (psr)

**Impact:** HIGH
**Description:** PHP-FIG standards (PSR-4 autoloading, PSR-12 coding style, naming conventions) ensure code interoperability and maintainability. Following PSR standards is expected in professional PHP development.

## 4. SOLID Principles (solid)

**Impact:** HIGH
**Description:** SOLID principles (Single Responsibility, Open/Closed, Liskov Substitution, Interface Segregation, Dependency Inversion) create maintainable, testable, and flexible code architectures.

## 5. Error Handling (error)

**Impact:** HIGH
**Description:** Proper exception handling, custom exceptions, and error recovery strategies prevent silent failures and enable graceful error management.

## 6. Performance (perf)

**Impact:** MEDIUM
**Description:** Performance optimizations like lazy loading, generators, and avoiding globals improve application scalability and resource usage.

## 7. Security (sec)

**Impact:** CRITICAL
**Description:** Security practices including input validation, output escaping, password hashing, and prepared statements protect against common vulnerabilities and attacks.
