---
title: Rule Title Here
impact: MEDIUM
impactDescription: Brief description of impact (e.g., "Reduces bugs by 50%")
tags: category, subtopic, php-version
---

## Rule Title Here

**Impact: MEDIUM (optional impact description)**

Brief explanation of the rule and why it matters. This should be clear and concise, explaining the benefits and rationale.

**Incorrect (description of what's wrong):**

```php
<?php

declare(strict_types=1);

// Bad code example here
// Show common anti-patterns
class BadExample
{
    // Demonstrate the problem
}
```

**Correct (description of what's right):**

```php
<?php

declare(strict_types=1);

// Good code example here
// Show best practices
class GoodExample
{
    // Demonstrate the solution
}
```

## Why

- **Benefit 1**: Explanation of first major benefit
- **Benefit 2**: Explanation of second benefit
- **Benefit 3**: Explanation of third benefit
- **PHP Version**: Specify PHP version requirement if applicable

Reference: [PHP Documentation](https://www.php.net/manual/en/) | [PSR Standards](https://www.php-fig.org/psr/)
