---
title: [Rule Title]
category: [Component Typing | Hook Typing | Event Handling | Ref Typing | Generic Components | Context & State | Utility Types]
priority: [CRITICAL | HIGH | MEDIUM | LOW]
---

# [rule-name]

## Why It Matters

[Brief explanation of why this pattern is important. Focus on:
- What problem it solves
- What errors it prevents
- When you need this pattern]

## Incorrect

```typescript
// ❌ [Brief description of what's wrong]
[Bad code example showing the anti-pattern]

// ❌ [Another common mistake]
[Another bad example]
```

**Why this is problematic:**
- [Specific issue 1]
- [Specific issue 2]
- [What errors this causes]

## Correct

```typescript
// ✅ [Description of the correct approach]
[Good code example]

// ✅ [Alternative correct approach if applicable]
[Another good example]
```

**Why this works:**
- [Benefit 1]
- [Benefit 2]
- [Type safety gained]

## Additional Examples

### [Specific Use Case 1]

```typescript
// Context for when to use this variation
[Code example with explanation]
```

### [Specific Use Case 2]

```typescript
// Context for this pattern
[Code example with explanation]
```

## Common Patterns

```typescript
// [Pattern name 1]
[Concise example]

// [Pattern name 2]
[Concise example]
```

## Tips

- [Quick tip 1]
- [Common mistake to avoid]
- [Performance consideration if applicable]
- [When NOT to use this pattern]

## Related

- See `[related-rule-1.md]` for [related concept]
- See `[related-rule-2.md]` for [related concept]

---

**Template Notes (remove these when creating actual rules):**

1. **Title**: Use clear, descriptive titles that match the file name
2. **Category**: Must match one of the 7 defined categories
3. **Priority**:
   - CRITICAL: Fundamental patterns every project needs
   - HIGH: Common patterns most projects use
   - MEDIUM: Advanced patterns for specific needs
   - LOW: Specialized edge cases
4. **Code Examples**:
   - Use ✅ for correct examples
   - Use ❌ for incorrect examples
   - Include inline comments explaining key points
   - Show both the problem and solution
5. **Focus on TypeScript + React**:
   - Emphasize type safety
   - Show how types flow through the code
   - Include actual type annotations
   - Show IDE autocomplete benefits
6. **Be Concise**: Each rule should be scannable in 2-3 minutes
7. **Show Real Examples**: Use realistic code, not foo/bar placeholders
