---
name: paul-graham-wisdom
description: Apply Paul Graham's principles when exploring ideas, evaluating opportunities, building products, or making important decisions. Use this skill when brainstorming, validating ideas, planning ventures, thinking through problems, or needing a framework for clear thinking. Triggers include "evaluate this idea", "should I pursue this", "help me think through", "is this worth doing", "startup idea", "opportunity analysis", or any creative/strategic thinking task.
---

# Paul Graham Wisdom

Apply these principles when exploring ideas, validating opportunities, or making decisions.

## The Idea Evaluation Framework

### Is This a Real Problem?

1. **Live in the future, then build what's missing** - The best ideas emerge from being at the edge of a field and noticing gaps
2. **Look for problems, not ideas** - Start with genuine pain points you experience, not abstract brainstorming
3. **The schlep test** - If you unconsciously avoid an idea because it involves tedious work, that's often where the opportunity lies. Ask: "What problem do I wish someone else would solve?"
4. **Depth over breadth** - Acute needs for a small group beat mild needs for many. Microsoft started with just a couple thousand Altair owners who desperately needed software
5. **The "toy" signal** - If critics dismiss something as a "toy," it may have everything except scale. Microcomputers, search engines, and Facebook were all called toys

### Is This Worth Pursuing?

1. **The Bus Ticket Theory** - Great work requires disinterested obsession with a topic that matters. Pursue what you'd pursue even without external rewards
2. **The spare time test** - Would you work on this during free time while supporting yourself another way?
3. **What doesn't seem like work?** - Your genuine interests reveal what you should pursue
4. **Curiosity as compass** - Pursue what you're excessively curious about. Curiosity is the ultimate guide

### Am I the Right Person?

1. **Three ingredients** - Natural ability + determination + obsessive interest in the topic
2. **The intersection advantage** - Combining expertise across different fields reveals problems one domain hasn't solved
3. **Become the expert** - Know your domain thoroughly. Surface-level knowledge gets exposed immediately
4. **Youth advantages** - Fresh eyes, freedom from conventional assumptions, understanding of emerging behaviors

## The Thinking Framework

### How to Think Independently

1. **Fastidiousness about truth** - Carefully calibrate your degree of belief rather than rushing to extremes
2. **Resistance to being told what to think** - A positive force, not merely immunity to convention
3. **Curiosity** - The primary source of novel ideas. Indulging it increases rather than satisfies it
4. **Keep your identity small** - The fewer labels you claim, the better your reasoning. Identity impairs clear thinking
5. **Question the status quo** - Challenge what you take for granted. Ask "Is that true?" about every claim

### Avoiding Mental Traps

1. **The top idea in your mind** - Your shower thoughts reveal what actually occupies you. Guard what becomes your dominant idea
2. **Disputes are toxic** - Controversies crowd out substantive work. Avoid them
3. **Don't hack tests** - Optimize for genuine quality, not proxies. The lesson to unlearn from school
4. **Schlep blindness** - Your unconscious filters out ideas involving difficult work before you consciously evaluate them
5. **The unsexy filter** - Similar to schlep blindness, but for problems you find distasteful

### Productive Thinking Practices

1. **Good procrastination** - Postpone small stuff to focus on work with obituary potential. Let delight pull you forward
2. **Maker's schedule** - Creative work requires half-day minimum blocks. A single meeting can destroy an afternoon
3. **Write to think** - There is a kind of thinking that only happens through writing
4. **Carry unanswered questions** - They seed future discoveries through background processing

## The Execution Framework

### Getting Started

1. **Begin with the simplest thing that could possibly work** - Start small and evolve through successive versions
2. **Do things that don't scale** - Manually recruit users, provide extreme customer attention, solve problems by hand
3. **Early work looks unimpressive** - Great projects pass through an embarrassing phase. Push through
4. **Being a noob is good** - The discomfort of inexperience correlates with learning novel things

### Building and Iterating

1. **Growth as compass** - Measure weekly growth rates. 5-7% weekly is a good benchmark
2. **Get initial versions to audiences quickly** - Users are the only real proof you've created value
3. **Iterate relentlessly** - When nothing works, tweak and try again. Every viable market has winning permutations
4. **Compound advantage** - Small daily progress compounds exponentially. Consistency matters more than volume

### The Work Ethic

1. **Determination over intelligence** - The strongest predictor of success. Willfulness + discipline + ambition
2. **Relentlessly resourceful** - Actively shape outcomes rather than accepting them. Adapt mid-play like a running back
3. **Balance effort types** - Focused work blocks + undirected thinking (walking, showering, resting)
4. **Protect morale** - The basis of everything on ambitious projects. Physical health enables thinking

## The Quality Framework

### Standards for Excellence

1. **Be aggressively willing to admit you're mistaken** - Intellectual honesty enables better work
2. **Aim for 100-year value** - Create work people will value in a century
3. **Formidable is justifiably confident** - Not fake swagger, but conviction from genuine understanding
4. **Earnestness** - Do things for the right reasons while trying as hard as possible

### Communication Standards

1. **Write like you talk** - Would you say this to a friend? Use that as your filter
2. **Write simply** - Simple language makes mistakes obvious and respects readers' time
3. **Correctness with precision** - Make claims as strong as possible without becoming false
4. **Explain to convince yourself first** - If you can't explain it concisely, you don't understand it

## The People Framework

### Who to Work With

1. **Seek the best colleagues** - Quality trumps quantity dramatically. They make the difference between great work and none
2. **Formidable founders** - Investors decide within minutes. Conviction from genuine understanding
3. **Mean people fail** - Meanness makes you stupid, repels talent, and focuses you on fighting instead of creating
4. **Work with people who energize you** - Avoid those who deplete you

### Team Dynamics

1. **Small groups enable measurement** - Individual contributions become visible
2. **2-4 founders ideal** - Quick decisions without factions
3. **Technical founders essential** - For technology ventures, you need builders

## The Environment Framework

### Where You Work

1. **Cities send messages** - Different cities value different types of ambition. Place yourself where your goals are valued
2. **Discouragement outweighs encouragement** - Few can keep working on something no one around them cares about
3. **Geographic clustering drives innovation** - Proximity to peers and shared ambition accelerates achievement

### How to Structure Time

1. **Eliminate distractions** - Don't pursue side projects when building something important
2. **Protect uninterrupted blocks** - Knowledge of upcoming meetings depresses morale
3. **Stay default alive** - Spend as little as possible to extend runway

## The Superlinear Returns Principle

Returns on performance are not linear. In fields with superlinear returns:

1. **A few big winners outperform everyone else** - This includes science, investing, art, startups
2. **Success enables further success** - More knowledge helps you learn faster
3. **Independent-mindedness required** - Your ideas must be correct AND novel
4. **Starting is hard** - Initial efforts yield small visible returns. Push through to where the curve steepens

## Quick Reference: Key Questions

When exploring any idea, ask:

- [ ] **Problem**: Is this a real problem I've experienced, or am I making up a solution?
- [ ] **Obsession**: Would I work on this even without external rewards?
- [ ] **Schlep**: Am I avoiding this because it's hard, or because it's wrong?
- [ ] **Identity**: Am I defending this idea because it's good, or because it's "mine"?
- [ ] **Depth**: Does this solve an acute need for someone, or a mild need for everyone?
- [ ] **Scale path**: Is there a clear expansion from initial users to a larger market?
- [ ] **Conviction**: Can I explain why this works to a skeptical expert?
- [ ] **Energy**: Does working on this energize me or drain me?
- [ ] **100-year test**: Would this still matter in a century?

## Source Essays

For deeper exploration, key essays include:
- "How to Do Great Work" - Comprehensive framework for excellence
- "How to Get Startup Ideas" - Problem-finding methodology
- "Do Things that Don't Scale" - Early-stage execution
- "Schlep Blindness" - Uncovering hidden opportunities
- "How to Think for Yourself" - Independent-mindedness
- "The Bus Ticket Theory of Genius" - On obsessive interest
- "Superlinear Returns" - Why inequality in outcomes
- "Keep Your Identity Small" - Clear thinking
- "Maker's Schedule, Manager's Schedule" - Time management
- "Relentlessly Resourceful" - Founder mindset

All essays available at paulgraham.com/articles.html
