---
name: debug-helper
description: Systematic debugging approach for identifying and fixing issues
---

# Debug Helper

A systematic approach to debugging software issues.

## Investigation Steps
1. Reproduce the issue consistently
2. Isolate the problem area
3. Form a hypothesis
4. Test the hypothesis
5. Apply the fix
6. Verify the solution

## Common Debugging Techniques
- Add logging at critical points
- Use breakpoints and step-through debugging
- Check input/output at boundaries
- Review recent changes in version control
- Compare working vs broken states

## Error Analysis
- Read error messages carefully
- Check stack traces for root cause
- Verify assumptions about data types and values
- Look for off-by-one errors and null references
