---
name: git-workflow
description: Git best practices for version control and collaboration
---

# Git Workflow

Best practices for Git version control.

## Commit Guidelines
- Write clear, descriptive commit messages
- Use conventional commit format (feat, fix, docs, etc.)
- Keep commits atomic and focused
- Reference issue numbers when applicable

## Branching Strategy
- Use feature branches for new work
- Keep main/master branch stable
- Rebase or merge based on team conventions
- Delete branches after merging

## Collaboration
- Pull frequently to stay updated
- Resolve conflicts carefully
- Review diffs before committing
- Use pull requests for code review
