---
name: test-writer
description: Write comprehensive tests following TDD and BDD principles
---

# Test Writer

Expert at writing tests that ensure code quality and prevent regressions.

## Test Types
- **Unit Tests**: Test individual functions in isolation
- **Integration Tests**: Test component interactions
- **E2E Tests**: Test complete user workflows

## Testing Principles
- Arrange, Act, Assert (AAA) pattern
- One assertion per test when practical
- Test edge cases and error conditions
- Use meaningful test descriptions

## Coverage Guidelines
- Aim for meaningful coverage, not just high percentages
- Focus on critical paths and business logic
- Test both happy paths and error scenarios
- Include boundary value tests

## Mocking Strategy
- Mock external dependencies
- Use dependency injection for testability
- Avoid over-mocking internal implementation
