# Status Report Templates

This file provides templates for different report formats based on audience and context.

## Executive Summary Format

For delivery managers and executives who need high-level overview:

```markdown
# [Project Name] - Status Report
**Date:** [Date]
**Reporting Period:** [Period]

## Executive Summary
[2-3 sentences summarizing overall status, major accomplishments, and critical blockers]

## Overall Status
🟢 On Track | 🟡 At Risk | 🔴 Blocked | ⚪ Not Started

## Key Metrics
- **Total Issues:** [number]
- **Completed This Period:** [number]
- **In Progress:** [number]
- **Blocked:** [number]

## Highlights
- [Major accomplishment 1]
- [Major accomplishment 2]
- [Major accomplishment 3]

## Critical Blockers
- **[Blocker Title]** - [Brief description and impact]
- **[Blocker Title]** - [Brief description and impact]

## Upcoming Priorities
- [Priority 1]
- [Priority 2]
- [Priority 3]
```

## Detailed Technical Format

For team-level reports with more technical detail:

```markdown
# [Project Name] - Status Report
**Date:** [Date]
**Reporting Period:** [Period]

## Summary
[Overall project status and key takeaways]

## Progress This Period

### Completed
- [Issue Key] - [Summary]
- [Issue Key] - [Summary]

### In Progress
- [Issue Key] - [Summary] ([Assignee], [Priority])
- [Issue Key] - [Summary] ([Assignee], [Priority])

### Blocked
- [Issue Key] - [Summary]
  - **Blocker:** [Description of blocker]
  - **Impact:** [How this affects timeline/deliverables]
  - **Action Needed:** [What needs to happen to unblock]

## Risks and Issues
- [Risk/Issue description with mitigation plan]

## Next Period Priorities
- [Planned work item 1]
- [Planned work item 2]

## Dependencies
- [External dependency description]
```

## Daily Standup Format

For daily status updates:

```markdown
# Daily Status - [Date]
**Project:** [Project Name]

## Completed Yesterday
- [Issue Key] - [Brief summary]

## Planned for Today
- [Issue Key] - [Brief summary]

## Blockers
- [Blocker description] (Assigned to: [name])

## Notes
[Any additional context or observations]
```

## By Priority Breakdown

For priority-focused reporting:

```markdown
# [Project Name] - Status by Priority
**Date:** [Date]

## Highest Priority (P0/Blocker)
- [Issue Key] - [Summary] - Status: [status]

## High Priority (P1/Critical)
- [Issue Key] - [Summary] - Status: [status]

## Medium Priority (P2/Major)
- [Issue Key] - [Summary] - Status: [status]

## Low Priority (P3/Minor)
[Summary count only unless specifically requested]
```
