# YouTube Uploader - Setup Guide

## Prerequisites

- Node.js installed
- Google Cloud account
- YouTube channel

## 1. Create Google Cloud Project

1. Go to [console.cloud.google.com](https://console.cloud.google.com)
2. Create new project or select existing
3. Enable YouTube Data API v3:
   - APIs & Services → Library
   - Search "YouTube Data API v3"
   - Click Enable

## 2. Create OAuth Credentials

1. APIs & Services → Credentials
2. Create Credentials → OAuth client ID
3. Application type: Web application
4. Add authorized redirect URI: `http://localhost:3000/oauth2callback`
5. Download JSON or copy Client ID and Secret

## 3. Configure Environment

```bash
cd ~/.claude/skills/youtube-uploader/scripts
cp .env.example .env
```

Edit `.env`:
```
YOUTUBE_CLIENT_ID=your_client_id
YOUTUBE_CLIENT_SECRET=your_client_secret
YOUTUBE_REDIRECT_URI=http://localhost:3000/oauth2callback
```

## 4. Install Dependencies

```bash
cd ~/.claude/skills/youtube-uploader/scripts
npm install
```

## 5. First-Time Authorization

Run the upload script once - it will:
1. Open browser for Google sign-in
2. Ask for YouTube permissions
3. Save refresh token for future use

```bash
npx ts-node youtube-upload.ts --help
```

## 6. Mark Setup Complete

Edit `SKILL.md` and change:
```yaml
setup_complete: true
```

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Redirect URI mismatch | Check URI matches exactly in Cloud Console |
| API not enabled | Enable YouTube Data API v3 |
| Quota exceeded | Check quota in Cloud Console |
| Access denied | Re-authorize or check channel permissions |
