# Design Feedback Demo: Redesign HTML from Inspiration Image

## Overview

Demonstrates using the ask-gemini skill to redesign actual code. The workflow: provide
Gemini with your current HTML source and a screenshot of a design you admire, then get
back updated production-quality code that moves your page toward that aesthetic.

## Inputs

| File | Description |
|------|-------------|
| `inputs/current-page.html` | A basic, unstyled SaaS landing page (plain white, Arial, flat cards) |
| `inputs/inspiration.png` | A stunning dark-mode design with glassmorphism, gradient accents, and ambient lighting |

## Prompt

```
Here is my current landing page HTML and a screenshot of a design I want to move toward.
Redesign my HTML to match the aesthetic of the inspiration image. Keep the same content
and structure but transform the visual style.

Current HTML:
[contents of current-page.html]

Requirements:
- Dark mode with deep gradient background
- Glassmorphism cards with backdrop-filter blur
- Gradient accent colors (purple/teal/pink)
- Modern typography with generous whitespace
- Luminous gradient CTA button
- Keep it as a single self-contained HTML file with inline styles
- Make it production-quality, not a rough draft

Output ONLY the complete HTML.
```

## Command

```bash
bun run scripts/ask_gemini.ts \
  inputs/inspiration.png \
  "Here is my current landing page HTML and a screenshot of a design I want to move
   toward. Redesign my HTML to match the aesthetic of the inspiration image...
   [full prompt with HTML pasted in]"
```

## Output

See `outputs/updated-page.html` - a complete redesign featuring:
- Deep indigo gradient background with ambient radial lighting
- Sticky glassmorphism navbar with blur backdrop
- Gradient text headlines (white to purple to cyan)
- Luminous purple-to-pink CTA button with glow shadow
- Glass cards with hover animations and glowing accent lines
- CSS custom properties for the theme system
- Responsive breakpoints

Open both HTML files in a browser to compare the transformation.

## Key Takeaway

The ask-gemini skill works best for design tasks when you provide both the current code
AND a visual reference. Gemini understands visual aesthetics from images and can translate
them into working CSS - glassmorphism, gradients, ambient lighting, hover states, and
responsive layouts.
