# Prompt Refinement Demo: Hero Image Generation

## Overview

Demonstrates using the ask-gemini skill to have Gemini craft an optimized image generation
prompt, then using that refined prompt with generate-image to produce the final result.

## Step 1: Ask Gemini for Prompt Help

The user had a rough concept for a GitHub README hero image. Instead of writing the prompt
directly, they asked Gemini to craft an optimized version.

### Input (user's rough concept)

```
I need to generate a hero image for a GitHub README for a project called 'GemSkills'.
The image concept is:

- The text 'GemSkills' rendered as huge 3D pixelated block letters integrated INTO a
  lush jungle scene
- The letters have moss growing on them, vines wrapping around some letters
- The scene is a creative collage where DIFFERENT art styles blend together across the
  image: watercolor areas, oil painting sections, photorealistic zones, maybe some pixel
  art patches
- NO hard separations between style zones - they blend and transition smoothly into each
  other

Please write me the BEST possible image generation prompt for Gemini's image model.
```

### Output (Gemini's refined prompt)

```
The text "GemSkills" stands monumentally in a vibrant, overgrown jungle as massive, 3D
pixelated block letters that resemble ancient digital ruins. Rich emerald moss creates a
fuzzy texture on the voxel edges, while twisting vines snake around the geometry to bind
the structure to the earth. The entire scene is a fluid artistic hallucination where
distinct mediums bleed into one another without borders; soft, translucent watercolor
washes of canopy leaves morph seamlessly into thick, impasto oil paint strokes on the
tree trunks. Zones of hyper-realistic foliage, glistening with morning dew, transition
smoothly into retro pixel-art flowers and glitchy digital flora. Dappled sunlight filters
through the multi-stylized canopy, illuminating this surreal fusion where organic nature
and creative technology coexist in a lush, harmonious collage.
```

## Step 2: Generate the Image

The refined prompt was then used with the generate-image skill:

```bash
bun run scripts/generate.ts "<refined prompt>" --aspect 16:9 --size 2K --output hero.png
```

## Result

The output image (`outputs/hero.png`) became the project's README hero image. See the
root `hero.png` for the final result.

## Key Takeaway

Gemini excels at transforming rough concepts into vivid, scene-descriptive prompts that
produce dramatically better image generation results than the original user description
would have.
