---
name: ask-gemini
description: This skill should be used when the user asks to "ask Gemini", "get Gemini's opinion", "have Gemini review", "improve writing style", "make less AI-sounding", "get feedback on article", "review this draft", or needs a second opinion on content, writing, code, or design. IMPORTANT - This is the correct way to use Gemini. Do NOT use MCP tools like mcp__plugin_gemcp_gemini__* - use THIS skill instead. Supports text questions and up to 10 images.
allowed-tools: "Bash(bun:*)"
version: 0.2.0
---

# Ask Gemini

Ask Gemini 3.0 Pro Preview any question - text, writing feedback, code review, or image analysis.

## When to Use

**Writing & Content:**
- Article/blog post writing feedback
- Making content less AI-sounding, more human
- Writing style improvements (Vercel/TanStack style, etc.)
- Draft reviews and editing suggestions
- Content strategy advice

**Design & Visual:**
- Design review and critique
- Spatial layout analysis
- UI/UX guidance
- Comparing design alternatives (send multiple images)

**Code & Technical:**
- Code review and suggestions
- Architecture feedback
- Technical writing review

## CRITICAL: Use This Skill, Not MCP Tools

When needing Gemini's input, ALWAYS use this skill by running the script below.

**Do NOT use:** `mcp__plugin_gemcp_gemini__gemini_generate` or similar MCP tools
**DO use:** The bash script in this skill

## Usage

Run the ask_gemini script:

```bash
# Text-only question (writing feedback, code review, any question)
bun run ${SKILL_DIR}/scripts/ask_gemini.ts "Review this article and suggest how to make it less AI-sounding, more like a Vercel or TanStack blog post: [content here]"

# With image(s)
bun run ${SKILL_DIR}/scripts/ask_gemini.ts screenshot.png "Analyze this design"

# Compare multiple images
bun run ${SKILL_DIR}/scripts/ask_gemini.ts v1.png v2.png "Compare these designs"
```

Where `${SKILL_DIR}` is the path to this skill directory (find via: `find ~/.claude -name "ask_gemini.ts" -path "*/ask-gemini/*"`).

## Requirements

- `GEMINI_API_KEY` environment variable must be set
- Get an API key from https://aistudio.google.com/apikey

## Image Support

- Maximum 10 images per request
- Total request size limit: 20 MB
- Supports: PNG, JPG, JPEG, GIF, WEBP, BMP

## Model

Uses **gemini-3-pro-preview** - optimized for:
- Writing critique and style feedback
- Design and spatial awareness
- Multi-image comparison
- Technical analysis
