---
name: stop-slop
version: 1.0.0
description: This skill should be used when the user wants to remove AI writing patterns from prose. Use when drafting, editing, or reviewing text to eliminate predictable AI tells.
---

# Stop Slop

Eliminate predictable AI writing patterns from prose.

Original: https://github.com/hardikpandya/stop-slop by Hardik Pandya (MIT License)

## Core Rules

1. **Cut filler phrases.** Remove throat-clearing openers and emphasis crutches. See [references/phrases.md](references/phrases.md).

2. **Avoid AI words.** Words overused by AI that signal machine-generated text. See [references/words.md](references/words.md).

3. **Break formulaic structures.** Avoid binary contrasts, dramatic fragmentation, rhetorical setups. See [references/structures.md](references/structures.md).

4. **Vary rhythm.** Mix sentence lengths. Two items beat three. End paragraphs differently.

5. **Trust readers.** State facts directly. Skip softening, justification, hand-holding.

6. **Cut quotables.** If it sounds like a pull-quote, rewrite it.

## Quick Checks

Before delivering prose:

- Three consecutive sentences match length? Break one.
- Paragraph ends with punchy one-liner? Vary it.
- Em-dash before a reveal? Remove it.
- Explaining a metaphor? Trust it to land.

## Scoring

Rate 1-10 on each dimension:

| Dimension | Question |
|-----------|----------|
| Directness | Statements or announcements? |
| Rhythm | Varied or metronomic? |
| Trust | Respects reader intelligence? |
| Authenticity | Sounds human? |
| Density | Anything cuttable? |

Below 35/50: revise.

## Examples

See [references/examples.md](references/examples.md) for before/after transformations.
