---
name: data-ml
description: Competence in data analytics and machine learning, enabling developers to build data-driven features and integrate AI/ML capabilities.
version: '1.0'
---
# Data & Machine Learning Proficiency

Software is increasingly data-driven, and developers who can handle data and ML have a strong advantage. Python’s ongoing popularity is largely due to its use in data science and machine learning. Being able to analyze datasets, use ML libraries, and incorporate AI models into applications is a sought-after skill. Whether it’s integrating an ML API or building a model in-house, understanding how these technologies work is crucial in 2025.

## Examples
- Using Python libraries like **Pandas** and **NumPy** to manipulate and analyze data for an application feature.
- Integrating a pre-trained machine learning model (e.g. image recognition, NLP) into a web service or app.

## Guidelines
- **Learn Data Tools:** Gain proficiency with data-focused languages and libraries. For example, Python paired with libraries such as NumPy and Pandas is extremely popular for data tasks. This enables you to perform analysis or preprocessing as part of your development work.
- **Understand ML Workflows:** Even if you’re not a data scientist, understand the basics of training and using machine learning models. Know how to use ML frameworks or services (TensorFlow, PyTorch, scikit-learn, or cloud ML APIs) to add AI capabilities to applications.
- **Data-Driven Decision Making:** Use data to inform development decisions. This could mean instrumenting your app with analytics (and then querying that data), or A/B testing features. A developer who can derive insights from data and adjust software accordingly will create more effective, user-optimized products.
