---
name: devops-cloud
description: Skill in automating software deployment pipelines and managing cloud infrastructure for scalable, reliable systems.
version: '1.0'
---
# DevOps & Cloud Infrastructure

DevOps and cloud skills combine software development with IT operations. Modern developers are expected to deploy and run their code in the cloud, using platforms like AWS, Azure, or GCP. In 2024, AWS was the dominant cloud platform (used by 53% of developers). Competence in cloud-native architecture and CI/CD automation ensures that software can scale and remain stable in production.

## Examples
- Setting up a CI/CD pipeline that builds, tests, and deploys an application to AWS or Azure.
- Containerizing a web service with Docker and orchestrating it with Kubernetes for scalable deployment.

## Guidelines
- **Cloud Platform Proficiency:** Learn to deploy and manage applications on cloud services (AWS, Azure, GCP). AWS remains hugely popular, used by over half of developers, due to its broad ecosystem. Knowing how to configure servers, storage, and networks in a cloud environment is key.
- **CI/CD Automation:** Embrace continuous integration and deployment. Automate build, test, and deployment workflows using tools like GitHub Actions, Jenkins, or GitLab CI. Containerization (e.g. Docker) is widely used in CI/CD pipelines to ensure consistent deployments across environments.
- **Infrastructure as Code:** Manage infrastructure with code (Terraform, CloudFormation) and configuration management. Treat operations tasks (provisioning servers, setting up load balancers, monitoring) as part of the development process to enable rapid, reliable releases.
