---
name: documentation
description: Communicating the intended behavior and context of code through clear documentation and comments, and sharing knowledge with the team.
version: '1.0'
---
# Documentation & Knowledge Sharing

Effective developers write code and documentation. This includes inline comments explaining non-obvious code and higher-level docs that describe modules and systems. Good documentation ensures that knowledge is shared, onboarding is easier, and future maintainers understand the rationale behind decisions. In 2025’s collaborative environments, this skill is invaluable for team velocity.

## Examples
- Writing a README for a project that explains how to set it up and the overall architecture.
- Adding a comment in code to clarify why a workaround is used, or marking a section as deprecated with explanation.

## Guidelines
- **Comment for Clarity:** Add explanatory comments where code isn’t self-explanatory – for example, to clarify complex algorithms, workarounds, or important decisions. A brief comment can save others (and your future self) lots of time understanding the code’s intent.
- **Keep Docs Up-to-Date:** Treat documentation as a living part of the code. Whenever code behavior changes, update relevant comments and docs accordingly. This prevents misleading information. Inline code comments should always reflect the current state of the code.
- **Project Documentation:** Adhere to your project’s documentation standards for things like API docs, developer guides, or maintainers lists. For instance, if contributing to an open-source project, ensure files like `OWNERS` are updated properly to reflect component maintainers. Proper docs ensure transparency and smooth knowledge transfer.
