---
name: service-design
description: Comprehensive service design methodology for creating sustainable solutions and optimal experiences for both customers and service providers. Use when designing end-to-end service experiences, creating customer journey maps, building service blueprints, mapping service ecosystems, identifying touchpoints and pain points, designing frontstage/backstage interactions, or improving existing service delivery. Applicable to digital services, physical services, and hybrid product-service systems.
---

# Service Design

Create sustainable solutions and optimal experiences for customers and service providers by designing holistic service ecosystems.

## Core Concept

Service design creates value by orchestrating people, processes, props, and touchpoints across the entire service experience. Unlike product design (focused on artifacts) or UX design (focused on digital interfaces), service design encompasses the complete ecosystem including frontstage customer interactions and backstage operations.

> "When you have two coffee shops right next to each other, each selling the exact same coffee at the exact same price, service design is what makes you walk into one and not the other."

## Five Principles (Stickdorn & Schneider)

1. **User-centered** – Design focusing on all users using qualitative research
2. **Co-creative** – Include all relevant stakeholders in the design process
3. **Sequencing** – Break complex services into separate processes and journey sections
4. **Evidencing** – Make service experiences tangible for users to understand and trust
5. **Holistic** – Design for all touchpoints across networks of users and interactions

## Service Components

Identify these vital parts in any service encounter:

| Component | Description | Examples |
|-----------|-------------|----------|
| **Actors** | People delivering/receiving service | Employees, customers, partners |
| **Location** | Environment where service occurs | Physical stores, digital platforms, hybrid |
| **Props** | Objects used during delivery | Devices, documents, tools, products |
| **Associates** | Partner organizations | Logistics, payment processors, suppliers |
| **Processes** | Workflows for delivery | Onboarding, fulfillment, support |

## Service Design Workflow

### Phase 1: Research & Discovery

1. **Define the service scope**
   - What service are we designing/improving?
   - Who are all the actors involved (customers AND providers)?
   - What is the current state vs. desired future state?

2. **Conduct user research**
   - Ethnographic field studies
   - Stakeholder interviews (customers, employees, partners)
   - Observation of existing service delivery
   - See `references/research-methods.md` for detailed techniques

3. **Create personas**
   - Build personas for BOTH customers AND service providers
   - Include context, goals, pain points, and journey triggers

### Phase 2: Mapping & Analysis

4. **Map the customer journey**
   - Identify all touchpoints across Pre-Service → Service → Post-Service periods
   - Document emotions, pain points, and moments of truth
   - See `references/journey-mapping.md` for templates

5. **Create service blueprint**
   - Layer customer actions with frontstage and backstage activities
   - Map support processes and physical evidence
   - Identify line of visibility and line of internal interaction
   - See `references/service-blueprints.md` for detailed structure

6. **Map the ecosystem**
   - Visualize all actors, information flows, and dependencies
   - Identify value exchanges between stakeholders
   - See `references/ecosystem-mapping.md`

### Phase 3: Ideation & Design

7. **Identify opportunities**
   - Analyze pain points and friction in current journey
   - Find gaps between customer expectations and delivery
   - Prioritize by impact and feasibility

8. **Co-create solutions**
   - Workshop with stakeholders (customers, employees, leadership)
   - Use design thinking methods: ideation, rapid prototyping
   - Design for both customer experience AND operational sustainability

9. **Design touchpoints**
   - Detail each customer interaction point
   - Define frontstage behaviors and scripts
   - Design backstage processes to support delivery

### Phase 4: Prototype & Test

10. **Prototype the service**
    - Service walkthroughs and role-playing
    - Paper prototypes for physical touchpoints
    - Clickable prototypes for digital touchpoints
    - Pilot programs with real users

11. **Test and iterate**
    - Observe service delivery with real customers
    - Gather feedback from all actors
    - Measure against success metrics
    - Refine based on learnings

### Phase 5: Implement & Measure

12. **Launch and scale**
    - Train service providers
    - Implement support systems
    - Roll out in phases

13. **Measure continuously**
    - Track service quality metrics
    - Monitor customer satisfaction
    - Gather ongoing feedback
    - Iterate based on real-world data

## Key Artifacts

| Artifact | Purpose | When to Use |
|----------|---------|-------------|
| **Customer Journey Map** | Visualize customer's end-to-end experience | Discovery, identify pain points |
| **Service Blueprint** | Connect customer journey to operations | Design, communicate to teams |
| **Ecosystem Map** | Show all actors and dependencies | Understand complexity, find partners |
| **Personas** | Humanize customer and provider needs | Research, design decisions |
| **Touchpoint Matrix** | Catalog all interaction points | Audit, prioritize improvements |
| **Service Prototype** | Test service concepts quickly | Validation before implementation |

## Frontstage vs. Backstage

**Frontstage**: Actions visible to and experienced by customers
- Customer service interactions
- Digital interfaces
- Physical environments
- Marketing communications

**Backstage**: Actions hidden from customers but essential to delivery
- Internal processes and workflows
- Employee training and tools
- Partner coordination
- Technology infrastructure

**Line of Visibility**: The boundary separating what customers see from what they don't. Design decisions here significantly impact customer perception and operational efficiency.

## Design Considerations Checklist

When designing services, ensure:

- [ ] Customer needs prioritized over internal convenience
- [ ] All actors (not just end customers) are considered
- [ ] Service is unified and consistent across touchpoints
- [ ] Backstage operations can sustainably support frontstage promises
- [ ] Value is clear and tangible to customers (evidencing)
- [ ] Processes are streamlined for efficiency
- [ ] Design accommodates edge cases and failure scenarios
- [ ] Metrics defined for measuring success
- [ ] Plan for iteration based on real-world feedback

## Deliverable Formats

- **Journey Map**: See `references/journey-mapping.md` for template
- **Service Blueprint**: See `references/service-blueprints.md` for template
- **Ecosystem Map**: See `references/ecosystem-mapping.md` for template
- **Touchpoint Inventory**: See `references/touchpoint-matrix.md`

## Related Disciplines

- **UX Design**: Focuses on digital touchpoints within the broader service
- **CX Design**: Encompasses all customer touchpoints but may not include backstage
- **Service Design**: Highest scope—includes CX plus business processes, systems, and operations

## References

For detailed templates and methods:
- `references/journey-mapping.md` – Customer journey map templates and examples
- `references/service-blueprints.md` – Blueprint structure and creation guide
- `references/ecosystem-mapping.md` – Ecosystem visualization methods
- `references/research-methods.md` – User research techniques for services
- `references/touchpoint-matrix.md` – Touchpoint inventory template

## Sources & Attribution

### Primary Source

- **Interaction Design Foundation (IxDF)** – "What is Service Design?"
  https://www.interaction-design.org/literature/topics/service-design
  - Core definition and scope (SKILL.md)
  - "Two coffee shops" quote, attributed to 31Volts Service Design Studio (SKILL.md)
  - Five principles framework (SKILL.md)
  - Service components: Actors, Location, Props, Associates, Processes (SKILL.md)
  - Frontstage/backstage distinction and line of visibility (SKILL.md, service-blueprints.md)
  - UX vs CX vs Service Design scope comparison (SKILL.md)

### Foundational Works (via IxDF)

- **Stickdorn, M. & Schneider, J.** – *This is Service Design Thinking* (2011)
  - Five principles: user-centered, co-creative, sequencing, evidencing, holistic (SKILL.md)

- **Shostack, G. Lynn** – "How to Design a Service" (1982), European Journal of Marketing
  - Service blueprint concept and structure (service-blueprints.md)

- **Shostack, G. Lynn** – "Designing Services That Deliver" (1984), Harvard Business Review
  - Blueprint layers and lines of visibility/interaction (service-blueprints.md)

### Further Reading

- Service Design Network: https://www.service-design-network.org/
- Nielsen Norman Group service design articles: https://www.nngroup.com/topic/service-design/