# Research Methods for Service Design

## Overview

Service design research focuses on understanding the complete service ecosystem—customers, employees, partners, and processes. Research must capture both the visible customer experience and the invisible operational reality.

## Research Method Selection

| Method | Best For | Time | Resources |
|--------|----------|------|-----------|
| **Contextual Interviews** | Understanding current experience | 2-3 weeks | Medium |
| **Service Safari** | Experiencing competitor services | 1-2 weeks | Low |
| **Shadowing** | Understanding employee perspective | 1-2 weeks | Medium |
| **Journey Diaries** | Capturing longitudinal experience | 4-6 weeks | Low |
| **Co-creation Workshops** | Generating solutions with stakeholders | 1-2 days | Medium |
| **Service Walkthroughs** | Testing service concepts | 1-2 weeks | Medium |
| **Data Analysis** | Understanding patterns at scale | 1-2 weeks | Medium |

## Customer Research Methods

### Contextual Interviews
Interview customers in the context where they use the service.

**When to use:** Understanding current experience, pain points, needs

**Protocol:**
1. Observe customer in context (home, workplace, service location)
2. Ask them to walk through their typical process
3. Probe on emotions, challenges, workarounds
4. Capture quotes, environment photos, artifacts

**Questions:**
- "Walk me through the last time you..."
- "What was the hardest part?"
- "How did you feel when...?"
- "What would make this easier?"

### Journey Diaries
Have customers document their experience over time.

**When to use:** Understanding longitudinal experience, capturing real moments

**Protocol:**
1. Recruit participants who will use service during study period
2. Provide simple logging method (app, notebook, messages)
3. Ask them to capture each touchpoint: what, when, how they felt
4. Follow up with interview to explore key moments

**Diary prompts:**
- What did you do? (action)
- Where were you? (context)
- How did you feel? (emotion)
- What helped or hindered? (friction/enablers)

### Service Safari
Experience competitor or analogous services firsthand.

**When to use:** Understanding competitive landscape, finding inspiration

**Protocol:**
1. Identify comparable services to evaluate
2. Go through the complete customer journey yourself
3. Document every touchpoint, emotion, and observation
4. Analyze what works, what doesn't, and why

**Observation points:**
- First impressions
- Moments of delight
- Points of friction
- Physical evidence quality
- Employee interactions
- Overall emotional arc

## Employee/Provider Research

### Shadowing
Follow employees through their work to understand backstage reality.

**When to use:** Understanding operational constraints, employee experience

**Protocol:**
1. Get permission from organization and individuals
2. Shadow different roles across the service
3. Observe without interrupting (ask questions during breaks)
4. Document processes, tools, challenges, workarounds

**Observation focus:**
- Daily workflow and routines
- Tools and systems used
- Communication patterns
- Pain points and frustrations
- Workarounds and adaptations
- Moments of pride

### Employee Interviews
Structured conversations with service providers.

**When to use:** Understanding backstage perspective, organizational constraints

**Questions:**
- "Describe a typical day in your role"
- "What's the most challenging part of serving customers?"
- "What do you wish you could do differently?"
- "What tools or support would help you?"
- "Tell me about a time when service went really well/poorly"

## Collaborative Research Methods

### Co-creation Workshops
Bring together stakeholders to generate and evaluate ideas.

**When to use:** Generating solutions, aligning stakeholders, building buy-in

**Workshop structure:**
1. **Share** (30 min): Present research findings
2. **Ideate** (60 min): Generate ideas individually and in groups
3. **Build** (60 min): Prototype promising concepts
4. **Critique** (30 min): Get feedback from all perspectives
5. **Prioritize** (30 min): Vote on ideas to pursue

**Participants to include:**
- Customers (different segments)
- Front-line employees
- Backstage employees
- Partners
- Leadership

### Service Walkthroughs
Test service concepts by walking through them.

**When to use:** Evaluating service designs, identifying gaps

**Protocol:**
1. Create rough prototypes of service touchpoints
2. Recruit representative users and employees
3. Walk through the journey step by step
4. Ask participants to think aloud
5. Capture reactions, confusion, and suggestions

**Prototype elements:**
- Physical environment mockups
- Interface wireframes
- Scripts for interactions
- Props and artifacts

## Quantitative Research

### Service Analytics
Analyze existing data to understand service patterns.

**Data sources:**
- Customer journey analytics
- Support ticket analysis
- NPS and satisfaction surveys
- Operational metrics
- Employee performance data

**Analysis approaches:**
- Journey drop-off analysis
- Time-to-completion patterns
- Correlation between touchpoints and satisfaction
- Segment comparison
- Trend analysis over time

### Survey Research
Gather input from larger populations.

**When to use:** Validating findings, measuring satisfaction, segmentation

**Survey topics:**
- Service satisfaction (CSAT, NPS)
- Touchpoint evaluation
- Need prioritization
- Effort scores (CES)
- Demographic and behavioral segmentation

## Synthesis Approaches

### Affinity Mapping
Group research findings into themes.

**Process:**
1. Write each observation on a sticky note
2. Cluster related notes together
3. Name the clusters (themes)
4. Identify relationships between themes
5. Prioritize themes by frequency and impact

### Customer Journey Synthesis
Combine research into journey map.

**Process:**
1. Map all touchpoints mentioned in research
2. Plot emotional highs and lows from customer quotes
3. Note pain points at each stage
4. Identify moments of truth
5. Highlight opportunities

### Service Blueprint Synthesis
Connect customer research to operational insights.

**Process:**
1. Start with customer journey
2. Add frontstage employee actions from shadowing
3. Add backstage processes from employee interviews
4. Map support systems from technical research
5. Mark fail points and dependencies

## Research Planning

### Sample Size Guidelines

| Method | Minimum | Ideal |
|--------|---------|-------|
| Interviews | 8-12 | 15-20 |
| Shadowing | 3-5 | 8-10 |
| Surveys | 100+ | 300+ |
| Workshops | 6-8 | 10-12 |
| Diaries | 8-10 | 15-20 |

### Research Participant Mix

For comprehensive service understanding, include:
- Multiple customer segments
- Heavy and light users
- New and long-term customers
- Front-line employees (multiple roles)
- Backstage employees
- Partners and suppliers
- Leadership/decision-makers

## Research Ethics

- Obtain informed consent
- Protect participant privacy
- Compensate participants fairly
- Share findings with participants when possible
- Don't observe employees without their knowledge
- Handle sensitive data appropriately
