# Card News Generator V2 - Background Image Features

## What's New in V2

카드 뉴스 생성기 V2에서는 **배경 이미지 기능**이 추가되었습니다. 이제 단색 배경뿐만 아니라 실제 사진을 배경으로 사용할 수 있습니다.

### Key Features

1. **배경 이미지 지원**
   - 폴더에 있는 이미지 파일을 카드 배경으로 자동 적용
   - JPG, PNG, WebP, BMP 등 다양한 포맷 지원

2. **자동 크롭 및 리사이징**
   - 이미지를 600x600 크기로 자동 조정
   - 가로세로 비율 유지하며 중앙 크롭

3. **다크 오버레이**
   - 텍스트 가독성을 위한 어두운 오버레이 자동 적용
   - 불투명도 조절 가능 (0.0 ~ 1.0)

4. **자동 텍스트 색상 전환**
   - 배경 이미지 사용 시 텍스트가 자동으로 흰색으로 변경

## Quick Start

### 1. 배경 이미지 준비

이미지를 순서대로 정렬된 이름으로 저장하세요:

```
my-images/
├── 01.jpg
├── 02.jpg
├── 03.jpg
├── 04.jpg
└── 05.jpg
```

### 2. 카드 뉴스 생성

```bash
python auto_generator.py \
  --topic "여행 팁" \
  --output-dir ./output \
  --base-filename "travel" \
  --image-folder ./my-images \
  --overlay-opacity 0.6 << 'EOF'
1. 짐 싸기
최소한으로
가볍게 여행하기

2. 현지 음식
맛집 찾는
나만의 방법

3. 교통수단
대중교통 활용
팁과 노하우

4. 숙소 예약
가성비 좋은
숙소 찾기

5. 안전 여행
여행 중
안전 체크리스트
EOF
```

### 3. 결과 확인

생성된 카드 이미지:
- `travel_01.png` - 배경: 01.jpg + "짐 싸기" 내용
- `travel_02.png` - 배경: 02.jpg + "현지 음식" 내용
- `travel_03.png` - 배경: 03.jpg + "교통수단" 내용
- `travel_04.png` - 배경: 04.jpg + "숙소 예약" 내용
- `travel_05.png` - 배경: 05.jpg + "안전 여행" 내용

## Parameters Explained

### `--image-folder`

배경 이미지가 들어있는 폴더 경로를 지정합니다.

```bash
--image-folder /path/to/images
```

- 폴더 내 이미지는 알파벳/숫자 순으로 정렬되어 사용됩니다
- 카드 1번에는 첫 번째 이미지, 2번에는 두 번째 이미지가 적용됩니다
- 이미지 수가 카드 수보다 적으면 나머지는 단색 배경으로 생성됩니다

### `--overlay-opacity`

배경 이미지 위에 적용할 어두운 오버레이의 불투명도를 설정합니다.

```bash
--overlay-opacity 0.6
```

**값 범위:** 0.0 ~ 1.0
- `0.0`: 오버레이 없음 (원본 이미지 그대로)
- `0.3`: 약한 오버레이 (밝은 이미지에 적합)
- `0.5`: 중간 오버레이 (**기본값**, 대부분의 이미지에 적합)
- `0.6`: 강한 오버레이 (어두운 텍스트가 필요한 경우)
- `0.8`: 매우 강한 오버레이 (매우 밝은 이미지)
- `1.0`: 완전히 검은색 (거의 사용하지 않음)

**추천 값:**
- 밝은 사진 (하늘, 눈, 해변): `0.6 ~ 0.7`
- 보통 사진 (풍경, 인물): `0.5 ~ 0.6` ⭐ 추천
- 어두운 사진 (실내, 저녁): `0.3 ~ 0.5`

## Single Card Example

단일 카드에 배경 이미지를 적용하려면:

```bash
python generate_card.py \
  --title "여행 팁" \
  --content "최소한의 짐으로\n가볍게 여행하기" \
  --bg-image ./my-images/01.jpg \
  --overlay-opacity 0.6 \
  --number 1 \
  --output ./output/card_01.png
```

## Tips & Best Practices

### 이미지 선택

✅ **좋은 배경 이미지:**
- 고화질 이미지 (최소 600x600px 이상)
- 중앙에 주요 피사체가 있는 이미지
- 색상이 균일하지 않고 다양한 이미지
- 컨트라스트가 좋은 이미지

❌ **피해야 할 배경 이미지:**
- 저화질/흐릿한 이미지
- 텍스트가 들어간 이미지 (겹칠 수 있음)
- 너무 어두운 이미지 (오버레이 후 가독성 떨어짐)
- 복잡한 패턴의 이미지 (텍스트 읽기 어려움)

### 오버레이 조정

이미지가 너무 밝아서 텍스트가 잘 안 보인다면:
```bash
--overlay-opacity 0.7  # 더 어둡게
```

이미지가 이미 어두워서 텍스트가 묻힌다면:
```bash
--overlay-opacity 0.3  # 더 밝게
```

### 파일 이름 규칙

이미지 파일명은 정렬 순서가 중요합니다:

✅ **좋은 예:**
```
01.jpg, 02.jpg, 03.jpg, ...
img_001.png, img_002.png, ...
a_photo.jpg, b_photo.jpg, c_photo.jpg
```

❌ **나쁜 예:**
```
1.jpg, 2.jpg, 10.jpg, 11.jpg  # 정렬 순서가 1, 10, 11, 2가 됨
photo.jpg, image.jpg, pic.jpg  # 순서를 알 수 없음
```

## Comparison: V1 vs V2

### V1 (Solid Color Only)

```bash
python auto_generator.py \
  --topic "주제" \
  --bg-color "#f5f3ee" \
  --text-color "#1a1a1a" \
  --output-dir ./output
```

- 단색 배경만 가능
- 색상 선택 제한적
- 빠른 생성 속도

### V2 (With Background Images)

```bash
python auto_generator.py \
  --topic "주제" \
  --image-folder ./images \
  --overlay-opacity 0.6 \
  --output-dir ./output
```

- 실제 사진을 배경으로 사용
- 더 풍부한 시각적 표현
- 자동 이미지 처리
- 약간 느린 생성 속도 (이미지 로딩 시간)

## Troubleshooting

### 문제: 이미지가 로드되지 않습니다

**원인:** 이미지 폴더 경로가 잘못되었거나 지원하지 않는 포맷

**해결:**
1. 폴더 경로를 확인하세요
2. 지원 포맷 확인: `.jpg`, `.jpeg`, `.png`, `.webp`, `.bmp`
3. 파일 권한 확인

### 문제: 텍스트가 잘 보이지 않습니다

**원인:** 배경 이미지가 너무 밝거나 복잡함

**해결:**
1. `--overlay-opacity` 값을 높이세요 (0.7 ~ 0.8)
2. 더 단순한 배경 이미지를 선택하세요
3. 이미지를 직접 어둡게 편집 후 사용하세요

### 문제: 이미지 순서가 이상합니다

**원인:** 파일명 정렬 순서 문제

**해결:**
1. 파일명을 `01.jpg`, `02.jpg` 형식으로 변경
2. 앞에 0을 붙여서 정렬 보장 (예: 01, 02, ... 10, 11)

### 문제: 이미지가 잘립니다

**원인:** 이미지의 가로세로 비율이 정사각형이 아님

**해결:**
- 이것은 정상입니다. 600x600 정사각형으로 맞추기 위해 중앙을 기준으로 크롭됩니다
- 중요한 부분이 중앙에 오도록 이미지를 선택하거나 편집하세요

## Examples Gallery

### Example 1: Travel Cards

**주제:** 여행 팁
**배경:** 여행 사진 5장
**오버레이:** 0.6
**결과:** 밝고 생동감 있는 여행 팁 카드

### Example 2: Food Cards

**주제:** 건강한 식습관
**배경:** 음식 사진 7장
**오버레이:** 0.5
**결과:** 식욕을 돋우는 건강 정보 카드

### Example 3: Tech Cards

**주제:** 개발 팁
**배경:** 코드/컴퓨터 이미지
**오버레이:** 0.7
**결과:** 전문적인 느낌의 개발 팁 카드

## Next Steps

1. 자신만의 이미지 폴더를 준비하세요
2. 다양한 `--overlay-opacity` 값을 테스트해보세요
3. 생성된 카드를 Instagram, Facebook 등에 공유하세요!

## Feedback & Contribution

개선 사항이나 버그를 발견하시면 알려주세요!
